/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters.where;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import liqp.TemplateContext;
import liqp.filters.where.PropertyResolverAdapter;
import liqp.filters.where.PropertyResolverHelper;
import liqp.filters.where.WhereImpl;

public class LiquidWhereImpl
extends WhereImpl {
    public LiquidWhereImpl(TemplateContext mapper, PropertyResolverHelper helper) {
        super(mapper, helper);
    }

    @Override
    public Object apply(Object input, Object ... params) {
        Object[] objects = LiquidWhereImpl.toArray(input);
        if (objects.length == 0) {
            return objects;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object el : objects) {
            if (!this.objectHasPropertyValue(el, params)) continue;
            res.add(el);
        }
        return res.toArray();
    }

    private boolean objectHasPropertyValue(Object el, Object[] params) {
        Object node;
        Object rawProperty = params[0];
        String property = this.asString(rawProperty, this.context);
        PropertyResolverAdapter resolver = this.resolverHelper.findFor(el);
        ObjectMapper mapper = this.context.parseSettings.mapper;
        if (resolver != null) {
            node = resolver.getItemProperty(this.context, el, rawProperty);
        } else {
            Map map = (Map)mapper.convertValue(el, Map.class);
            if (!map.containsKey(property)) {
                return false;
            }
            node = map.get(property);
        }
        if (params.length == 1) {
            return this.asBoolean(node);
        }
        Object value = params[1];
        JsonNode jsonNode = (JsonNode)mapper.convertValue(node, JsonNode.class);
        JsonNode jsonProperty = (JsonNode)mapper.convertValue(value, JsonNode.class);
        return Objects.equals(jsonNode, jsonProperty);
    }

    private static List<Object> flatten(Object object) {
        ArrayList<Object> l = new ArrayList<Object>();
        if (object == null) {
            return l;
        }
        if (object.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                l.addAll(LiquidWhereImpl.flatten(Array.get(object, i)));
            }
        } else if (object instanceof Collection) {
            for (Object element : (List)object) {
                l.addAll(LiquidWhereImpl.flatten(element));
            }
        } else {
            l.add(object);
        }
        return l;
    }

    private static Object[] toArray(Object object) {
        if (object == null) {
            return new Object[0];
        }
        if (object.getClass().isArray()) {
            return LiquidWhereImpl.flatten(object).toArray();
        }
        if (object instanceof Map) {
            return new Object[]{object};
        }
        if (object instanceof Collection) {
            return LiquidWhereImpl.flatten(object).toArray();
        }
        return new Object[]{object};
    }
}

