//--------------------------------------------------------------
// Gaussian Blur
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Gaussian Blur", "Stylize", "Components", kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( Amount,   "Amount", kNoGroup, kNoFlags, 0.5, 0.0, 1.0 );
DeclareBoolParam( RedBlur,   "Red",   "Channels", true );
DeclareBoolParam( GreenBlur, "Green", "Channels", true );
DeclareBoolParam( BlueBlur,  "Blue",  "Channels", true );
DeclareBoolParam( AlphaBlur, "Alpha", "Channels", false );

DeclareFloatParam( _OutputWidth );
DeclareFloatParam( _OutputHeight );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------

float gaussian[] = { 1.0 / 4096.0, 12.0 / 4096.0, 66.0 / 4096.0, 220.0 / 4096.0, 495.0 / 4096.0, 792.0 / 4096.0, 924.0 / 4096.0 };

DeclarePass( BlurX )
{
   float one       = Amount / _OutputWidth;
   float tap_2_3   = uv1.x + one;
   float tap_4_5   = tap_2_3 + one;
   float tap_6_7   = tap_4_5 + one;;
   float tap_8_9   = tap_6_7 + one;
   float tap_10_11  = tap_8_9 + one;
   float tap_12_13 = tap_10_11 + one;
   float ntap_2_3   = uv1.x - one;
   float ntap_4_5   = ntap_2_3 - one;
   float ntap_6_7   = ntap_4_5 - one;;
   float ntap_8_9   = ntap_6_7 - one;
   float ntap_10_11 = ntap_8_9 - one;
   float ntap_12_13 = ntap_10_11 - one;

   float4 ret     = tex2D( Input, uv1 );
   float4 blurred = ret * gaussian[ 6 ];

   blurred += tex2D( Input, float2( tap_2_3,    uv1.y ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( tap_4_5,    uv1.y ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( tap_6_7,    uv1.y ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( tap_8_9,    uv1.y ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( tap_10_11,  uv1.y ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( tap_12_13,  uv1.y ) ) * gaussian[ 0 ];

   blurred += tex2D( Input, float2( ntap_2_3,   uv1.y ) ) * gaussian[ 5 ];
   blurred += tex2D( Input, float2( ntap_4_5,   uv1.y ) ) * gaussian[ 4 ];
   blurred += tex2D( Input, float2( ntap_6_7,   uv1.y ) ) * gaussian[ 3 ];
   blurred += tex2D( Input, float2( ntap_8_9,   uv1.y ) ) * gaussian[ 2 ];
   blurred += tex2D( Input, float2( ntap_10_11, uv1.y ) ) * gaussian[ 1 ];
   blurred += tex2D( Input, float2( ntap_12_13, uv1.y ) ) * gaussian[ 0 ];

   if ( RedBlur )
   {
      ret.r = blurred.r;
   }

   if ( GreenBlur )
   {
      ret.g = blurred.g;
   }

   if ( BlueBlur )
   {
      ret.b = blurred.b;
   }

   if ( AlphaBlur )
   {
      ret.a = blurred.a;
   }

   return ret;
}

DeclareEntryPoint( BlurY )
{
   float one       = Amount / _OutputHeight;
   float tap_2_3   = uv1.y + one;
   float tap_4_5   = tap_2_3 + one;
   float tap_6_7   = tap_4_5 + one;;
   float tap_8_9   = tap_6_7 + one;
   float tap_10_11  = tap_8_9 + one;
   float tap_12_13 = tap_10_11 + one;

   float ntap_2_3   = uv1.y - one;
   float ntap_4_5   = ntap_2_3 - one;
   float ntap_6_7   = ntap_4_5 - one;;
   float ntap_8_9   = ntap_6_7 - one;
   float ntap_10_11 = ntap_8_9 - one;
   float ntap_12_13 = ntap_10_11 - one;

   float4 ret =  tex2D( BlurX, uv1 );
   float4 blurred = ret * gaussian[ 6 ];
   blurred += tex2D( BlurX, float2( uv1.x, tap_2_3    ) ) * gaussian[ 5 ];
   blurred += tex2D( BlurX, float2( uv1.x, tap_4_5    ) ) * gaussian[ 4 ];
   blurred += tex2D( BlurX, float2( uv1.x, tap_6_7    ) ) * gaussian[ 3 ];
   blurred += tex2D( BlurX, float2( uv1.x, tap_8_9    ) ) * gaussian[ 2 ];
   blurred += tex2D( BlurX, float2( uv1.x, tap_10_11  ) ) * gaussian[ 1 ];
   blurred += tex2D( BlurX, float2( uv1.x, tap_12_13  ) ) * gaussian[ 0 ];

   blurred += tex2D( BlurX, float2( uv1.x, ntap_2_3   ) ) * gaussian[ 5 ];
   blurred += tex2D( BlurX, float2( uv1.x, ntap_4_5   ) ) * gaussian[ 4 ];
   blurred += tex2D( BlurX, float2( uv1.x, ntap_6_7   ) ) * gaussian[ 3 ];
   blurred += tex2D( BlurX, float2( uv1.x, ntap_8_9   ) ) * gaussian[ 2 ];
   blurred += tex2D( BlurX, float2( uv1.x, ntap_10_11 ) ) * gaussian[ 1 ];
   blurred += tex2D( BlurX, float2( uv1.x, ntap_12_13 ) ) * gaussian[ 0 ];

   if ( RedBlur )
   {
      ret.r = blurred.r;
   }

   if ( GreenBlur )
   {
      ret.g = blurred.g;
   }

   if ( BlueBlur )
   {
      ret.b = blurred.b;
   }

   float4 source = tex2D( Input, uv1 );
   ret = lerp( source, ret, source.a );

   if ( AlphaBlur )
   {
      ret.a = blurred.a;
   }

   return ret;
}
