//--------------------------------------------------------------
// Colour Tint
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Colour Tint", "Colour", "Components", kNoNotes, "CanSize" );

// Params ------------------------------------------------------

DeclareColourParam( TintColour, "Tint Colour", kNoGroup, kNoFlags, 1.0, 1.0, 1.0, 1.0 );
DeclareFloatParam( Amount, "Amount", kNoGroup, kNoFlags, 0.5, 0.0, 1.0 );

// Inputs ------------------------------------------------------

DeclareInput( Input );
DeclareMask;

// Code --------------------------------------------------------

DeclareEntryPoint()
{
   float4 src = ReadPixel( Input, uv1 );
   float lum = ( src.r * 0.3 ) + ( src.g * 0.59 ) + ( src.b * 0.11 );

   float4 tintedPixel = float4( lum + TintColour.r - 0.5,
                                lum + TintColour.g - 0.5,
                                lum + TintColour.b - 0.5,
                                1.0 );

   float4 ret = lerp( src, tintedPixel, Amount * src.a );
   ret.a = src.a;

   return lerp( src, ret, tex2D( Mask, uv1 ) );
}
