//--------------------------------------------------------------//
// RGB8ToARGB_FlipVertical
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
DeclareLightworksEffect( NULL, Internal, Colour, kNoNotes, kNoFlags );

DeclareInput( Input, Point );

DeclareFloatParam( _Width );

DeclareEntryPoint()
{
   float4 ret;

   int x = int( fmod( uv1.x * _Width, 4 ) );

   // shift a quarter pixel right, invert
   float2 uv1Flipped = float2( uv1.x + 0.25 / _Width, 1.0 - uv1.y );
   float2 uv2Flipped = float2( uv2.x, 1.0 - uv2.y );

   if ( x == 0 )
   {
      float4 src = tex2D( Input, uv1Flipped );

      ret.b = src.b;
      ret.g = src.g;
      ret.r = src.r;
   }
   else if ( x == 1 )
   {
      float4 srcl = tex2D( Input, uv2Flipped );
      float4 srcr = tex2D( Input, uv1Flipped );

      ret.b = srcl.a;
      ret.g = srcr.b;
      ret.r = srcr.g;
   }
   else if ( x == 2 )
   {
      float4 srcl = tex2D( Input, uv2Flipped );
      float4 srcr = tex2D( Input, uv1Flipped );

      ret.b = srcl.r;
      ret.g = srcl.a;
      ret.r = srcr.b;
   }
   else if ( x == 3 )
   {
      float4 src = tex2D( Input, uv1Flipped );

      ret.b = src.g;
      ret.g = src.r;
      ret.r = src.a;
   }

   ret.a = 1.;

   return ret;
}
