//--------------------------------------------------------------
// MatrixWipe.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( MatrixWipe, Mix, Internal, kNoNotes, CanSize );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParam( XRepeat, "Across", "Repeats", kNoFlags, 1.0, 0.5, 50.0 );
DeclareFloatParam( YRepeat, "Across", "Repeats", kNoFlags, 1.0, 0.5, 50.0 );
DeclareFloatParam( BorderWidth, "Size", "Border", kNoFlags, 0.0, 0.0, 1.0 );
DeclareColourParam( BorderColour1, "Colour one", "Border", kNoFlags, 1.0, 1.0, 0.0, 1.0 );
DeclareColourParam( BorderColour2, "Colour two", "Border", kNoFlags, 1.0, 0.0, 0.0, 1.0 );
DeclareFloatParam( Softness, "Softness", kNoGroup, kNoFlags, 0.2, 0.0, 1.0 );
DeclareFloatParamAnimated( Progress, "Progress", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 );
DeclareBoolParam( Invert, "Reverse", kNoGroup, false );
DeclareFloatParam( XPos, "Horizontal Position", "Position", kNoFlags, 0.5, -0.5, 1.5 );
DeclareFloatParam( YPos, "Vertical Position", "Position", kNoFlags, 0.5, -0.5, 1.5 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInputs( fg, bg );
DeclareInput( tex, Point );

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   // Calc texture address (based on x/y repeats)

   float2 xy0 = frac( float2( XPos, YPos ) - ( ( float2( XPos, YPos ) - uv0 ) * float2( XRepeat, YRepeat ) ) );

   float4 texPix = tex2D( tex, xy0 );
   float luma = ( texPix.r + texPix.g + texPix.b ) / 3.0;

   float totalEdgeSize = Softness + BorderWidth;
   float halfSoftness  = ( Softness / 2.0 );
   float edgeSoftStart = ( Progress * ( 1.0 + totalEdgeSize ) ) - totalEdgeSize;
   float borderStart   = edgeSoftStart + halfSoftness;
   float borderEnd     = borderStart + BorderWidth;
   float edgeSoftEnd   = borderEnd + halfSoftness;

   float4 ret;
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   luma = lerp( luma, 1.0 - luma, Invert );

   if ( luma > edgeSoftEnd )
   {
      ret = fgPix;
   }
   else if ( luma < edgeSoftStart )
   {
      ret = bgPix;
   }
   else
   {
      float lumaMinusEdgeStart =  luma - edgeSoftStart;

      if ( BorderWidth == 0 )
      {
         ret = lerp( bgPix, fgPix, lumaMinusEdgeStart / Softness );
      }
      else
      {
         float4 borderColour = lerp( BorderColour1, BorderColour2, lumaMinusEdgeStart / totalEdgeSize );

         if ( luma < borderStart )
            ret = lerp( bgPix, borderColour, lumaMinusEdgeStart / halfSoftness );
         else if ( luma > borderEnd )
            ret = lerp( fgPix, borderColour, ( edgeSoftEnd - luma ) / halfSoftness );
         else
            ret = borderColour;
      }
   }

   return ret;
}

