/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MppDump {
    private static final int BUFFER_SIZE = 16;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: MppDump <input mpp file name> <output text file name>");
            } else {
                System.out.println("Dump started.");
                long start = System.currentTimeMillis();
                MppDump.process(args[0], args[1]);
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("Dump completed in " + elapsed + "ms");
            }
        }
        catch (Exception ex) {
            System.out.println("Caught " + ex);
        }
    }

    private static void process(String input, String output) throws Exception {
        FileInputStream is = new FileInputStream(input);
        PrintWriter pw = new PrintWriter(new FileWriter(output));
        POIFSFileSystem fs = new POIFSFileSystem(is);
        MppDump.dumpTree(pw, fs.getRoot(), "", true, true, null);
        is.close();
        pw.flush();
        pw.close();
        fs.close();
    }

    private static void dumpTree(PrintWriter pw, DirectoryEntry dir, String prefix, boolean showData, boolean hex, String indent) throws Exception {
        Iterator<Entry> iter = dir.getEntries();
        while (iter.hasNext()) {
            Entry entry = iter.next();
            if (entry instanceof DirectoryEntry) {
                String childIndent = indent;
                if (childIndent != null) {
                    childIndent = childIndent + " ";
                }
                String childPrefix = prefix + "[" + entry.getName() + "].";
                pw.println("start dir: " + prefix + entry.getName());
                MppDump.dumpTree(pw, (DirectoryEntry)entry, childPrefix, showData, hex, childIndent);
                pw.println("end dir: " + prefix + entry.getName());
                continue;
            }
            if (entry instanceof DocumentEntry) {
                if (showData) {
                    pw.println("start doc: " + prefix + entry.getName());
                    long byteCount = hex ? MppDump.hexdump(new DocumentInputStream((DocumentEntry)entry), pw) : MppDump.asciidump(new DocumentInputStream((DocumentEntry)entry), pw);
                    pw.println("end doc: " + prefix + entry.getName() + " (" + byteCount + " bytes read)");
                    continue;
                }
                if (indent != null) {
                    pw.print(indent);
                }
                pw.println("doc: " + prefix + entry.getName());
                continue;
            }
            pw.println("found unknown: " + prefix + entry.getName());
        }
    }

    private static long hexdump(InputStream is, PrintWriter pw) throws Exception {
        int count;
        byte[] buffer = new byte[16];
        long byteCount = 0L;
        StringBuilder sb = new StringBuilder();
        while ((count = is.read(buffer)) != -1) {
            int loop;
            byteCount += (long)count;
            sb.setLength(0);
            for (loop = 0; loop < count; ++loop) {
                sb.append(" ");
                sb.append(HEX_DIGITS[(buffer[loop] & 0xF0) >> 4]);
                sb.append(HEX_DIGITS[buffer[loop] & 0xF]);
            }
            while (loop < 16) {
                sb.append("   ");
                ++loop;
            }
            sb.append("   ");
            for (loop = 0; loop < count; ++loop) {
                char c = (char)buffer[loop];
                if (c > '\u00c8' || c < '\u001b') {
                    c = ' ';
                }
                sb.append(c);
            }
            pw.println(sb);
        }
        return byteCount;
    }

    private static long asciidump(InputStream is, PrintWriter pw) throws Exception {
        int count;
        byte[] buffer = new byte[16];
        long byteCount = 0L;
        StringBuilder sb = new StringBuilder();
        while ((count = is.read(buffer)) != -1) {
            byteCount += (long)count;
            sb.setLength(0);
            for (int loop = 0; loop < count; ++loop) {
                char c = (char)buffer[loop];
                if (c > '\u00c8' || c < '\u001b') {
                    c = ' ';
                }
                sb.append(c);
            }
            pw.print(sb);
        }
        return byteCount;
    }
}

