/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftInterval;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class RedshiftIntervalDayToSecond
extends RedshiftInterval
implements Serializable,
Cloneable {
    public RedshiftIntervalDayToSecond() {
        this.setType("intervald2s");
    }

    public RedshiftIntervalDayToSecond(String value) throws SQLException {
        this();
        this.setValue(value);
        if (this.getYears() != 0 || this.getMonths() != 0) {
            throw new RedshiftException("Invalid value for Interval Day To Second. Value cannot contain year-month parts.");
        }
    }

    public RedshiftIntervalDayToSecond(int days, int hours, int minutes, double seconds) throws SQLException {
        this();
        super.setValue(0, 0, days, hours, minutes, seconds);
        this.setValue(this.totalMicroseconds());
    }

    public RedshiftIntervalDayToSecond(long time) throws SQLException {
        this();
        this.setValue(0, time);
    }

    public void setValue(long time) {
        super.setValue(0, time);
    }

    @Override
    public void setValue(int month, long time) {
        assert (month == 0);
        super.setValue(0, time);
    }

    @Override
    public void setYears(int years) {
        assert (years == 0);
        super.setYears(0);
    }

    @Override
    public void setMonths(int months) {
        assert (months == 0);
        super.setMonths(0);
    }

    @Override
    public String getValue() {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        df.applyPattern("0.0#####");
        return String.format(Locale.ROOT, "%d days %d hours %d mins %s secs", this.getDays(), this.getHours(), this.getMinutes(), df.format(this.getSeconds()));
    }

    public void add(RedshiftIntervalDayToSecond interval) {
        interval.setValue(0, this.totalMicroseconds() + interval.totalMicroseconds());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RedshiftIntervalDayToSecond)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RedshiftIntervalDayToSecond pgi = (RedshiftIntervalDayToSecond)obj;
        return pgi.getDays() == this.getDays() && pgi.getHours() == this.getHours() && pgi.getMinutes() == this.getMinutes() && pgi.getWholeSeconds() == this.getWholeSeconds() && pgi.getMicroSeconds() == this.getMicroSeconds();
    }
}

