/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cell;

import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;

public final class PCell
extends PythonAbstractObject {
    private final Assumption effectivelyFinal;
    private Object ref;

    public PCell(Assumption effectivelyFinalAssumption) {
        this.effectivelyFinal = effectivelyFinalAssumption;
    }

    public static PCell[] toCellArray(Object[] closure) {
        PCell[] cells = new PCell[closure.length];
        PythonUtils.arraycopy(closure, 0, cells, 0, closure.length);
        return cells;
    }

    public Object getRef() {
        return this.ref;
    }

    public void clearRef(Assumption assumption) {
        this.setRef(null, assumption);
    }

    public void clearRef() {
        this.setRef(null);
    }

    @CompilerDirectives.TruffleBoundary
    private static void invalidateAssumption(Assumption assumption) {
        assumption.invalidate();
    }

    public void setRef(Object ref) {
        if (this.ref != null) {
            PCell.invalidateAssumption(this.effectivelyFinal);
        }
        this.ref = ref;
    }

    public void setRef(Object ref, Assumption constantAssumption) {
        assert (constantAssumption == this.effectivelyFinal);
        if (constantAssumption.isValid() && this.ref != null) {
            PCell.invalidateAssumption(constantAssumption);
        }
        this.ref = ref;
    }

    public Assumption isEffectivelyFinalAssumption() {
        return this.effectivelyFinal;
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.ref == null) {
            return String.format("<cell at %s: empty>", this.hashCode());
        }
        return String.format("<cell at %s: %s object at %s>", this.hashCode(), this.ref.getClass().getSimpleName(), this.ref.hashCode());
    }

    @Override
    public int compareTo(Object o) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }
}

