/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.OutputSigner;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SignatureOperatorFactory;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricLMSPublicKey;
import org.bouncycastle.crypto.fips.FipsLMS;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvLMSPrivateKey;
import org.bouncycastle.jcajce.provider.ProvLMSPublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.LMSHSSKeyGenParameterSpec;
import org.bouncycastle.jcajce.spec.LMSKeyGenParameterSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ProvLMS
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalAttributes = new HashMap<String, String>();
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.lms.";
    private static final PublicKeyConverter<AsymmetricLMSPublicKey> lmsPublicKeyConverter;
    private static final PrivateKeyConverter<AsymmetricLMSPrivateKey> lmsPrivateKeyConverter;

    ProvLMS() {
    }

    @Override
    void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.LMS", "org.bouncycastle.jcajce.provider.asymmetric.lms.KeyFactorySpi$LMS", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new KeyFactorySpi("LMS");
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.LMS", "org.bouncycastle.jcajce.provider.asymmetric.lms.KeyPairGenerator", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object object) {
                    return new KeyPairGeneratorSpi(bouncyCastleFipsProvider);
                }
            }));
        }
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature.LMS", "org.bouncycastle.jcajce.provider.asymmetric.lms.Signature$LMS", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new LMSSignatureSpi(bouncyCastleFipsProvider, new FipsLMS.OperatorFactory(), lmsPublicKeyConverter, lmsPrivateKeyConverter, FipsLMS.SIG);
            }
        });
        bouncyCastleFipsProvider.addAlias("Signature", "LMS", PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.registerOid(bouncyCastleFipsProvider, PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, "LMS", new KeyFactorySpi("LMS"));
        } else {
            this.registerKeyFactoryOid(bouncyCastleFipsProvider, PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, "LMS", new KeyFactorySpi("LMS"));
        }
    }

    static {
        generalAttributes.put("SupportedKeyClasses", "org.bouncycastle.interfaces.LMSKey");
        generalAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        lmsPublicKeyConverter = new PublicKeyConverter<AsymmetricLMSPublicKey>(){

            @Override
            public AsymmetricLMSPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
                if (publicKey instanceof ProvLMSPublicKey) {
                    return ((ProvLMSPublicKey)publicKey).getBaseKey();
                }
                try {
                    return new AsymmetricLMSPublicKey(Utils.getKeyEncoding(publicKey));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify LMS public key: " + exception.getMessage(), exception);
                }
            }
        };
        lmsPrivateKeyConverter = new PrivateKeyConverter<AsymmetricLMSPrivateKey>(){

            @Override
            public AsymmetricLMSPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
                if (privateKey instanceof ProvLMSPrivateKey) {
                    return ((ProvLMSPrivateKey)privateKey).getBaseKey();
                }
                try {
                    return new AsymmetricLMSPrivateKey(PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify LMS private key: " + exception.getMessage(), exception);
                }
            }
        };
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class LMSSignatureSpi
    extends SignatureSpi
    implements PKCSObjectIdentifiers,
    X509ObjectIdentifiers {
        private static final byte TRAILER_IMPLICIT = -68;
        private final SignatureOperatorFactory operatorFactory;
        private final PublicKeyConverter publicKeyConverter;
        private final PrivateKeyConverter privateKeyConverter;
        private final BouncyCastleFipsProvider fipsProvider;
        private final AlgorithmParameterSpec originalSpec;
        protected Parameters parameters;
        protected OutputVerifier verifier;
        protected OutputSigner signer;
        protected UpdateOutputStream dataStream;
        protected AlgorithmParameters engineParams;
        protected AlgorithmParameterSpec paramSpec;
        protected AsymmetricKey key;
        protected boolean isInitState = true;

        protected LMSSignatureSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider, SignatureOperatorFactory signatureOperatorFactory, PublicKeyConverter publicKeyConverter, PrivateKeyConverter privateKeyConverter, Parameters parameters) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.operatorFactory = signatureOperatorFactory;
            this.publicKeyConverter = publicKeyConverter;
            this.privateKeyConverter = privateKeyConverter;
            this.parameters = parameters;
            this.originalSpec = null;
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            this.key = this.publicKeyConverter.convertKey(this.parameters.getAlgorithm(), publicKey);
            this.initVerify();
            this.isInitState = true;
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
            if (((AsymmetricLMSPrivateKey)this.key).getUsagesRemaining() == 0L) {
                throw new InvalidKeyException("private key exhausted");
            }
            this.appRandom = this.fipsProvider.getDefaultSecureRandom();
            this.isInitState = true;
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
            this.key = this.privateKeyConverter.convertKey(this.parameters.getAlgorithm(), privateKey);
            this.appRandom = secureRandom != null ? secureRandom : this.fipsProvider.getDefaultSecureRandom();
            this.isInitState = true;
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            if (this.isInitState && this.key instanceof AsymmetricLMSPrivateKey) {
                this.initSign();
            }
            this.isInitState = false;
            this.dataStream.update(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            if (this.isInitState && this.key instanceof AsymmetricLMSPrivateKey) {
                this.initSign();
            }
            this.isInitState = false;
            this.dataStream.update(byArray, n, n2);
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            if (this.isInitState && this.key instanceof AsymmetricLMSPrivateKey) {
                this.initSign();
            }
            try {
                this.isInitState = true;
                return this.signer.getSignature();
            }
            catch (Exception exception) {
                throw new SignatureException(exception.toString(), exception);
            }
        }

        @Override
        protected boolean engineVerify(byte[] byArray) throws SignatureException {
            try {
                this.isInitState = true;
                return this.verifier.isVerified(byArray);
            }
            catch (Exception exception) {
                throw new SignatureException(exception.toString(), exception);
            }
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("no ParameterSpec supported");
        }

        private void initVerify() {
            this.verifier = this.operatorFactory.createVerifier((AsymmetricPublicKey)this.key, this.parameters);
            this.dataStream = this.verifier.getVerifyingStream();
        }

        private void initSign() throws SignatureException {
            try {
                this.signer = Utils.addRandomIfNeeded(this.operatorFactory.createSigner((AsymmetricPrivateKey)this.key, this.parameters), this.appRandom);
                this.dataStream = this.signer.getSigningStream();
            }
            catch (Exception exception) {
                throw new SignatureException(exception.getMessage(), exception);
            }
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.engineParams;
        }

        @Override
        protected void engineSetParameter(String string, Object object) {
            throw new UnsupportedOperationException("SetParameter unsupported");
        }

        @Override
        protected Object engineGetParameter(String string) {
            throw new UnsupportedOperationException("GetParameter unsupported");
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class KeyPairGeneratorSpi
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider provider;
        FipsLMS.KeyGenParameters param;
        FipsLMS.KeyPairGenerator engine;
        SecureRandom random;
        boolean initialised = false;

        public KeyPairGeneratorSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super("LMS");
            this.provider = bouncyCastleFipsProvider;
        }

        @Override
        public void initialize(int n) {
            this.initialize(n, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            throw new UnsupportedOperationException("use AlgorithmParameterSpec");
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.provider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec instanceof LMSKeyGenParameterSpec) {
                LMSKeyGenParameterSpec lMSKeyGenParameterSpec = (LMSKeyGenParameterSpec)algorithmParameterSpec;
                this.param = new FipsLMS.KeyGenParameters(lMSKeyGenParameterSpec.getKeyParams());
                this.engine = new FipsLMS.KeyPairGenerator(this.param, secureRandom);
            } else if (algorithmParameterSpec instanceof LMSHSSKeyGenParameterSpec) {
                LMSKeyGenParameterSpec[] lMSKeyGenParameterSpecArray = ((LMSHSSKeyGenParameterSpec)algorithmParameterSpec).getLMSSpecs();
                FipsLMS.KeyParameters[] keyParametersArray = new FipsLMS.KeyParameters[lMSKeyGenParameterSpecArray.length];
                for (int i = 0; i != lMSKeyGenParameterSpecArray.length; ++i) {
                    keyParametersArray[i] = lMSKeyGenParameterSpecArray[i].getKeyParams();
                }
                this.param = new FipsLMS.KeyGenParameters(keyParametersArray);
                this.engine = new FipsLMS.KeyPairGenerator(this.param, secureRandom);
            } else {
                if (algorithmParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("parameterSpec cannot be null");
                }
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.param = new FipsLMS.KeyGenParameters(FipsLMS.lms_sha256_n32_h10.using(FipsLMS.sha256_n32_w4));
                if (this.random == null) {
                    this.random = this.provider.getDefaultSecureRandom();
                }
                this.engine = new FipsLMS.KeyPairGenerator(this.param, this.random);
                this.initialised = true;
            }
            AsymmetricKeyPair<AsymmetricLMSPublicKey, AsymmetricLMSPrivateKey> asymmetricKeyPair = this.engine.generateKeyPair();
            return new KeyPair(new ProvLMSPublicKey(asymmetricKeyPair.getPublicKey()), new ProvLMSPrivateKey(asymmetricKeyPair.getPrivateKey()));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class KeyFactorySpi
    extends BaseKeyFactory {
        String algorithm;

        public KeyFactorySpi(String string) {
            this.algorithm = string;
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvLMSPublicKey((AsymmetricLMSPublicKey)lmsPublicKeyConverter.convertKey(FipsLMS.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvLMSPrivateKey((AsymmetricLMSPrivateKey)lmsPrivateKeyConverter.convertKey(FipsLMS.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            return super.engineGetKeySpec(key, clazz);
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
            if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
                return new ProvLMSPrivateKey(privateKeyInfo);
            }
            throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognized");
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
            if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
                return new ProvLMSPublicKey(subjectPublicKeyInfo);
            }
            throw new IOException("algorithm identifier " + aSN1ObjectIdentifier + " in key not recognized");
        }
    }
}

