"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.time2CountWin = exports.getMetrics = exports.addToMetric = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("./constants");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const time2CountWin = exports.time2CountWin = new Map();
const addToMetric = (entity, action, counter, reportMetadata) => {
  const count = 1;
  // remove outdated key-value pairs
  trim();
  const timeKey = getKey(Date.now());
  const rollingCounters = time2CountWin.get(timeKey);
  time2CountWin.set(timeKey, updateCounters(entity, action, counter, rollingCounters || _lodash.default.cloneDeep(_constants.DEFAULT_ROLLING_COUNTER), count, reportMetadata));
};
exports.addToMetric = addToMetric;
const getMetrics = () => {
  const preTimeKey = getPreKey(Date.now());
  const rollingCounters = time2CountWin.get(preTimeKey);
  const metrics = buildMetrics(rollingCounters);
  return metrics;
};
exports.getMetrics = getMetrics;
const trim = () => {
  if (time2CountWin.size > _constants.CAPACITY) {
    const currentKey = getKey(Date.now() - _constants.WINDOW * 1000);
    time2CountWin.forEach((_value, key, map) => {
      if (key < currentKey) {
        map.delete(key);
      }
    });
  }
};
const getKey = milliseconds => {
  return Math.floor(milliseconds / 1000 / _constants.INTERVAL);
};
const getPreKey = milliseconds => {
  return getKey(milliseconds) - 1;
};
const isEntity = arg => {
  return arg === 'report' || arg === 'report_definition' || arg === 'report_source';
};
const buildMetrics = rollingCounters => {
  if (!rollingCounters) {
    rollingCounters = _constants.DEFAULT_ROLLING_COUNTER;
  }
  const basicMetrics = _lodash.default.merge(rollingCounters, _constants.GLOBAL_BASIC_COUNTER);
  const overallActionMetrics = {
    request_total: 0,
    request_count: 0,
    success_count: 0,
    failed_request_count_system_error: 0,
    failed_request_count_user_error: 0
  };
  Object.keys(basicMetrics).forEach(keys => {
    if (isEntity(keys)) {
      for (const [action, counters] of Object.entries(basicMetrics[keys])) {
        overallActionMetrics.request_count += (counters === null || counters === void 0 ? void 0 : counters.count) || 0;
        overallActionMetrics.request_total += (counters === null || counters === void 0 ? void 0 : counters.total) || 0;
        overallActionMetrics.failed_request_count_system_error += (counters === null || counters === void 0 ? void 0 : counters.system_error) || 0;
        overallActionMetrics.failed_request_count_user_error += (counters === null || counters === void 0 ? void 0 : counters.user_error) || 0;
      }
    }
  });
  overallActionMetrics.success_count = overallActionMetrics.request_count - (overallActionMetrics.failed_request_count_system_error + overallActionMetrics.failed_request_count_user_error);
  return {
    ...basicMetrics,
    ...overallActionMetrics
  };
};
const updateCounters = (entity, action, counter, rollingCounter, count, reportMetadata) => {
  // update usage metrics
  if (reportMetadata) {
    const {
      report_definition: {
        report_params: {
          report_source: source,
          core_params: {
            report_format: format
          }
        }
      }
    } = reportMetadata;

    // @ts-ignore
    rollingCounter[source.toLowerCase().replace(' ', '_')][format]['download'][counter] += count;
    // update basic counter for total request count
    if (counter === 'count') {
      //@ts-ignore
      _constants.GLOBAL_BASIC_COUNTER[source.toLowerCase().replace(' ', '_')][format]['download']['total']++;
    }
  } else {
    // update action metric, per API
    // @ts-ignore
    rollingCounter[entity][action][counter] += count;
    if (counter === 'count') {
      // @ts-ignore
      _constants.GLOBAL_BASIC_COUNTER[entity][action]['total']++;
    }
  }
  return rollingCounter;
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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