(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["src_components_BookmarkContent_vue-src_components_BookmarksList_vue-src_components_Controls_vue"],{70977(t,e,n){"use strict";n.d(e,{A:()=>o});const o={name:"BookmarksIcon",props:{title:{type:String,default:""},fillColor:{type:String,default:"currentColor"},size:{type:Number,default:24}}}},79477(t,e,n){"use strict";n.d(e,{X:()=>o,Y:()=>r});var o=function(){var t=this,e=t._self._c;return e("span",t._b({staticClass:"material-design-icon bookmarks-icon",attrs:{"aria-hidden":!t.title,"aria-label":t.title,role:"img"},on:{click:function(e){return t.$emit("click",e)}}},"span",t.$attrs,!1),[e("svg",{attrs:{xmlns:"http://www.w3.org/2000/svg",fill:t.fillColor,height:t.size,width:t.size,viewBox:"0 0 32 32"}},[e("g",{attrs:{transform:"translate(0,16)",fill:"#fff"}},[e("path",{staticStyle:{fill:"#000000"},attrs:{d:"m16-14c0.94487 0 3.9911 7.9919 4.7555 8.5752 0.76441 0.5833 8.9427 1.1565 9.2346 2.1003 0.29198 0.9438-6.0036 6.4562-6.2956 7.4-0.29198 0.9438 2.3984 9.2899 1.6339 9.8732-0.764 0.583-8.383-4.002-9.328-4.002-0.94487 0-8.5641 4.585-9.3285 4.0017-0.7644-0.584 1.9259-8.9297 1.6339-9.8735s-6.5875-6.4562-6.2956-7.4c0.292-0.9438 8.4702-1.517 9.2342-2.1003 0.765-0.5833 3.811-8.5752 4.756-8.5752z"}}),t._v(" "),e("path",{attrs:{opacity:".3",d:"m88-14c0.94487 0 3.9911 7.9919 4.7555 8.5752 0.76441 0.5833 8.9427 1.1565 9.2346 2.1003 0.29198 0.9438-6.0036 6.4562-6.2956 7.4-0.29198 0.9438 2.3984 9.2899 1.6339 9.8732-0.764 0.583-8.383-4.002-9.328-4.002-0.94487 0-8.5641 4.585-9.3285 4.0017-0.76441-0.5833 1.9259-8.9294 1.6339-9.8732-0.29198-0.9438-6.5875-6.4562-6.2956-7.4 0.29198-0.9438 8.4702-1.517 9.2346-2.1003 0.76441-0.5833 3.8106-8.5752 4.7555-8.5752z"}}),t._v(" "),e("path",{attrs:{opacity:".7",d:"m34.344 13.406c-0.172 0.088-0.315 0.187-0.344 0.282-0.28187 0.91113 5.5814 6.0441 6.25 7.25 0.06311-0.4005 0.10474-0.73846 0.0625-0.875-0.24735-0.79953-4.7593-4.8544-5.9688-6.6562zm27.312 0c-1.2095 1.8019-5.7214 5.8567-5.9688 6.6562-0.04224 0.13654-0.00061 0.4745 0.0625 0.875 0.66855-1.2059 6.5319-6.3389 6.25-7.25-0.0292-0.09438-0.17213-0.1939-0.34375-0.28125zm-13.656 12.532c-0.94487 0-8.5793 4.5833-9.3438 4-0.03185-0.0243-0.04218-0.07484-0.0625-0.125-0.06113 0.57179-0.08345 1.0136 0.0625 1.125 0.76442 0.5833 8.3989-4 9.3438-4 0.94487 0 8.5793 4.5833 9.3438 4 0.14595-0.11137 0.12363-0.55321 0.0625-1.125-0.02032 0.05016-0.03065 0.1007-0.0625 0.125-0.76441 0.5833-8.3989-4-9.3438-4z",transform:"translate(0,-16)"}})])])])},r=[]},96192(t,e,n){"use strict";n.d(e,{A6:()=>g.A,C3:()=>mt.A,Cn:()=>D.A,DP:()=>w.A,EV:()=>m.A,Fj:()=>f.A,GC:()=>p.A,GQ:()=>it.A,Gg:()=>At.A,HJ:()=>c.A,In:()=>at.A,J7:()=>dt.A,JM:()=>tt.A,KD:()=>B.A,Kr:()=>x.A,LW:()=>N.A,M9:()=>J.A,OG:()=>H.A,OV:()=>k.A,Ox:()=>I.A,P1:()=>b.A,PH:()=>P.A,PW:()=>F.A,R2:()=>Y.A,Sr:()=>C.A,TP:()=>S.A,Tv:()=>l.A,UR:()=>R.A,US:()=>z.A,Wb:()=>d.A,X:()=>st.A,XI:()=>s.A,YP:()=>r.A,Zq:()=>y.A,_3:()=>K.A,_z:()=>h.A,a_:()=>$.A,bM:()=>U.A,c1:()=>X.A,c8:()=>o.A,cD:()=>A.A,d7:()=>j.A,fA:()=>v.A,fM:()=>q.A,fR:()=>E.A,fY:()=>u.A,fl:()=>L.A,gq:()=>M.A,jh:()=>a.A,kb:()=>O.A,lU:()=>rt.A,nh:()=>i.A,ni:()=>T.A,os:()=>_.A,qY:()=>Z.A,s3:()=>V.A,sj:()=>et.A,uG:()=>nt.A,ui:()=>W.A,vu:()=>ct.A,wi:()=>Q.A,wr:()=>G.A,z3:()=>lt.A,z5:()=>ot.A});var o=n(670),r=n(24648),i=n(14987),s=n(89617),a=n(89475),l=n(83721),c=n(62921),d=n(5690),m=n(68300),A=n(52352),h=n(19262),u=n(30307),p=n(140),k=n(81766),f=n(33291),b=n(75869),g=n(89654),C=n(91882),v=n(84955),_=n(77154),y=n(30161),I=n(29460),x=n(67096),S=n(67811),w=n(86883),E=n(32789),$=n(24509),N=n(38699),B=n(31588),T=n(1555),O=n(65602),D=n(38),R=n(42002),F=n(45683),L=n(64285),M=n(21124),P=n(9015),z=n(83614),H=n(92486),V=n(15370),U=n(90065),Y=n(6513),K=n(92836),G=n(99766),q=n(25823),W=n(59900),j=n(99495),J=n(86274),Q=n(65910),X=n(49954),Z=n(26546),tt=n(81747),et=n(99144),nt=n(26784),ot=n(78841),rt=n(51387),it=n(63274),st=n(76476),at=n(80144),lt=n(11562),ct=n(8238),dt=(n(7643),n(15602)),mt=n(76592),At=n(42084)},72674(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.bookmark__icon {\n\tdisplay: inline-block;\n\tflex: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tposition: relative;\n\ttop: 3px;\n}\n.bookmark__title {\n\tdisplay: flex;\n\tmin-width: calc(50px + 40%);\n}\n.bookmark__title,\n.bookmark__title > h3 {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n}\n.bookmark__title > h3 {\n\tmargin: 0;\n\tfont-size: 1rem;\n\tfont-weight: normal;\n}\n.bookmark__description {\n\tdisplay: inline-block;\n\tflex: 1;\n\tmargin: auto 10px;\n\theight: 24px;\n\tcolor: var(--color-text-lighter);\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmin-width: 15px;\n}\n.bookmark__description figure {\n\tdisplay: none !important;\n}\n.item--gridview .bookmark__title {\n\tmin-width: auto;\n\tmargin-inline-start: 15px;\n}\n.item--gridview .bookmark__icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tinset-inline-start: calc(45% - 20px);\n\ttransform: scale(2);\n\ttransform-origin: top left;\n\tmargin: 0 5px 0 8px;\n}\n.item--gridview .bookmark__description {\n\tflex: 0;\n}\n.item--gridview .bookmark__description figure {\n\tdisplay: inline-block !important;\n\tposition: relative;\n\ttop: 5px;\n}\n.bookmark__folder-tooltip {\n\tpadding: 10px;\n\tmin-width: 150px;\n}\n.bookmark__folder-tooltip li {\n\tdisplay: flex;\n}\n","",{version:3,sources:["webpack://./src/components/Bookmark.vue"],names:[],mappings:";AA0ZA;CACA,qBAAA;CACA,OAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,kBAAA;CACA,QAAA;AACA;AAEA;CACA,aAAA;CACA,2BAAA;AACA;AAEA;;CAEA,uBAAA;CACA,gBAAA;CACA,mBAAA;AACA;AAEA;CACA,SAAA;CACA,eAAA;CACA,mBAAA;AACA;AAEA;CACA,qBAAA;CACA,OAAA;CACA,iBAAA;CACA,YAAA;CACA,gCAAA;CACA,uBAAA;CACA,gBAAA;CACA,eAAA;AACA;AAEA;CACA,wBAAA;AACA;AAEA;CACA,eAAA;CACA,yBAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,oCAAA;CACA,mBAAA;CACA,0BAAA;CACA,mBAAA;AACA;AAEA;CACA,OAAA;AACA;AAEA;CACA,gCAAA;CACA,kBAAA;CACA,QAAA;AACA;AAEA;CACA,aAAA;CACA,gBAAA;AACA;AAEA;CACA,aAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcPopover popup-role="dialog" :shown="popoverShown">\n\t\t<template #trigger>\n\t\t\t<div @mouseenter="(![routes.FOLDER, routes.HOME].includes($route.name)) && (popoverShown = true)" @mouseleave="popoverShown = false">\n\t\t\t\t<Item :title="bookmark.title"\n\t\t\t\t\t:tags="bookmark.tags"\n\t\t\t\t\t:rename-placeholder="t(\'bookmarks\', \'Enter new title\')"\n\t\t\t\t\t:select-label="t(\'bookmarks\', \'Select bookmark\')"\n\t\t\t\t\t:active="isActive"\n\t\t\t\t\t:editable="isEditable"\n\t\t\t\t\t:selected="selected"\n\t\t\t\t\t:draggable="isDraggable"\n\t\t\t\t\t:renaming="renaming"\n\t\t\t\t\t:background="background"\n\t\t\t\t\t:url="url"\n\t\t\t\t\t:selectable="selectable"\n\t\t\t\t\t@select="onSelect"\n\t\t\t\t\t@rename="onRenameSubmit"\n\t\t\t\t\t@rename-cancel="renaming = false"\n\t\t\t\t\t@click="onClick">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<span v-if="bookmark.preliminary" class="icon-loading-small bookmark__icon" />\n\t\t\t\t\t\t<StarIcon v-else-if="!iconLoaded" :size="20" class="bookmark__icon" />\n\t\t\t\t\t\t<figure v-else\n\t\t\t\t\t\t\tclass="bookmark__icon"\n\t\t\t\t\t\t\t:style="{ backgroundImage: iconImage }" />\n\t\t\t\t\t</template>\n\t\t\t\t\t<template #title>\n\t\t\t\t\t\t<div class="bookmark__title">\n\t\t\t\t\t\t\t<h3 :title="displayTitle">\n\t\t\t\t\t\t\t\t{{ displayTitle }}\n\t\t\t\t\t\t\t</h3>\n\t\t\t\t\t\t\t<span v-if="bookmark.description"\n\t\t\t\t\t\t\t\tv-tooltip="bookmark.description"\n\t\t\t\t\t\t\t\tclass="bookmark__description"><figure class="icon-file" />\n\t\t\t\t\t\t\t\t{{ bookmark.description }}</span>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</template>\n\t\t\t\t\t<template #rating>\n\t\t\t\t\t\t<template v-if="hotness === 0">\n\t\t\t\t\t\t\t<div :title="t(\'bookmarks\', \'You have never clicked this link\')">\n\t\t\t\t\t\t\t\t<HotnessZero :size="20" />\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t<template v-if="hotness === 1">\n\t\t\t\t\t\t\t<div :title="t(\'bookmarks\', \'You have clicked this link {count} times\', {count: largeNumbers(bookmark.clickcount)})">\n\t\t\t\t\t\t\t\t<Hotness :size="20" />\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t<template v-if="hotness === 2">\n\t\t\t\t\t\t\t<div :title="t(\'bookmarks\', \'You have clicked this link {count} times\', {count: largeNumbers(bookmark.clickcount)})">\n\t\t\t\t\t\t\t\t<Hotness :size="20" /><Hotness :size="20" />\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t<template v-if="hotness === 3">\n\t\t\t\t\t\t\t<div :title="t(\'bookmarks\', \'You have clicked this link {count} times\', {count: largeNumbers(bookmark.clickcount)})">\n\t\t\t\t\t\t\t\t<Hotness :size="20" /><Hotness :size="20" /><Hotness :size="20" />\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</template>\n\t\t\t\t\t<template #actions>\n\t\t\t\t\t\t<template v-if="!isTrashbin">\n\t\t\t\t\t\t\t<NcActionButton :close-after-click="true"\n\t\t\t\t\t\t\t\t@click="onDetails">\n\t\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t\t<InformationVariantIcon :size="20" />\n\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Details\') }}\n\t\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t\t<NcActionCheckbox @change="onSelect">\n\t\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Select bookmark\') }}\n\t\t\t\t\t\t\t</NcActionCheckbox>\n\t\t\t\t\t\t\t<NcActionButton :close-after-click="true"\n\t\t\t\t\t\t\t\t@click="onRename">\n\t\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t\t<PencilIcon :size="20" />\n\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Rename\') }}\n\t\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t\t<NcActionButton :close-after-click="true"\n\t\t\t\t\t\t\t\t@click="onCopyUrl">\n\t\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t\t<ContentCopyIcon :size="20" />\n\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Copy link\') }}\n\t\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t\t<NcActionButton :close-after-click="true" @click="onMove">\n\t\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t\t<FolderMoveIcon :size="20" />\n\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Move\') }}\n\t\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t\t<NcActionButton :close-after-click="true" @click="onCopy">\n\t\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t\t<FolderPlusIcon :size="20" />\n\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Add to folders\') }}\n\t\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t\t<NcActionButton :close-after-click="true" @click="onDelete(false)">\n\t\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t\t<DeleteIcon :size="20" />\n\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Put bookmark into trash bin\') }}\n\t\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t<template v-else>\n\t\t\t\t\t\t\t<NcActionButton :close-after-click="true" @click="onUndelete">\n\t\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t\t<UndeleteIcon :size="20" />\n\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Restore bookmark\') }}\n\t\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t\t<NcActionButton :close-after-click="true" @click="onDelete(true)">\n\t\t\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t\t\t<DeleteForeverIcon :size="20" />\n\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t{{ t(\'bookmarks\', \'Delete bookmark permanently\') }}\n\t\t\t\t\t\t\t</NcActionButton>\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</template>\n\t\t\t\t</Item>\n\t\t\t</div>\n\t\t</template>\n\t\t<ul class="bookmark__folder-tooltip">\n\t\t\t<li v-for="folderId in bookmark.folders"\n\t\t\t\t:key="folderId">\n\t\t\t\t<FolderIcon :size="20" /> {{ getFolderPath(folderId) }}\n\t\t\t</li>\n\t\t</ul>\n\t</NcPopover>\n</template>\n<script>\nimport Item from \'./Item.vue\'\nimport { NcActionButton, NcActionCheckbox, NcPopover } from \'@nextcloud/vue\'\nimport { Hotness, HotnessZero, FolderIcon, UndeleteIcon, DeleteForeverIcon, FolderPlusIcon, FolderMoveIcon, ContentCopyIcon, PencilIcon, InformationVariantIcon, DeleteIcon, StarIcon } from \'./Icons.js\'\nimport { getCurrentUser } from \'@nextcloud/auth\'\nimport { generateUrl } from \'@nextcloud/router\'\nimport { actions, mutations } from \'../store/index.js\'\nimport axios from \'@nextcloud/axios\'\n\nexport default {\n\tname: \'Bookmark\',\n\tcomponents: {\n\t\tItem,\n\t\tNcActionButton,\n\t\tNcActionCheckbox,\n\t\tFolderPlusIcon,\n\t\tFolderMoveIcon,\n\t\tFolderIcon,\n\t\tContentCopyIcon,\n\t\tPencilIcon,\n\t\tInformationVariantIcon,\n\t\tDeleteIcon,\n\t\tDeleteForeverIcon,\n\t\tUndeleteIcon,\n\t\tStarIcon,\n\t\tNcPopover,\n\t\tHotness,\n\t\tHotnessZero,\n\t},\n\tprops: {\n\t\tbookmark: {\n\t\t\ttype: Object,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\ttitle: this.bookmark.title,\n\t\t\trenaming: false,\n\t\t\tbackgroundImage: undefined,\n\t\t\ticonImage: undefined,\n\t\t\ticonLoaded: false,\n\t\t\tpopoverShown: false,\n\t\t}\n\t},\n\tcomputed: {\n\t\tapiUrl() {\n\t\t\tif (this.isPublic) {\n\t\t\t\treturn generateUrl(\'/apps/bookmarks/public/rest/v2\')\n\t\t\t}\n\t\t\treturn generateUrl(\'/apps/bookmarks\')\n\t\t},\n\t\ticonUrl() {\n\t\t\treturn (\n\t\t\t\tthis.apiUrl\n\t\t\t\t+ \'/bookmark/\'\n\t\t\t\t+ this.bookmark.id\n\t\t\t\t+ \'/favicon\'\n\t\t\t\t+ (this.$store.state.public\n\t\t\t\t\t? \'?token=\' + this.$store.state.authToken\n\t\t\t\t\t: \'\')\n\t\t\t)\n\t\t},\n\t\timageUrl() {\n\t\t\treturn (\n\t\t\t\tthis.apiUrl\n\t\t\t\t+ \'/bookmark/\'\n\t\t\t\t+ this.bookmark.id\n\t\t\t\t+ \'/image\'\n\t\t\t\t+ (this.$store.state.public\n\t\t\t\t\t? \'?token=\' + this.$store.state.authToken\n\t\t\t\t\t: \'\')\n\t\t\t)\n\t\t},\n\t\turl() {\n\t\t\treturn this.bookmark.url\n\t\t},\n\t\tdisplayTitle() {\n\t\t\treturn this.bookmark.title || this.bookmark.url\n\t\t},\n\t\tisOpen() {\n\t\t\treturn this.$store.state.sidebar\n\t\t\t\t&& this.$store.state.sidebar.type === \'bookmark\'\n\t\t\t\t? this.$store.state.sidebar.id === this.bookmark.id\n\t\t\t\t: false\n\t\t},\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tisOwner() {\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.bookmark.userId === currentUser.uid\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForBookmark(\n\t\t\t\tthis.bookmark.id,\n\t\t\t)\n\t\t},\n\t\tisDraggable() {\n\t\t\treturn this.isEditable && !this.isTrashbin\n\t\t},\n\t\tisEditable() {\n\t\t\treturn (this.isOwner || (!this.isOwner && this.permissions.canWrite))\n\t\t},\n\t\tselectedBookmarks() {\n\t\t\treturn this.$store.state.selection.bookmarks\n\t\t},\n\t\tselectable() {\n\t\t\treturn Boolean(\n\t\t\t\t(this.$store.state.selection.bookmarks.length\n\t\t\t\t\t|| this.$store.state.selection.folders.length) && !this.isTrashbin,\n\t\t\t)\n\t\t},\n\t\tselected() {\n\t\t\treturn this.selectedBookmarks\n\t\t\t\t.map(b => b.id)\n\t\t\t\t.includes(this.bookmark.id)\n\t\t},\n\t\tisActive() {\n\t\t\treturn this.isOpen || this.selected\n\t\t},\n\t\tbackground() {\n\t\t\treturn this.viewMode === \'grid\' ? this.backgroundImage : undefined\n\t\t},\n\t\tfolder() {\n\t\t\treturn this.$store.getters.getFolder(this.$store.state.fetchState.query.folder)[0]\n\t\t},\n\t\tisTrashbin() {\n\t\t\treturn (this.folder && this.folder.softDeleted) || this.$route.name === this.routes.TRASHBIN\n\t\t},\n\t\thotness() {\n\t\t\tconst avgClickCount = this.$store.state.allClicksCount / this.$store.state.withClicksCount\n\t\t\tif (this.$store.state.allClicksCount < 100) {\n\t\t\t\tconst totalClicks = this.$store.state.allClicksCount\n\t\t\t\treturn this.bookmark.clickcount <= 0 ? 0 : this.bookmark.clickcount < totalClicks * 0.25 ? 1 : this.bookmark.clickcount < totalClicks * 0.5 ? 2 : 3\n\t\t\t}\n\t\t\tconst avgClicksLog = Math.log10(avgClickCount)\n\t\t\treturn this.bookmark.clickcount <= 0 ? 0 : Math.log10(this.bookmark.clickcount) < avgClicksLog * 0.5 ? 1 : Math.log10(this.bookmark.clickcount) < avgClicksLog * 1.5 ? 2 : 3\n\t\t},\n\t},\n\tmounted() {\n\t\tthis.fetchBackgroundImage()\n\t\tthis.fetchIcon()\n\t},\n\tmethods: {\n\t\tlargeNumbers(num) {\n\t\t\treturn num > 10000 ? Math.round(num / 1000) + \'K\' : num >= 1000 ? (Math.round(num / 100) / 10) + \'K\' : num\n\t\t},\n\t\tgetFolderPath(id) {\n\t\t\tconst path = this.$store.getters.getFolder(id).reverse().map(folder => folder.title)\n\t\t\treturn \'/\' + path.join(\'/\')\n\t\t},\n\t\tonDelete(hard) {\n\t\t\tif (\n\t\t\t\thard && !confirm(\n\t\t\t\t\tt(\n\t\t\t\t\t\t\'bookmarks\',\n\t\t\t\t\t\t\'Do you really want to delete this bookmark?\',\n\t\t\t\t\t),\n\t\t\t\t)\n\t\t\t) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tif ((this.$route.name === this.routes.FOLDER || this.$route.name === this.routes.HOME) && this.$store.state.fetchState.query.folder) {\n\t\t\t\tthis.$store.dispatch(actions.DELETE_BOOKMARK, {\n\t\t\t\t\tid: this.bookmark.id,\n\t\t\t\t\tfolder: this.$store.state.fetchState.query.folder,\n\t\t\t\t\thard,\n\t\t\t\t})\n\t\t\t} else {\n\t\t\t\tthis.bookmark.folders.forEach((folder) => this.$store.dispatch(actions.DELETE_BOOKMARK, {\n\t\t\t\t\tid: this.bookmark.id,\n\t\t\t\t\tfolder,\n\t\t\t\t\thard,\n\t\t\t\t}))\n\t\t\t}\n\t\t},\n\t\tonUndelete() {\n\t\t\tif (this.$route.name === this.routes.FOLDER && this.$store.state.fetchState.query.folder) {\n\t\t\t\tthis.$store.dispatch(actions.UNDELETE_BOOKMARK, {\n\t\t\t\t\tid: this.bookmark.id,\n\t\t\t\t\tfolder: this.$store.state.fetchState.query.folder,\n\t\t\t\t})\n\t\t\t} else {\n\t\t\t\tthis.bookmark.folders.forEach((folder) => this.$store.dispatch(actions.UNDELETE_BOOKMARK, {\n\t\t\t\t\tid: this.bookmark.id,\n\t\t\t\t\tfolder,\n\t\t\t\t}))\n\t\t\t}\n\t\t},\n\t\tonDetails() {\n\t\t\tthis.$store.dispatch(actions.OPEN_BOOKMARK, this.bookmark.id)\n\t\t},\n\t\tonMove() {\n\t\t\tif (this.isTrashbin) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tthis.$store.commit(mutations.ADD_SELECTION_BOOKMARK, this.bookmark)\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, true)\n\t\t},\n\t\tonCopy() {\n\t\t\tif (this.isTrashbin) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tthis.$store.commit(mutations.ADD_SELECTION_BOOKMARK, this.bookmark)\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, true)\n\t\t},\n\t\tasync onRename() {\n\t\t\tthis.renaming = true\n\t\t},\n\t\tasync onRenameSubmit(title) {\n\t\t\t// eslint-disable-next-line vue/no-mutating-props\n\t\t\tthis.bookmark.title = title\n\t\t\tawait this.$store.dispatch(actions.SAVE_BOOKMARK, this.bookmark.id)\n\t\t\tthis.renaming = false\n\t\t},\n\t\tonSelect() {\n\t\t\tif (this.isTrashbin) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tif (!this.selected) {\n\t\t\t\tthis.$store.commit(\n\t\t\t\t\tmutations.ADD_SELECTION_BOOKMARK,\n\t\t\t\t\tthis.bookmark,\n\t\t\t\t)\n\t\t\t} else {\n\t\t\t\tthis.$store.commit(\n\t\t\t\t\tmutations.REMOVE_SELECTION_BOOKMARK,\n\t\t\t\t\tthis.bookmark,\n\t\t\t\t)\n\t\t\t}\n\t\t},\n\t\tonClick() {\n\t\t\tif (this.bookmark.url.startsWith(\'file:\')) {\n\t\t\t\tthis.$store.commit(mutations.SET_ERROR, \'Most browsers will not allow clicking on file links. Try copying the URL\')\n\t\t\t}\n\t\t\tthis.$store.dispatch(actions.CLICK_BOOKMARK, this.bookmark)\n\t\t},\n\t\tonCopyUrl() {\n\t\t\tnavigator.clipboard.writeText(this.bookmark.target)\n\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, this.t(\'bookmarks\', \'Link copied to clipboard\'))\n\t\t},\n\t\tasync fetchBackgroundImage() {\n\t\t\tif (!this.bookmark.lastPreview) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\ttry {\n\t\t\t\tconst response = await axios.get(this.imageUrl, { responseType: \'blob\' })\n\t\t\t\tconst url = URL.createObjectURL(response.data)\n\t\t\t\tthis.backgroundImage = `linear-gradient(0deg, var(--color-main-background) 25%, rgba(0, 212, 255, 0) 50%), url(\'${url}\')`\n\t\t\t} catch (e) {\n\t\t\t}\n\t\t},\n\t\tasync fetchIcon() {\n\t\t\tthis.iconLoaded = false\n\t\t\tif (!this.bookmark.lastPreview) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\ttry {\n\t\t\t\tconst response = await axios.get(this.iconUrl, { responseType: \'blob\' })\n\t\t\t\tconst url = URL.createObjectURL(response.data)\n\t\t\t\tthis.iconImage = `url(\'${url}\')`\n\t\t\t\tthis.iconLoaded = true\n\t\t\t} catch (e) {\n\t\t\t\tthis.iconLoaded = false\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.bookmark__icon {\n\tdisplay: inline-block;\n\tflex: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tposition: relative;\n\ttop: 3px;\n}\n\n.bookmark__title {\n\tdisplay: flex;\n\tmin-width: calc(50px + 40%);\n}\n\n.bookmark__title,\n.bookmark__title > h3 {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n}\n\n.bookmark__title > h3 {\n\tmargin: 0;\n\tfont-size: 1rem;\n\tfont-weight: normal;\n}\n\n.bookmark__description {\n\tdisplay: inline-block;\n\tflex: 1;\n\tmargin: auto 10px;\n\theight: 24px;\n\tcolor: var(--color-text-lighter);\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmin-width: 15px;\n}\n\n.bookmark__description figure {\n\tdisplay: none !important;\n}\n\n.item--gridview .bookmark__title {\n\tmin-width: auto;\n\tmargin-inline-start: 15px;\n}\n\n.item--gridview .bookmark__icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tinset-inline-start: calc(45% - 20px);\n\ttransform: scale(2);\n\ttransform-origin: top left;\n\tmargin: 0 5px 0 8px;\n}\n\n.item--gridview .bookmark__description {\n\tflex: 0;\n}\n\n.item--gridview .bookmark__description figure {\n\tdisplay: inline-block !important;\n\tposition: relative;\n\ttop: 5px;\n}\n\n.bookmark__folder-tooltip {\n\tpadding: 10px;\n\tmin-width: 150px;\n}\n\n.bookmark__folder-tooltip li {\n\tdisplay: flex;\n}\n</style>\n'],sourceRoot:""}]);const a=s},21008(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.bookmark-content {\n\tposition: absolute;\n\ttop: 0;\n\tinset-inline: 0 max( min(27vw, 500px), 300px); /* side bar */\n\tbottom: 0;\n\tbackground: var(--color-main-background);\n\tz-index: 1801;\n\tdisplay: flex;\n\toverflow: scroll;\n\tflex-direction: column;\n}\n.bookmark-content .content {\n\tmargin: 30px auto;\n\twidth: 600px;\n\tfont-size: 15px;\n\ttext-align: justify;\n\tposition: relative;\n\tflex-grow: 1;\n}\n.bookmark-content .content.iframe {\n\tmargin: 0;\n\tposition: relative;\n\toverflow: hidden;\n\twidth: auto;\n}\n.bookmark-content .empty-content {\n\tmargin: 150px auto;\n\twidth: 600px;\n}\n.bookmark-content .content iframe {\n\theight: 100%;\n\twidth: 100%;\n}\n.bookmark-content h1, .bookmark-content h2, .bookmark-content h3, .bookmark-content h4, .bookmark-content h5, .bookmark-content p {\n\tmargin-top: 10px !important;\n}\n.bookmark-content a:link,\n.bookmark-content a[href] {\n\ttext-decoration: underline !important;\n}\n","",{version:3,sources:["webpack://./src/components/BookmarkContent.vue"],names:[],mappings:";AAyEA;CACA,kBAAA;CACA,MAAA;CACA,6CAAA,EAAA,aAAA;CACA,SAAA;CACA,wCAAA;CACA,aAAA;CACA,aAAA;CACA,gBAAA;CACA,sBAAA;AACA;AAEA;CACA,iBAAA;CACA,YAAA;CACA,eAAA;CACA,mBAAA;CACA,kBAAA;CACA,YAAA;AACA;AAEA;CACA,SAAA;CACA,kBAAA;CACA,gBAAA;CACA,WAAA;AACA;AAEA;CACA,kBAAA;CACA,YAAA;AACA;AAEA;CACA,YAAA;CACA,WAAA;AACA;AAEA;CACA,2BAAA;AACA;AAEA;;CAEA,qCAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div v-if=\"isActive && scrapingEnabled && archiveEnabled && hasMinLength && !archivedFile && isWebLink\" class=\"bookmark-content\">\n\t\t<div v-if=\"bookmark.textContent\" class=\"content\" v-html=\"content\" />\n\t\t<div v-else>\n\t\t\t<NcEmptyContent :name=\"t('bookmarks', 'Content pending')\"\n\t\t\t\t:description=\"t('bookmarks', 'This content is being downloaded for offline use. Please check back later.')\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<DownloadIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t</NcEmptyContent>\n\t\t</div>\n\t</div>\n</template>\n\n<script>\nimport { DownloadIcon } from './Icons.js'\nimport sanitizeHtml from 'sanitize-html'\nimport { generateUrl, generateRemoteUrl } from '@nextcloud/router'\nimport { NcEmptyContent } from '@nextcloud/vue'\n\nconst MIN_TEXT_LENGTH = 350\n\nexport default {\n\tname: 'BookmarkContent',\n\tcomponents: { NcEmptyContent, DownloadIcon },\n\tcomputed: {\n\t\tisActive() {\n\t\t\tif (!this.$store.state.sidebar) return false\n\t\t\treturn this.$store.state.sidebar.type === 'bookmark'\n\t\t},\n\t\tisWebLink() {\n\t\t\treturn this.bookmark.url.startsWith('http')\n\t\t},\n\t\tscrapingEnabled() {\n\t\t\treturn this.$store.state.settings['privacy.enableScraping'] === 'true'\n\t\t},\n\t\tarchiveEnabled() {\n\t\t\treturn this.$store.state.settings['archive.enabled']\n\t\t},\n\t\tbookmark() {\n\t\t\tif (!this.isActive) return\n\t\t\treturn this.$store.getters.getBookmark(this.$store.state.sidebar.id)\n\t\t},\n\t\thasMinLength() {\n\t\t\treturn !this.bookmark.textContent || this.bookmark.textContent.length >= MIN_TEXT_LENGTH\n\t\t},\n\t\tcontent() {\n\t\t\treturn sanitizeHtml(this.bookmark.htmlContent, {\n\t\t\t\tallowProtocolRelative: false,\n\t\t\t})\n\t\t},\n\t\tarchivedFileUrl() {\n\t\t\t// remove `/username/files/`\n\t\t\tconst barePath = this.bookmark.archivedFilePath.split('/').slice(3).join('/')\n\t\t\treturn generateRemoteUrl(`webdav/${barePath}`)\n\t\t},\n\t\tarchivedFile() {\n\t\t\tif (this.bookmark.archivedFile) {\n\t\t\t\treturn generateUrl(`/apps/files/?fileid=${this.bookmark.archivedFile}`)\n\t\t\t}\n\t\t\treturn null\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n.bookmark-content {\n\tposition: absolute;\n\ttop: 0;\n\tinset-inline: 0 max( min(27vw, 500px), 300px); /* side bar */\n\tbottom: 0;\n\tbackground: var(--color-main-background);\n\tz-index: 1801;\n\tdisplay: flex;\n\toverflow: scroll;\n\tflex-direction: column;\n}\n\n.bookmark-content .content {\n\tmargin: 30px auto;\n\twidth: 600px;\n\tfont-size: 15px;\n\ttext-align: justify;\n\tposition: relative;\n\tflex-grow: 1;\n}\n\n.bookmark-content .content.iframe {\n\tmargin: 0;\n\tposition: relative;\n\toverflow: hidden;\n\twidth: auto;\n}\n\n.bookmark-content .empty-content {\n\tmargin: 150px auto;\n\twidth: 600px;\n}\n\n.bookmark-content .content iframe {\n\theight: 100%;\n\twidth: 100%;\n}\n\n.bookmark-content h1, .bookmark-content h2, .bookmark-content h3, .bookmark-content h4, .bookmark-content h5, .bookmark-content p {\n\tmargin-top: 10px !important;\n}\n\n.bookmark-content a:link,\n.bookmark-content a[href] {\n\ttext-decoration: underline !important;\n}\n</style>\n"],sourceRoot:""}]);const a=s},75285(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.folder--gridview,\n.bookmark--gridview,\n.bookmarkslist--gridview .create-folder,\n.bookmarkslist--gridview .create-bookmark {\n\twidth: 250px;\n\theight: 200px;\n\talign-items: flex-end;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius);\n}\n","",{version:3,sources:["webpack://./src/components/BookmarksList.vue"],names:[],mappings:";AA2OA;;;;CAIA,YAAA;CACA,aAAA;CACA,qBAAA;CACA,wCAAA;CACA,qCAAA;CACA,0CAAA;CACA,mCAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div :class="{\n\t\tbookmarkslist: true,\n\t\t\'bookmarkslist--gridview\': viewMode === \'grid\',\n\t\t\'bookmarkslist--with-description\': descriptionShown,\n\t}">\n\t\t<div v-if="$route.name === routes.TRASHBIN && (bookmarks.length || subFolders.length)" class="bookmarkslist__description">\n\t\t\t<NcNoteCard type="info">\n\t\t\t\t{{\n\t\t\t\t\tt(\'bookmarks\', \'These are your deleted items. Items will be deleted permanently after two months.\')\n\t\t\t\t}}\n\t\t\t</NcNoteCard>\n\t\t</div>\n\t\t<div v-if="$route.name === routes.ARCHIVED && bookmarks.length" class="bookmarkslist__description">\n\t\t\t<NcNoteCard type="info">\n\t\t\t\t{{\n\t\t\t\t\tt(\'bookmarks\', \'Bookmarks to files on the web like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline.\')\n\t\t\t\t}}\n\t\t\t</NcNoteCard>\n\t\t</div>\n\t\t<div v-if="$route.name === routes.SEARCH && (bookmarks.length || subFolders.length) && Number($route.params.folder) !== -1" class="bookmarkslist__description">\n\t\t\t<NcNoteCard type="info">\n\t\t\t\t{{\n\t\t\t\t\tt(\'bookmarks\', \'Searching in the current folder only.\')\n\t\t\t\t}}\n\t\t\t\t<NcButton @click="onSearchGlobally">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<MagnifyIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Repeat search in all folders\') }}\n\t\t\t\t</NcButton>\n\t\t\t</NcNoteCard>\n\t\t</div>\n\t\t<div v-if="$route.name === routes.UNAVAILABLE && bookmarks.length" class="bookmarkslist__description">\n\t\t\t<NcNoteCard type="info">\n\t\t\t\t{{\n\t\t\t\t\tt(\'bookmarks\', \'Bookmarked links are checked regularly and the ones that cannot be reached are listed here.\')\n\t\t\t\t}}\n\t\t\t</NcNoteCard>\n\t\t</div>\n\t\t<div v-if="$route.name === routes.SHARED_FOLDERS && bookmarks.length" class="bookmarkslist__description">\n\t\t\t<NcNoteCard type="info">\n\t\t\t\t{{\n\t\t\t\t\tt(\'bookmarks\', \'You can share bookmark folders with others. All folders shared with you are listed here.\')\n\t\t\t\t}}\n\t\t\t</NcNoteCard>\n\t\t</div>\n\t\t<div v-if="$route.name === routes.DUPLICATED && bookmarks.length" class="bookmarkslist__description">\n\t\t\t<NcNoteCard type="info">\n\t\t\t\t{{\n\t\t\t\t\tt(\'bookmarks\', \'One bookmark can be in multiple folders at once. Updating it will update all copies. All duplicated bookmarks are listed here for convenience.\')\n\t\t\t\t}}\n\t\t\t</NcNoteCard>\n\t\t</div>\n\t\t<VirtualScroll :reached-end="reachedEnd" @load-more="loadMore">\n\t\t\t<CreateBookmark v-if="newBookmark" />\n\t\t\t<CreateFolder v-if="newFolder" />\n\t\t\t<template v-if="$route.name === routes.FOLDER || $route.name === routes.HOME">\n\t\t\t\t\x3c!-- FOLDER VIEW WITH CUSTOM SORTING --\x3e\n\t\t\t\t<template v-if="sortOrder === \'index\' && children.length">\n\t\t\t\t\t<template v-for="item in children">\n\t\t\t\t\t\t<Folder v-if="item.type === \'folder\' && getFolder(item.id)"\n\t\t\t\t\t\t\t:key="\'customsort\' + item.type + item.id"\n\t\t\t\t\t\t\t:folder="getFolder(item.id)" />\n\t\t\t\t\t\t<Bookmark v-if="item.type === \'bookmark\' && getBookmark(item.id)"\n\t\t\t\t\t\t\t:key="\'nosort\' + item.type + item.id"\n\t\t\t\t\t\t\t:bookmark="getBookmark(item.id)" />\n\t\t\t\t\t</template>\n\t\t\t\t</template>\n\t\t\t\t\x3c!-- FOLDER VIEW WITH NORMAL SORTING --\x3e\n\t\t\t\t<template v-else-if="subFolders.length !== 0 || bookmarks.length !== 0">\n\t\t\t\t\t<Folder v-for="folder in subFolders"\n\t\t\t\t\t\t:key="\'normalsort\' + \'folder\' + folder.id"\n\t\t\t\t\t\t:folder="folder" />\n\t\t\t\t\t<template v-if="bookmarks.length">\n\t\t\t\t\t\t<Bookmark v-for="bookmark in bookmarks"\n\t\t\t\t\t\t\t:key="\'nosort\' + \'bookmark\' + bookmark.id"\n\t\t\t\t\t\t\t:bookmark="bookmark" />\n\t\t\t\t\t</template>\n\t\t\t\t</template>\n\t\t\t\t<template v-else-if="!subFolders.length && !bookmarks.length && !children.length">\n\t\t\t\t\t<NoBookmarks v-if="!loading && (allBookmarksCount > 0 || isPublic)" />\n\t\t\t\t\t<FirstRun v-else-if="!loading" />\n\t\t\t\t</template>\n\t\t\t</template>\n\t\t\t\x3c!-- SHARED_FOLDERS VIEW --\x3e\n\t\t\t<template v-else-if="$route.name === routes.SHARED_FOLDERS">\n\t\t\t\t<Folder v-for="folder in subFolders"\n\t\t\t\t\t:key=" \'sharedfolders\' + \'folder\' + folder.id"\n\t\t\t\t\t:folder="folder" />\n\t\t\t\t<template v-if="subFolders.length === 0">\n\t\t\t\t\t<NoBookmarks v-if="!loading && (allBookmarksCount > 0 || isPublic)" />\n\t\t\t\t\t<FirstRun v-else-if="!loading" />\n\t\t\t\t</template>\n\t\t\t</template>\n\t\t\t\x3c!-- NON-FOLDER VIEW --\x3e\n\t\t\t<template v-else>\n\t\t\t\t<Folder v-for="folder in subFolders"\n\t\t\t\t\t:key=" \'nosort\' + \'folder\' + folder.id"\n\t\t\t\t\t:folder="folder" />\n\t\t\t\t<Bookmark v-for="bookmark in bookmarks"\n\t\t\t\t\t:key="\'nosort\' + \'bookmark\' + bookmark.id"\n\t\t\t\t\t:bookmark="bookmark" />\n\t\t\t\t<template v-if="!subFolders.length && !bookmarks.length">\n\t\t\t\t\t<NoBookmarks v-if="!loading && (allBookmarksCount > 0 || isPublic)" />\n\t\t\t\t\t<FirstRun v-else-if="!loading" />\n\t\t\t\t</template>\n\t\t\t</template>\n\t\t</VirtualScroll>\n\t</div>\n</template>\n\n<script>\nimport { NcButton, NcNoteCard } from \'@nextcloud/vue\'\nimport Bookmark from \'./Bookmark.vue\'\nimport Folder from \'./Folder.vue\'\nimport CreateBookmark from \'./CreateBookmark.vue\'\nimport CreateFolder from \'./CreateFolder.vue\'\nimport { actions, mutations } from \'../store/index.js\'\nimport NoBookmarks from \'./NoBookmarks.vue\'\nimport FirstRun from \'./FirstRun.vue\'\nimport VirtualScroll from \'./VirtualScroll.vue\'\nimport { privateRoutes } from \'../router.js\'\nimport { MagnifyIcon } from \'./Icons.js\'\n\nexport default {\n\tname: \'BookmarksList\',\n\tcomponents: {\n\t\tNcButton,\n\t\tCreateFolder,\n\t\tCreateBookmark,\n\t\tVirtualScroll,\n\t\tFirstRun,\n\t\tNoBookmarks,\n\t\tBookmark,\n\t\tFolder,\n\t\tNcNoteCard,\n\t\tMagnifyIcon,\n\t},\n\tcomputed: {\n\t\tbookmarks() {\n\t\t\treturn this.$store.state.bookmarks\n\t\t},\n\t\treachedEnd() {\n\t\t\treturn this.$store.state.fetchState.reachedEnd\n\t\t},\n\t\tdescriptionShown() {\n\t\t\treturn this.$route.name === this.routes.ARCHIVED || (this.$route.name === this.routes.SEARCH && Number(this.$route.params.folder) !== -1) || this.$route.name === this.routes.UNAVAILABLE || this.$route.name === this.routes.SHARED_FOLDERS || this.$route.name === this.routes.DUPLICATED\n\t\t},\n\t\tallBookmarksCount() {\n\t\t\treturn this.$store.state.countsByFolder[-1]\n\t\t},\n\t\tchildren() {\n\t\t\tif (this.$route.name !== this.routes.HOME && this.$route.name !== this.routes.FOLDER) {\n\t\t\t\treturn []\n\t\t\t}\n\t\t\tconst folderId = this.$route.params.folder || \'-1\'\n\t\t\tif (!folderId) return []\n\t\t\treturn this.$store.getters.getFolderChildren(folderId)\n\t\t},\n\t\tsubFolders() {\n\t\t\tif (this.$route.name === this.routes.SHARED_FOLDERS) {\n\t\t\t\t// Show shared folders\n\t\t\t\treturn Object.keys(this.$store.state.sharedFoldersById)\n\t\t\t\t\t.map(folderId => this.$store.getters.getFolder(folderId)[0])\n\t\t\t\t\t.filter(Boolean)\n\t\t\t}\n\t\t\tif (this.$route.name === this.routes.TRASHBIN) {\n\t\t\t\t// Show deleted folders\n\t\t\t\treturn this.$store.state.deletedFolders\n\t\t\t}\n\t\t\tif (this.$route.name === this.routes.SEARCH) {\n\t\t\t\t// Search folders\n\t\t\t\tconst searchFolder = (folder) => {\n\t\t\t\t\tconst results = folder.children.flatMap(searchFolder)\n\t\t\t\t\tif (folder.title && this.$store.state.fetchState.query.search && this.$store.state.fetchState.query.search.every(term => term.trim() && folder.title.toLowerCase().includes(term.toLowerCase()))) {\n\t\t\t\t\t\tresults.push(folder)\n\t\t\t\t\t}\n\t\t\t\t\treturn results\n\t\t\t\t}\n\t\t\t\treturn this.$store.getters.getFolder(this.$store.state.fetchState.query.folder || -1)[0].children.flatMap(searchFolder)\n\t\t\t}\n\t\t\tif (this.$route.name !== this.routes.HOME && this.$route.name !== this.routes.FOLDER) {\n\t\t\t\treturn []\n\t\t\t}\n\t\t\tconst folderId = this.$route.params.folder || \'-1\'\n\t\t\tif (!folderId) return []\n\t\t\tconst folder = this.$store.getters.getFolder(folderId)[0]\n\t\t\tif (!folder) return []\n\t\t\tthis.$store.dispatch(actions.LOAD_SHARES_OF_FOLDER, folderId)\n\t\t\treturn folder.children\n\t\t},\n\t\tnewBookmark() {\n\t\t\treturn this.$store.state.displayNewBookmark\n\t\t},\n\t\tnewFolder() {\n\t\t\treturn this.$store.state.displayNewFolder\n\t\t},\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tsortOrder() {\n\t\t\treturn this.$store.state.settings.sorting\n\t\t},\n\t\tloading() {\n\t\t\treturn this.$store.state.loading.bookmarks || this.$store.state.loading.folders\n\t\t},\n\t},\n\tmethods: {\n\t\tloadMore() {\n\t\t\tif (this.$route.name === privateRoutes.SHARED_FOLDERS) {\n\t\t\t\tthis.$store.commit(mutations.REACHED_END)\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.dispatch(actions.FETCH_PAGE)\n\t\t},\n\t\tgetFolder(id) {\n\t\t\treturn this.$store.getters.getFolder(id)[0]\n\t\t},\n\t\tgetBookmark(id) {\n\t\t\treturn this.$store.getters.getBookmark(id)\n\t\t},\n\t\tonSearchGlobally() {\n\t\t\tthis.$router.push({ name: this.routes.SEARCH, params: { search: this.$route.params.search, folder: \'-1\' } })\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.folder--gridview,\n.bookmark--gridview,\n.bookmarkslist--gridview .create-folder,\n.bookmarkslist--gridview .create-bookmark {\n\twidth: 250px;\n\theight: 200px;\n\talign-items: flex-end;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius);\n}\n</style>\n'],sourceRoot:""}]);const a=s},25080(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.bulkediting {\n\topacity: 1 !important;\n\tpadding: 0 !important;\n\tmargin-top: 1px;\n\tmin-width: 500px;\n}\n","",{version:3,sources:["webpack://./src/components/BulkEditing.vue"],names:[],mappings:";AA8JA;CACA,qBAAA;CACA,qBAAA;CACA,eAAA;CACA,gBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"bulkediting\">\n\t\t<NcActions :primary=\"true\" :menu-name=\"selectionDescription\">\n\t\t\t<NcActionButton close-after-click @click=\"onBulkOpen\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<OpenInNewIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Open all selected') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton close-after-click @click=\"onBulkMove\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderMoveIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Move selection') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton v-if=\"!selectedFolders.length\" close-after-click @click=\"onBulkCopy\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<FolderPlusIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Add to folders') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionInput v-if=\"!selectedFolders.length\"\n\t\t\t\t:value=\"selectionTags\"\n\t\t\t\ttype=\"multiselect\"\n\t\t\t\t:options=\"allTags\"\n\t\t\t\t:multiple=\"true\"\n\t\t\t\t:taggable=\"true\"\n\t\t\t\t@tag=\"onBulkTag([...selectionTags, $event])\"\n\t\t\t\t@input=\"onBulkTag\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<TagIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Edit tags of selection') }}\n\t\t\t</NcActionInput>\n\t\t\t<NcActionButton close-after-click @click=\"onBulkDelete\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<DeleteIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Delete selection') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionSeparator />\n\t\t\t<NcActionButton @click=\"onSelectAll\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<SelectAllIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Select all') }}\n\t\t\t</NcActionButton>\n\t\t\t<NcActionButton @click=\"onCancelSelection\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<SelectOffIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t\t{{ t('bookmarks', 'Cancel selection') }}\n\t\t\t</NcActionButton>\n\t\t</NcActions>\n\t</div>\n</template>\n\n<script>\n\nimport { NcActions, NcActionSeparator, NcActionButton, NcActionInput } from '@nextcloud/vue'\nimport { FolderPlusIcon, FolderMoveIcon, OpenInNewIcon, TagIcon, SelectAllIcon, SelectOffIcon, DeleteIcon } from './Icons.js'\nimport { actions, mutations } from '../store/index.js'\nimport intersection from 'lodash/intersection.js'\n\nexport default {\n\tname: 'BulkEditing',\n\tcomponents: { NcActionInput, NcActionSeparator, FolderPlusIcon, FolderMoveIcon, NcActionButton, NcActions, OpenInNewIcon, TagIcon, SelectAllIcon, SelectOffIcon, DeleteIcon },\n\tdata() {\n\t\treturn {\n\t\t\tselectionTags: [],\n\t\t}\n\t},\n\tcomputed: {\n\t\tallTags() {\n\t\t\treturn this.$store.state.tags.map(tag => tag.name)\n\t\t},\n\t\tselectedFolders() {\n\t\t\treturn this.$store.state.selection.folders\n\t\t},\n\t\tselectedBookmarks() {\n\t\t\treturn this.$store.state.selection.bookmarks\n\t\t},\n\t\tselectionDescription() {\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0 && this.$store.state.selection.folders.length !== 0) {\n\t\t\t\treturn this.t('bookmarks',\n\t\t\t\t\t'Selected {folders} folders and {bookmarks} bookmarks',\n\t\t\t\t\t{ folders: this.$store.state.selection.folders.length, bookmarks: this.$store.state.selection.bookmarks.length },\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0) {\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'Selected %n bookmark',\n\t\t\t\t\t'Selected %n bookmarks',\n\t\t\t\t\tthis.$store.state.selection.bookmarks.length,\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.folders.length !== 0) {\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'Selected %n folder',\n\t\t\t\t\t'Selected %n folders',\n\t\t\t\t\tthis.$store.state.selection.folders.length,\n\t\t\t\t)\n\t\t\t}\n\t\t\treturn ''\n\t\t},\n\t},\n\twatch: {\n\t\tselectedBookmarks(bookmarks) {\n\t\t\tthis.updateSelectionTags()\n\t\t},\n\t},\n\tmethods: {\n\t\tasync onBulkOpen() {\n\t\t\tfor (const { url } of this.$store.state.selection.bookmarks) {\n\t\t\t\twindow.open(url)\n\t\t\t\tawait new Promise(resolve => setTimeout(resolve, 200))\n\t\t\t}\n\t\t},\n\t\tasync onBulkDelete() {\n\t\t\tif (!confirm(t('bookmarks', 'Do you really want to delete these items?'))) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tawait this.$store.dispatch(actions.DELETE_SELECTION, { folder: this.$route.params.folder })\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t},\n\t\tonBulkMove() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, true)\n\t\t},\n\t\tonBulkCopy() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_COPY_DIALOG, true)\n\t\t},\n\t\tasync onBulkTag(tags) {\n\t\t\tconst originalTags = this.selectionTags\n\t\t\tthis.selectionTags = tags\n\t\t\tawait this.$store.dispatch(actions.TAG_SELECTION, { tags, originalTags })\n\t\t},\n\t\tonCancelSelection() {\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t},\n\t\tasync onSelectAll() {\n\t\t\tawait this.$store.dispatch(actions.FETCH_ALL)\n\t\t\tthis.$store.state.bookmarks.forEach(bookmark => {\n\t\t\t\tthis.$store.commit(mutations.ADD_SELECTION_BOOKMARK, bookmark)\n\t\t\t})\n\t\t},\n\t\tupdateSelectionTags() {\n\t\t\tthis.selectionTags = intersection(...this.selectedBookmarks.map((bm) => bm.tags))\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.bulkediting {\n\topacity: 1 !important;\n\tpadding: 0 !important;\n\tmargin-top: 1px;\n\tmin-width: 500px;\n}\n</style>\n"],sourceRoot:""}]);const a=s},43069(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.controls {\n\tpadding: 5px 8px 0 50px;\n\tdisplay: flex;\n\tposition: absolute;\n\tz-index: 100;\n\tbackground: var(--color-main-background-translucent);\n\tinset-inline: 0;\n\ttop: 0;\n\tborder-bottom: var(--color-border) 1px solid;\n\theight: 46px;\n}\n.controls h2 {\n\tmargin: 0;\n\tmargin-inline: 10px;\n\tdisplay: flex;\n\tflex-shrink: 0;\n\tfont-size: 1.1rem;\n}\n.controls h2 :nth-child(2) {\n\tmargin-inline-start: 5px;\n}\n.controls .strikethrough {\n\ttext-decoration: line-through;\n}\n.controls.wide {\n\tpadding: 0 8px;\n}\n.controls + * {\n\tmargin-top: 50px;\n}\n.controls__left {\n\tdisplay: flex;\n\talign-items: center;\n\tflex: 0;\n}\n.controls__tags {\n\twidth: 300px;\n\tflex: 1;\n}\n.controls__right {\n\tflex: 2;\n\tdisplay: flex;\n\tflex-direction: row-reverse;\n\tpadding: 0;\n}\n.controls__right > * {\n\tmin-width: 30px;\n}\n.controls__right .inline-search {\n\tmax-width: 300px !important;\n\tposition: relative;\n\ttop: -4px;\n}\n","",{version:3,sources:["webpack://./src/components/Controls.vue"],names:[],mappings:";AAgWA;CACA,uBAAA;CACA,aAAA;CACA,kBAAA;CACA,YAAA;CACA,oDAAA;CACA,eAAA;CACA,MAAA;CACA,4CAAA;CACA,YAAA;AACA;AAEA;CACA,SAAA;CACA,mBAAA;CACA,aAAA;CACA,cAAA;CACA,iBAAA;AACA;AAEA;CACA,wBAAA;AACA;AAEA;CACA,6BAAA;AACA;AAEA;CACA,cAAA;AACA;AAEA;CACA,gBAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,OAAA;AACA;AAEA;CACA,YAAA;CACA,OAAA;AACA;AAEA;CACA,OAAA;CACA,aAAA;CACA,2BAAA;CACA,UAAA;AACA;AAEA;CACA,eAAA;AACA;AAEA;CACA,2BAAA;CACA,kBAAA;CACA,SAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div :class=\"['controls', $store.state.public && 'wide']\">\n\t\t<div class=\"controls__left\">\n\t\t\t<TrashbinIcon v-if=\"isTrashbin\" :size=\"20\" />\n\t\t\t<h2 v-if=\"isTrashbin\">\n\t\t\t\t{{ t('bookmarks', 'Trash Bin') }}\n\t\t\t</h2>\n\t\t\t<NcActions v-if=\"$route.name === routes.FOLDER || ($route.name === routes.SEARCH && Number($route.params.folder) !== -1)\">\n\t\t\t\t<NcActionButton @click=\"onClickBack\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<ArrowLeftIcon :size=\"20\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Go back') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<template v-if=\"$route.name === routes.FOLDER || ($route.name === routes.SEARCH && Number($route.params.folder) !== -1)\">\n\t\t\t\t<h2><FolderIcon :size=\"20\" /> <span v-if=\"folder\" :class=\"{strikethrough: isTrashbin}\">{{ folder.title }}</span></h2>\n\t\t\t\t<NcActions v-if=\"permissions.canShare && !isTrashbin\">\n\t\t\t\t\t<NcActionButton :close-after-click=\"true\" @click=\"onOpenFolderShare\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<ShareVariantIcon :size=\"20\" />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t{{ t('bookmarks', 'Share folder') }}\n\t\t\t\t\t</NcActionButton>\n\t\t\t\t</NcActions>\n\t\t\t\t<NcActions v-if=\"!isTrashbin\">\n\t\t\t\t\t<NcActionButton :close-after-click=\"true\" @click=\"onOpenFolderDetails\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<InformationVariantIcon :size=\"20\" />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t\t{{ t('bookmarks', 'Open folder details') }}\n\t\t\t\t\t</NcActionButton>\n\t\t\t\t</NcActions>\n\t\t\t</template>\n\t\t\t<template v-if=\"$route.name === routes.TAGS\">\n\t\t\t\t<TagIcon :size=\"20\" />\n\t\t\t\t<NcSelect class=\"controls__tags\"\n\t\t\t\t\t:value=\"tags\"\n\t\t\t\t\t:auto-limit=\"false\"\n\t\t\t\t\t:limit=\"7\"\n\t\t\t\t\t:options=\"allTags\"\n\t\t\t\t\t:multiple=\"true\"\n\t\t\t\t\t:placeholder=\"t('bookmarks', 'Select one or more tags')\"\n\t\t\t\t\t@input=\"onTagsChange\" />\n\t\t\t</template>\n\t\t\t<NcActions v-if=\"!isPublic && !isTrashbin\"\n\t\t\t\tv-tooltip=\"t('bookmarks', 'New')\"\n\t\t\t\t:name=\"t('bookmarks', 'New')\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<PlusIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t\t<NcActionButton :close-after-click=\"true\"\n\t\t\t\t\t@click=\"onAddBookmark\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<EarthIcon :size=\"20\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{\n\t\t\t\t\t\tt('bookmarks', 'New bookmark')\n\t\t\t\t\t}}\n\t\t\t\t</NcActionButton>\n\t\t\t\t<NcActionButton :close-after-click=\"true\"\n\t\t\t\t\t@click=\"onAddFolder\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<FolderIcon :size=\"20\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'New folder') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<BulkEditing v-if=\"hasSelection\" />\n\t\t</div>\n\t\t<div class=\"controls__right\">\n\t\t\t<div>\n\t\t\t\t<NcActions>\n\t\t\t\t\t<NcActionButton :name=\"viewMode === 'list' ? t('bookmarks', 'Change to grid view') : t('bookmarks', 'Change to list view')\" @click=\"onToggleViewMode\">\n\t\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t\t<ViewListIcon v-if=\"viewMode !== 'list'\" :size=\"20\" />\n\t\t\t\t\t\t\t<ViewGridIcon v-else :size=\"20\" />\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</NcActionButton>\n\t\t\t\t</NcActions>\n\t\t\t</div>\n\t\t\t<NcActions v-tooltip=\"sortingOptions[sorting].description\">\n\t\t\t\t<template #icon>\n\t\t\t\t\t<component :is=\"sortingOptions[sorting].icon\" :fill-color=\"colorMainText\" />\n\t\t\t\t</template>\n\t\t\t\t<NcActionButton v-for=\"(option, key) in sortingOptions\"\n\t\t\t\t\t:key=\"key\"\n\t\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t\t@click=\"onChangeSorting(key)\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<component :is=\"option.icon\"\n\t\t\t\t\t\t\t:size=\"20\"\n\t\t\t\t\t\t\t:fill-color=\"key === sorting? colorPrimaryElement : colorMainText\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ option.description }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<NcActions v-if=\"!isTrashbin\" force-menu>\n\t\t\t\t<template #icon>\n\t\t\t\t\t<RssIcon :size=\"20\" />\n\t\t\t\t</template>\n\t\t\t\t<NcActionButton :name=\"t('bookmarks', 'Copy RSS Feed of current view')\"\n\t\t\t\t\t:close-after-click=\"true\"\n\t\t\t\t\t@click=\"copyRssUrl\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<RssIcon :size=\"20\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ !$store.state.public? t('bookmarks', 'The RSS feed requires authentication with your Nextcloud credentials') : '' }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<NcTextField v-if=\"!isTrashbin\"\n\t\t\t\t:value.sync=\"search\"\n\t\t\t\t:label=\"t('bookmarks','Search')\"\n\t\t\t\t:placeholder=\"t('bookmarks','Search')\"\n\t\t\t\tclass=\"inline-search\"\n\t\t\t\t@update:value=\"onSearch($event)\">\n\t\t\t\t<MagnifyIcon :size=\"20\" />\n\t\t\t</NcTextField>\n\t\t\t<template v-if=\"isTrashbinRoot\">\n\t\t\t\t<NcButton @click=\"onEmptyTrashbin\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<DeleteForeverIcon :size=\"20\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Empty trash bin') }}\n\t\t\t\t</NcButton>\n\t\t\t</template>\n\t\t</div>\n\t</div>\n</template>\n<script>\nimport { NcButton, NcSelect, NcActions, NcActionButton, NcActionInput, NcActionRouter, NcTextField } from '@nextcloud/vue'\nimport { InformationVariantIcon, DeleteForeverIcon, TrashbinIcon, MagnifyIcon, EarthIcon, ViewGridIcon, ViewListIcon, PlusIcon, FolderIcon, ArrowLeftIcon, RssIcon, SortAlphabeticalAscendingIcon, SortBoolAscendingIcon, SortClockAscendingOutlineIcon, SortCalendarAscendingIcon, SortNumericAscendingIcon, SortAscendingIcon, ShareVariantIcon, TagIcon } from './Icons.js'\nimport { actions, mutations } from '../store/index.js'\nimport { generateUrl } from '@nextcloud/router'\nimport BulkEditing from './BulkEditing.vue'\n\nexport default {\n\tname: 'Controls',\n\tcomponents: {\n\t\tNcButton,\n\t\tBulkEditing,\n\t\tDeleteForeverIcon,\n\t\tTrashbinIcon,\n\t\tNcSelect,\n\t\tNcActions,\n\t\tNcActionButton,\n\t\tNcActionInput,\n\t\tNcActionRouter,\n\t\tRssIcon,\n\t\tSortAscendingIcon,\n\t\tSortCalendarAscendingIcon,\n\t\tSortAlphabeticalAscendingIcon,\n\t\tSortClockAscendingOutlineIcon,\n\t\tSortBoolAscendingIcon,\n\t\tSortNumericAscendingIcon,\n\t\tFolderIcon,\n\t\tArrowLeftIcon,\n\t\tPlusIcon,\n\t\tViewGridIcon,\n\t\tViewListIcon,\n\t\tEarthIcon,\n\t\tShareVariantIcon,\n\t\tTagIcon,\n\t\tNcTextField,\n\t\tMagnifyIcon,\n\t\tInformationVariantIcon,\n\t},\n\tprops: {},\n\tdata() {\n\t\treturn {\n\t\t\tsearchTimeout: null,\n\t\t\turl: '',\n\t\t\tsearch: this.$route.params.search || '',\n\t\t\tsortingOptions: {\n\t\t\t\tadded: { icon: 'SortCalendarAscendingIcon', description: this.t('bookmarks', 'Sort by created date') },\n\t\t\t\tlastmodified: { icon: 'SortClockAscendingOutlineIcon', description: this.t('bookmarks', 'Sort by last modified') },\n\t\t\t\ttitle: { icon: 'SortAlphabeticalAscendingIcon', description: this.t('bookmarks', 'Sort by title') },\n\t\t\t\tclickcount: { icon: 'SortBoolAscendingIcon', description: this.t('bookmarks', 'Sort by click count') },\n\t\t\t\tindex: { icon: 'SortAscendingIcon', description: this.t('bookmarks', 'Sort by manual order') },\n\t\t\t\turl: { icon: 'SortNumericAscendingIcon', description: this.t('bookmarks', 'Sort by URL') },\n\t\t\t},\n\t\t}\n\t},\n\tcomputed: {\n\t\tisTrashbin() {\n\t\t\treturn this.$route.name === this.routes.TRASHBIN || (this.$route.name === this.routes.FOLDER && this.folder && this.folder.softDeleted)\n\t\t},\n\t\tisTrashbinRoot() {\n\t\t\treturn this.$route.name === this.routes.TRASHBIN\n\t\t},\n\t\tbackLink() {\n\t\t\tif (this.folder && this.folderPath.length > 1) {\n\t\t\t\treturn { name: this.routes.FOLDER, params: { folder: this.folder.parent_folder } }\n\t\t\t}\n\n\t\t\tif (this.isTrashbin) {\n\t\t\t\treturn { name: this.routes.TRASHBIN }\n\t\t\t}\n\n\t\t\treturn { name: this.routes.HOME }\n\t\t},\n\t\tpermissions() {\n\t\t\tconst folder = this.folder\n\t\t\tif (!folder) {\n\t\t\t\treturn {}\n\t\t\t}\n\t\t\treturn this.$store.getters.getPermissionsForFolder(folder.id)\n\t\t},\n\t\tallTags() {\n\t\t\treturn this.$store.state.tags.map(tag => tag.name)\n\t\t},\n\t\ttags() {\n\t\t\tconst tags = this.$route.params.tags\n\t\t\tif (!tags) return []\n\t\t\treturn tags.split(',')\n\t\t},\n\t\tfolderPath() {\n\t\t\tconst folder = this.$route.params.folder\n\t\t\tif (!folder) return []\n\t\t\treturn this.$store.getters.getFolder(folder).reverse()\n\t\t},\n\t\tfolder() {\n\t\t\tconst folder = this.$route.params.folder\n\t\t\tif (!folder) return\n\t\t\treturn this.$store.getters.getFolder(folder)[0]\n\t\t},\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\thasSelection() {\n\t\t\treturn this.$store.state.selection.bookmarks.length || this.$store.state.selection.folders.length\n\t\t},\n\t\trssURL() {\n\t\t\tconst params = new URLSearchParams()\n\t\t\tfor (const field in this.$store.state.fetchState.query) {\n\t\t\t\tif (Array.isArray(this.$store.state.fetchState.query[field])) {\n\t\t\t\t\tthis.$store.state.fetchState.query[field].forEach(value => {\n\t\t\t\t\t\tparams.append(field + '[]', value)\n\t\t\t\t\t})\n\t\t\t\t} else {\n\t\t\t\t\tparams.append(field, this.$store.state.fetchState.query[field])\n\t\t\t\t}\n\t\t\t}\n\t\t\tparams.set('format', 'rss')\n\t\t\tparams.set('page', '-1')\n\t\t\tif (this.$store.state.public) {\n\t\t\t\tparams.set('token', this.$store.state.authToken)\n\t\t\t}\n\t\t\treturn (\n\t\t\t\twindow.location.origin\n\t\t\t\t\t+ generateUrl(\n\t\t\t\t\t\t'/apps/bookmarks/public/rest/v2/bookmark?'\n\t\t\t\t\t\t\t+ params.toString(),\n\t\t\t\t\t)\n\t\t\t)\n\t\t},\n\t\tsorting() {\n\t\t\treturn this.$store.state.settings.sorting\n\t\t},\n\t},\n\tcreated() {},\n\tmethods: {\n\t\tonSelectHome() {\n\t\t\tthis.$router.push({ name: this.routes.HOME })\n\t\t},\n\n\t\tonClickBack() {\n\t\t\tthis.$router.push(this.backLink)\n\t\t},\n\n\t\tonTagsChange(tags) {\n\t\t\tthis.$router.push({ name: this.routes.TAGS, params: { tags: tags.join(',') } })\n\t\t},\n\n\t\tonSelectFolder(folder) {\n\t\t\tthis.$router.push({ name: this.routes.FOLDER, params: { folder } })\n\t\t},\n\n\t\tonOpenFolderShare() {\n\t\t\tif (!this.folder) return\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_SHARING, this.folder.id)\n\t\t},\n\n\t\tonOpenFolderDetails() {\n\t\t\tif (!this.folder) return\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_DETAILS, this.folder.id)\n\t\t},\n\n\t\tonAddFolder() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_FOLDER,\n\t\t\t\t!this.$store.state.displayNewFolder,\n\t\t\t)\n\t\t},\n\t\tonAddBookmark() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_BOOKMARK,\n\t\t\t\t!this.$store.state.displayNewBookmark,\n\t\t\t)\n\t\t},\n\n\t\tonToggleViewMode() {\n\t\t\tthis.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'viewMode',\n\t\t\t\tvalue: this.$store.state.viewMode === 'grid' ? 'list' : 'grid',\n\t\t\t})\n\t\t},\n\n\t\tonSearch(query) {\n\t\t\tif (this.searchTimeout) clearTimeout(this.searchTimeout)\n\t\t\tthis.searchTimeout = setTimeout(() => {\n\t\t\t\tif (query.trim().length < 3) {\n\t\t\t\t\treturn\n\t\t\t\t}\n\t\t\t\tif (query.trim()) {\n\t\t\t\t\tthis.$router.push({ name: this.routes.SEARCH, params: { search: query, folder: this.folder?.id || -1 } })\n\t\t\t\t} else if (this.$route.name === this.routes.SEARCH) {\n\t\t\t\t\tif (this.folder) {\n\t\t\t\t\t\tthis.$router.push({ name: this.routes.FOLDER, params: { folder: this.folder.id } })\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis.$router.push({ name: this.routes.HOME })\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}, 350)\n\t\t},\n\n\t\tcopyRssUrl() {\n\t\t\tnavigator.clipboard.writeText(this.rssURL)\n\t\t\tthis.$store.commit(mutations.SET_NOTIFICATION, t('bookmarks', 'RSS feed copied'))\n\t\t},\n\n\t\tasync onChangeSorting(value) {\n\t\t\tawait this.$store.dispatch(actions.SET_SETTING, {\n\t\t\t\tkey: 'sorting',\n\t\t\t\tvalue,\n\t\t\t})\n\t\t\tawait this.$store.dispatch(actions.FETCH_PAGE)\n\t\t},\n\n\t\tasync onEmptyTrashbin() {\n\t\t\tawait this.$store.dispatch(actions.EMPTY_TRASHBIN)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.controls {\n\tpadding: 5px 8px 0 50px;\n\tdisplay: flex;\n\tposition: absolute;\n\tz-index: 100;\n\tbackground: var(--color-main-background-translucent);\n\tinset-inline: 0;\n\ttop: 0;\n\tborder-bottom: var(--color-border) 1px solid;\n\theight: 46px;\n}\n\n.controls h2 {\n\tmargin: 0;\n\tmargin-inline: 10px;\n\tdisplay: flex;\n\tflex-shrink: 0;\n\tfont-size: 1.1rem;\n}\n\n.controls h2 :nth-child(2) {\n\tmargin-inline-start: 5px;\n}\n\n.controls .strikethrough {\n\ttext-decoration: line-through;\n}\n\n.controls.wide {\n\tpadding: 0 8px;\n}\n\n.controls + * {\n\tmargin-top: 50px;\n}\n\n.controls__left {\n\tdisplay: flex;\n\talign-items: center;\n\tflex: 0;\n}\n\n.controls__tags {\n\twidth: 300px;\n\tflex: 1;\n}\n\n.controls__right {\n\tflex: 2;\n\tdisplay: flex;\n\tflex-direction: row-reverse;\n\tpadding: 0;\n}\n\n.controls__right > * {\n\tmin-width: 30px;\n}\n\n.controls__right .inline-search {\n\tmax-width: 300px !important;\n\tposition: relative;\n\ttop: -4px;\n}\n</style>\n"],sourceRoot:""}]);const a=s},92229(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.icon[data-v-96c6698c] {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n.item--gridview .icon[data-v-96c6698c] {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tinset-inline-start: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n","",{version:3,sources:["webpack://./src/components/CreateBookmark.vue"],names:[],mappings:";AAyDA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,eAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,oCAAA;CACA,mBAAA;CACA,0BAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :selectable="false"\n\t\t:renaming="true"\n\t\ttitle=""\n\t\t:editable="true"\n\t\t:rename-placeholder="t(\'bookmarks\', \'Enter a link\')"\n\t\tselect-label=""\n\t\t@rename="submit"\n\t\t@rename-cancel="cancel">\n\t\t<template #icon>\n\t\t\t<EarthIcon :size="20" :fill-color="colorMainText" class="icon" />\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport { EarthIcon } from \'./Icons.js\'\nimport Item from \'./Item.vue\'\nimport { actions, mutations } from \'../store/index.js\'\n\nexport default {\n\tname: \'CreateBookmark\',\n\tcomponents: { Item, EarthIcon },\n\tcomputed: {\n\t\tcreating() {\n\t\t\treturn this.$store.state.loading.createBookmark\n\t\t},\n\t\tisFolderView() {\n\t\t\treturn this.$route.name === this.$store.getters.getRoutes().FOLDER\n\t\t},\n\t\tisTagView() {\n\t\t\treturn this.$route.name === this.$store.getters.getRoutes().TAGS\n\t\t},\n\t},\n\tmethods: {\n\t\tsubmit(url) {\n\t\t\tthis.$store.dispatch(actions.CREATE_BOOKMARK, {\n\t\t\t\turl,\n\t\t\t\t...(this.isFolderView && { folders: [this.$route.params.folder] }),\n\t\t\t\t...(this.isTagView && { tags: this.$route.params.tags.split(\',\') }),\n\t\t\t})\n\t\t},\n\t\tcancel() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_BOOKMARK,\n\t\t\t\tfalse,\n\t\t\t)\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n\n.item--gridview .icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tinset-inline-start: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n</style>\n'],sourceRoot:""}]);const a=s},42325(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.icon[data-v-14270aa2] {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n.item--gridview .icon[data-v-14270aa2] {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tinset-inline-start: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n","",{version:3,sources:["webpack://./src/components/CreateFolder.vue"],names:[],mappings:";AAmDA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,eAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,oCAAA;CACA,mBAAA;CACA,0BAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :selectable="false"\n\t\t:renaming="true"\n\t\ttitle=""\n\t\t:editable="true"\n\t\t:rename-placeholder="t(\'bookmarks\', \'Enter a title\')"\n\t\tselect-label=""\n\t\t@rename="submit"\n\t\t@rename-cancel="cancel">\n\t\t<template #icon>\n\t\t\t<FolderIcon :size="20" :fill-color="colorPrimaryElement" class="icon" />\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport { FolderIcon } from \'./Icons.js\'\nimport Item from \'./Item.vue\'\nimport { actions, mutations } from \'../store/index.js\'\n\nexport default {\n\tname: \'CreateFolder\',\n\tcomponents: { Item, FolderIcon },\n\tcomputed: {\n\t\tloading() {\n\t\t\treturn this.$store.state.loading.createFolder\n\t\t},\n\t},\n\tmethods: {\n\t\tsubmit(title) {\n\t\t\tconst parentFolder = this.$route.params.folder\n\t\t\tthis.$store.dispatch(actions.CREATE_FOLDER, {\n\t\t\t\tparentFolder,\n\t\t\t\ttitle,\n\t\t\t})\n\t\t},\n\t\tcancel() {\n\t\t\tthis.$store.commit(\n\t\t\t\tmutations.DISPLAY_NEW_FOLDER,\n\t\t\t\tfalse,\n\t\t\t)\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n\n.item--gridview .icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tinset-inline-start: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n</style>\n'],sourceRoot:""}]);const a=s},81946(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.dragImage[data-v-362d49f6] {\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px;\n\tborder-radius: var(--border-radius-large);\n\twidth: 250px;\n\theight: 1.5em;\n\tpadding: 10px;\n\tdisplay: flex;\n\tflex-direction: row;\n}\n.dragImage .description[data-v-362d49f6] {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tflex-grow: 1;\n\theight: 1.5em;\n\tdisplay: inline-block;\n\tmargin-inline-start: 3px;\n}\n","",{version:3,sources:["webpack://./src/components/DragImage.vue"],names:[],mappings:";AAqDA;CACA,wCAAA;CACA,qCAAA;CACA,oCAAA;CACA,yCAAA;CACA,YAAA;CACA,aAAA;CACA,aAAA;CACA,aAAA;CACA,mBAAA;AACA;AAEA;CACA,uBAAA;CACA,gBAAA;CACA,YAAA;CACA,aAAA;CACA,qBAAA;CACA,wBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2021. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"dragImage\">\n\t\t<FolderIcon v-if=\"$store.state.selection.folders.length\" :size=\"20\" :fill-color=\"colorPrimaryElement\" />\n\t\t<EarthIcon v-else :size=\"20\" :fill-color=\"colorPrimaryElement\" /><span class=\"description\">{{ selectionDescription }}</span>\n\t</div>\n</template>\n\n<script>\nimport { FolderIcon, EarthIcon } from './Icons.js'\nexport default {\n\tname: 'DragImage',\n\tcomponents: { FolderIcon, EarthIcon },\n\tcomputed: {\n\t\tselectionDescription() {\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0 && this.$store.state.selection.folders.length !== 0) {\n\t\t\t\treturn this.t('bookmarks',\n\t\t\t\t\t'{folders} folders and {bookmarks} bookmarks',\n\t\t\t\t\t{ folders: this.$store.state.selection.folders.length, bookmarks: this.$store.state.selection.bookmarks.length },\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.bookmarks.length !== 0) {\n\t\t\t\tif (this.$store.state.selection.bookmarks.length === 1) {\n\t\t\t\t\treturn this.$store.state.selection.bookmarks[0].title\n\t\t\t\t}\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'%n bookmark',\n\t\t\t\t\t'%n bookmarks',\n\t\t\t\t\tthis.$store.state.selection.bookmarks.length,\n\t\t\t\t)\n\t\t\t}\n\t\t\tif (this.$store.state.selection.folders.length !== 0) {\n\t\t\t\tif (this.$store.state.selection.folders.length === 1) {\n\t\t\t\t\treturn this.$store.state.selection.folders[0].title\n\t\t\t\t}\n\t\t\t\treturn this.n('bookmarks',\n\t\t\t\t\t'%n folder',\n\t\t\t\t\t'%n folders',\n\t\t\t\t\tthis.$store.state.selection.folders.length,\n\t\t\t\t)\n\t\t\t}\n\t\t\treturn ''\n\t\t},\n\t},\n}\n<\/script>\n\n<style scoped>\n.dragImage {\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px;\n\tborder-radius: var(--border-radius-large);\n\twidth: 250px;\n\theight: 1.5em;\n\tpadding: 10px;\n\tdisplay: flex;\n\tflex-direction: row;\n}\n\n.dragImage .description {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tflex-grow: 1;\n\theight: 1.5em;\n\tdisplay: inline-block;\n\tmargin-inline-start: 3px;\n}\n</style>\n"],sourceRoot:""}]);const a=s},78013(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.bookmarkslist__emptyBookmarks[data-v-3f36d5a7] {\n\twidth: 500px;\n\tmargin: 0 auto;\n}\n.import[data-v-3f36d5a7] {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tinset-inline-start: -1000px;\n}\nbutton[data-v-3f36d5a7] {\n\tmargin-bottom: 15px;\n}\n","",{version:3,sources:["webpack://./src/components/FirstRun.vue"],names:[],mappings:";AAkFA;CACA,YAAA;CACA,cAAA;AACA;AAEA;CACA,UAAA;CACA,kBAAA;CACA,MAAA;CACA,2BAAA;AACA;AAEA;CACA,mBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class=\"bookmarkslist__emptyBookmarks\">\n\t\t<NcEmptyContent :name=\"t('bookmarks', 'Welcome to Bookmarks')\" :description=\"t('bookmarks', 'This app allows you to manage links to your favorite places on the web. Sort your bookmarks into folders, label them with tags and share them with others! The app will regularly check all your links for availability and display unavailable links. If you add a link to a file on the web, the file will be automatically downloaded to your Nextcloud Files. You can also import bookmarks exported from other services or directly sync bookmarks from all your browsers with this app.')\">\n\t\t\t<template #icon>\n\t\t\t\t<StarShootingIcon :size=\"20\" />\n\t\t\t</template>\n\t\t\t<template #action>\n\t\t\t\t<input ref=\"import\"\n\t\t\t\t\ttype=\"file\"\n\t\t\t\t\tclass=\"import\"\n\t\t\t\t\tsize=\"5\"\n\t\t\t\t\t@change=\"onImportSubmit\">\n\t\t\t\t<NcButton @click=\"onCreateOpen\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<PlusIcon :size=\"20\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Add a bookmark') }}\n\t\t\t\t</NcButton>\n\t\t\t\t<NcButton @click=\"onImportOpen\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<UploadIcon v-if=\"!importing\" :size=\"20\" />\n\t\t\t\t\t\t<NcLoadingIcon v-else />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Import bookmarks') }}\n\t\t\t\t</NcButton>\n\t\t\t\t<NcButton @click=\"onSyncOpen\">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<SyncIcon :size=\"20\" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t('bookmarks', 'Sync with your browser') }}\n\t\t\t\t</NcButton>\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t</div>\n</template>\n\n<script>\nimport { NcEmptyContent, NcButton, NcLoadingIcon } from '@nextcloud/vue'\nimport { actions, mutations } from '../store/index.js'\nimport { privateRoutes } from '../router.js'\nimport { SyncIcon, PlusIcon, UploadIcon, StarShootingIcon } from './Icons.js'\n\nexport default {\n\tname: 'FirstRun',\n\tcomponents: { NcEmptyContent, SyncIcon, NcButton, PlusIcon, UploadIcon, NcLoadingIcon, StarShootingIcon },\n\tdata() {\n\t\treturn { importing: false }\n\t},\n\tcomputed: {\n\t\troutes() {\n\t\t\treturn privateRoutes\n\t\t},\n\t},\n\tmethods: {\n\t\tonCreateOpen() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_NEW_BOOKMARK, true)\n\t\t},\n\t\tonImportOpen() {\n\t\t\tthis.$refs.import.click()\n\t\t},\n\t\tonSyncOpen() {\n\t\t\twindow.open('https://floccus.org', '_blank')\n\t\t},\n\t\tasync onImportSubmit(e) {\n\t\t\tthis.importing = true\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.IMPORT_BOOKMARKS, { file: e.target.files[0], folder: this.$route.params.folder || -1 })\n\t\t\t} catch (e) {\n\t\t\t\tconsole.warn(e)\n\t\t\t}\n\t\t\tthis.importing = false\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.bookmarkslist__emptyBookmarks {\n\twidth: 500px;\n\tmargin: 0 auto;\n}\n\n.import {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tinset-inline-start: -1000px;\n}\n\nbutton {\n\tmargin-bottom: 15px;\n}\n</style>\n"],sourceRoot:""}]);const a=s},95895(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.folder__icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n.folder__icon.shared {\n\ttransform: scale(0.4);\n\tposition: absolute;\n\ttop: 1px;\n\theight: auto;\n\twidth: auto;\n\tinset-inline-start: -1px;\n}\n.item--gridview .folder__icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tinset-inline-start: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n.item--gridview .folder__icon.shared {\n\ttransform: translate(100%, 135%) scale(1.5);\n}\n.folder__title {\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\tmargin: 0;\n\tfont-size: 1em;\n\tfont-weight: normal;\n}\n.item--gridview .folder__title {\n\tmargin-inline-start: 15px;\n}\n.folder__tags {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n.item--gridview .folder__tags {\n\tposition: absolute;\n\tbottom: 47px;\n\tinset-inline-start: 10px;\n\tmargin: 0;\n}\n.folder__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-inline-end: 3px;\n\tbackground-color: var(--color-primary-element-light);\n}\n","",{version:3,sources:["webpack://./src/components/Folder.vue"],names:[],mappings:";AA+PA;CACA,YAAA;CACA,YAAA;CACA,WAAA;CACA,sBAAA;CACA,cAAA;CACA,eAAA;AACA;AAEA;CACA,qBAAA;CACA,kBAAA;CACA,QAAA;CACA,YAAA;CACA,WAAA;CACA,wBAAA;AACA;AAEA;CACA,sBAAA;CACA,kBAAA;CACA,QAAA;CACA,oCAAA;CACA,mBAAA;CACA,0BAAA;AACA;AAEA;CACA,2CAAA;AACA;AAEA;CACA,OAAA;CACA,uBAAA;CACA,gBAAA;CACA,mBAAA;CACA,eAAA;CACA,SAAA;CACA,cAAA;CACA,mBAAA;AACA;AAEA;CACA,yBAAA;AACA;AAEA;CACA,eAAA;CACA,YAAA;CACA,cAAA;CACA,gBAAA;CACA,qBAAA;CACA,cAAA;AACA;AAEA;CACA,kBAAA;CACA,YAAA;CACA,wBAAA;CACA,SAAA;AACA;AAEA;CACA,qBAAA;CACA,qCAAA;CACA,wCAAA;CACA,iBAAA;CACA,sBAAA;CACA,oDAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<Item :active="selected"\n\t\t:editable="isEditable"\n\t\t:draggable="isDraggable"\n\t\t:selected="selected"\n\t\t:title="folder.title"\n\t\t:renaming="renaming"\n\t\t:select-label="t(\'bookmarks\', \'Select folder\')"\n\t\t:rename-placeholder="t(\'bookmarks\', \'Enter folder title\')"\n\t\t:selectable="selectable"\n\t\t:allow-drop="allowDrop"\n\t\t@drop="onDrop"\n\t\t@select="clickSelect"\n\t\t@rename="onRenameSubmit"\n\t\t@rename-cancel="renaming = false"\n\t\t@click="onSelect">\n\t\t<template #icon>\n\t\t\t<FolderIcon :size="20"\n\t\t\t\t:fill-color="colorPrimaryElement"\n\t\t\t\t:class="\'folder__icon\'"\n\t\t\t\t@click="onSelect" />\n\t\t\t<ShareVariantIcon v-if="(isShared || !isOwner) || isSharedPublicly"\n\t\t\t\t:size="20"\n\t\t\t\t:fill-color="colorPrimaryElement"\n\t\t\t\t:class="[\'folder__icon\', \'shared\']" />\n\t\t</template>\n\t\t<template #title>\n\t\t\t<h3 class="folder__title">\n\t\t\t\t{{ folder.title }}\n\t\t\t</h3>\n\t\t</template>\n\t\t<template #tags>\n\t\t\t<div class="folder__tags">\n\t\t\t\t<div v-if="!isOwner && !isSharedPublicly" class="folder__tag">\n\t\t\t\t\t{{ t(\'bookmarks\', \'Shared by {user}\', {user: folder.userDisplayName}) }}\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</template>\n\t\t<template #actions>\n\t\t\t<template v-if="!isTrashbin">\n\t\t\t\t<NcActionButton :close-after-click="true" @click="onDetails">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<InformationVariantIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Details\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t\t<NcActionCheckbox @change="clickSelect">\n\t\t\t\t\t{{ t(\'bookmarks\', \'Select folder\') }}\n\t\t\t\t</NcActionCheckbox>\n\t\t\t\t<NcActionButton v-if="permissions.canShare"\n\t\t\t\t\ticon="icon-share"\n\t\t\t\t\t:close-after-click="true"\n\t\t\t\t\t@click="onShare">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<ShareVariantIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Share folder\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t\t<NcActionButton :close-after-click="true" @click="onRename">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<PencilIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Rename folder\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t\t<NcActionButton :close-after-click="true" @click="onMove">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<FolderMoveIcon :size="20" :fill-color="colorMainText" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Move folder\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t\t<NcActionButton :close-after-click="true" @click="onDelete(false)">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<DeleteIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Put folder into trashbin\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</template>\n\t\t\t<template v-else>\n\t\t\t\t<NcActionButton :close-after-click="true" @click="onUndelete">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<UndeleteIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Restore folder\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t\t<NcActionButton :close-after-click="true" @click="onDelete(true)">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<DeleteForeverIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Delete folder permanently\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</template>\n\t\t</template>\n\t</Item>\n</template>\n<script>\nimport { getCurrentUser } from \'@nextcloud/auth\'\nimport { UndeleteIcon, DeleteForeverIcon, FolderMoveIcon, FolderIcon, ShareVariantIcon, DeleteIcon, PencilIcon, InformationVariantIcon } from \'./Icons.js\'\nimport { NcActionButton, NcActionCheckbox } from \'@nextcloud/vue\'\nimport { actions, mutations } from \'../store/index.js\'\nimport Item from \'./Item.vue\'\n\nexport default {\n\tname: \'Folder\',\n\tcomponents: {\n\t\tItem,\n\t\tNcActionButton,\n\t\tNcActionCheckbox,\n\t\tFolderIcon,\n\t\tFolderMoveIcon,\n\t\tShareVariantIcon,\n\t\tDeleteIcon,\n\t\tDeleteForeverIcon,\n\t\tUndeleteIcon,\n\t\tPencilIcon,\n\t\tInformationVariantIcon,\n\t},\n\tprops: {\n\t\tfolder: {\n\t\t\ttype: Object,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn { renaming: false }\n\t},\n\tcomputed: {\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tcurrentUser() {\n\t\t\treturn getCurrentUser().uid\n\t\t},\n\t\tisOwner() {\n\t\t\tconst currentUser = getCurrentUser()\n\t\t\treturn currentUser && this.folder.userId === currentUser.uid\n\t\t},\n\t\tcontainingFolder() {\n\t\t\treturn this.$store.getters.getFolder(this.$store.state.fetchState.query.folder)[0]\n\t\t},\n\t\tisTrashbin() {\n\t\t\treturn (this.containingFolder && this.containingFolder.softDeleted) || this.$route.name === this.routes.TRASHBIN\n\t\t},\n\t\tpermissions() {\n\t\t\treturn this.$store.getters.getPermissionsForFolder(this.folder.id)\n\t\t},\n\t\tisDirectShare() {\n\t\t\treturn this.$store.state.sharedFoldersById[this.folder.id] !== undefined\n\t\t},\n\t\tisEditable() {\n\t\t\treturn this.isOwner || this.isDirectShare || this.permissions.canWrite\n\t\t},\n\t\tisDraggable() {\n\t\t\treturn this.isEditable && !this.isTrashbin\n\t\t},\n\t\tshares() {\n\t\t\treturn this.$store.getters.getSharesOfFolder(this.folder.id)\n\t\t},\n\t\tpublicToken() {\n\t\t\treturn this.$store.getters.getTokenOfFolder(this.folder.id)\n\t\t},\n\t\tisShared() {\n\t\t\treturn Boolean(this.shares.length)\n\t\t},\n\t\tisSharedPublicly() {\n\t\t\treturn Boolean(this.publicToken)\n\t\t},\n\t\tselectedFolders() {\n\t\t\treturn this.$store.state.selection.folders\n\t\t},\n\t\tselectable() {\n\t\t\treturn Boolean(this.$store.state.selection.bookmarks.length || this.$store.state.selection.folders.length)\n\t\t},\n\t\tselected() {\n\t\t\treturn this.selectedFolders.map(f => f.id).includes(this.folder.id)\n\t\t},\n\t},\n\tmounted() {\n\t\t// This slows down initial load otherwise and it\'s not directly necessary\n\t\tsetTimeout(() => {\n\t\t\tthis.$store.dispatch(actions.LOAD_SHARES_OF_FOLDER, this.folder.id)\n\t\t\tthis.$store.dispatch(actions.LOAD_PUBLIC_LINK, this.folder.id)\n\t\t\tthis.$store.dispatch(actions.COUNT_BOOKMARKS, this.folder.id)\n\t\t}, 2000)\n\t},\n\tmethods: {\n\t\tonDetails() {\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_DETAILS, this.folder.id)\n\t\t},\n\t\tonShare() {\n\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_SHARING, this.folder.id)\n\t\t},\n\t\tonDelete(hard) {\n\t\t\tif (hard && !confirm(t(\'bookmarks\', \'Do you really want to permanently delete this folder?\'))) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.dispatch(actions.DELETE_FOLDER, { id: this.folder.id, hard })\n\t\t},\n\t\tonUndelete() {\n\t\t\tthis.$store.dispatch(actions.UNDELETE_FOLDER, { id: this.folder.id })\n\t\t},\n\t\tonMove() {\n\t\t\tif (this.isTrashbin) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\tthis.$store.commit(mutations.ADD_SELECTION_FOLDER, this.folder)\n\t\t\tthis.$store.commit(mutations.DISPLAY_MOVE_DIALOG, true)\n\t\t},\n\t\tonSelect(e) {\n\t\t\tthis.$router.push({ name: this.routes.FOLDER, params: { folder: this.folder.id } })\n\t\t\tif (this.$store.state.sidebar && this.$store.state.sidebar.type === \'folder\') {\n\t\t\t\tthis.$store.dispatch(actions.OPEN_FOLDER_DETAILS, this.folder.id)\n\t\t\t}\n\t\t\te.preventDefault()\n\t\t},\n\t\tasync onRename() {\n\t\t\tthis.renaming = true\n\t\t},\n\t\tonRenameSubmit(title) {\n\t\t\t// eslint-disable-next-line vue/no-mutating-props\n\t\t\tthis.folder.title = title\n\t\t\tthis.$store.dispatch(actions.SAVE_FOLDER, this.folder.id)\n\t\t\tthis.renaming = false\n\t\t},\n\t\tclickSelect(e) {\n\t\t\tif (this.isTrashbin) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tif (!this.selected) {\n\t\t\t\tthis.$store.commit(mutations.ADD_SELECTION_FOLDER, this.folder)\n\t\t\t} else {\n\t\t\t\tthis.$store.commit(mutations.REMOVE_SELECTION_FOLDER, this.folder)\n\t\t\t}\n\t\t},\n\t\tallowDrop() {\n\t\t\treturn !this.isTrashbin && !this.$store.state.selection.folders.includes(this.folder) && (this.$store.state.selection.folders.length || this.$store.state.selection.bookmarks.length)\n\t\t},\n\t\tasync onDrop(e) {\n\t\t\te.preventDefault()\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.MOVE_SELECTION, this.folder.id)\n\t\t\t} finally {\n\t\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\t}\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.folder__icon {\n\tflex-grow: 0;\n\theight: 20px;\n\twidth: 20px;\n\tbackground-size: cover;\n\tmargin: 0 15px;\n\tcursor: pointer;\n}\n\n.folder__icon.shared {\n\ttransform: scale(0.4);\n\tposition: absolute;\n\ttop: 1px;\n\theight: auto;\n\twidth: auto;\n\tinset-inline-start: -1px;\n}\n\n.item--gridview .folder__icon {\n\tbackground-size: cover;\n\tposition: absolute;\n\ttop: 20%;\n\tinset-inline-start: calc(45% - 50px);\n\ttransform: scale(4);\n\ttransform-origin: top left;\n}\n\n.item--gridview .folder__icon.shared {\n\ttransform: translate(100%, 135%) scale(1.5);\n}\n\n.folder__title {\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\tmargin: 0;\n\tfont-size: 1em;\n\tfont-weight: normal;\n}\n\n.item--gridview .folder__title {\n\tmargin-inline-start: 15px;\n}\n\n.folder__tags {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n\n.item--gridview .folder__tags {\n\tposition: absolute;\n\tbottom: 47px;\n\tinset-inline-start: 10px;\n\tmargin: 0;\n}\n\n.folder__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-inline-end: 3px;\n\tbackground-color: var(--color-primary-element-light);\n}\n</style>\n'],sourceRoot:""}]);const a=s},77432(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.item {\n\tborder-bottom: 1px solid var(--color-border);\n\tbackground-position: center !important;\n\tbackground-size: cover !important;\n\tbackground-color: var(--color-main-background);\n\tposition: relative;\n}\n.item--gridview {\n\twidth: 250px;\n\theight: 200px;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius-large);\n}\n.item__clickLink,\n.item__rename {\n\tdisplay: flex;\n\talign-items: center;\n}\n.item__rename {\n\tpadding: 0 8px 0 0;\n}\n.item__icon {\n\tposition: relative;\n}\n.item--gridview .item__rating {\n\tposition: absolute;\n\ttop: 10px;\n\tinset-inline-end: 10px;\n\tbackground: var(--color-main-background);\n\tborder-radius: var(--border-radius-large);\n}\n.item__rating .material-design-icon {\n\tdisplay: inline-block;\n}\n.item--gridview .item__rating .material-design-icon {\n\tdisplay: flex;\n}\n.item--gridview .item__icon {\n\ttop: -155px;\n\tinset-inline-start: 110px;\n}\n.item--gridview  .item__rename {\n\tpadding: 0 8px 5px 10px;\n}\n.item--gridview .item__clickLink,\n.item--gridview  .item__rename {\n\tposition: absolute;\n\tbottom: 0;\n\tinset-inline: 0;\n\ttop: 0;\n\tdisplay: flex;\n\talign-items: flex-end;\n}\n.item.dropTarget--available {\n\tbackground: var(--color-primary-element-light);\n}\n.item.dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n.item.active,\n.item:hover,\n.item:focus {\n\tbackground: var(--color-background-dark);\n}\n.item.item--gridview.active {\n\tborder-color: var(--color-primary-element);\n}\n.item__checkbox {\n\tdisplay: inline-block;\n}\n.item__checkbox label {\n\tpadding: 7px;\n\tdisplay: inline-block;\n}\n.item__labels {\n\tdisplay: flex;\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmargin: 10px 0;\n}\n.item:not(.item--gridview) .item__rename input {\n\twidth: 100%;\n}\n.item--gridview .item__checkbox {\n\tposition: absolute;\n\ttop: -1px;\n\tinset-inline-start: -1px;\n\tbackground: white;\n\tborder-radius: var(--border-radius);\n\tbox-shadow: #aaa 0 0 3px inset;\n}\n.item__NcActions {\n\tflex: 0;\n\tmargin: 3px;\n}\n.item--gridview .tagline {\n\tposition: absolute;\n\tbottom: 47px;\n\tinset-inline: 10px;\n\tmargin: 0;\n}\n.item--gridview .item__checkbox input[type='checkbox'].checkbox + label::before {\n\tmargin: 0 3px 3px 3px;\n}\n\n","",{version:3,sources:["webpack://./src/components/Item.vue"],names:[],mappings:";AAsOA;CACA,4CAAA;CACA,sCAAA;CACA,iCAAA;CACA,8CAAA;CACA,kBAAA;AACA;AAEA;CACA,YAAA;CACA,aAAA;CACA,wCAAA;CACA,qCAAA;CACA,0CAAA;CACA,yCAAA;AACA;AAEA;;CAEA,aAAA;CACA,mBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,kBAAA;AACA;AAEA;CACA,kBAAA;CACA,SAAA;CACA,sBAAA;CACA,wCAAA;CACA,yCAAA;AACA;AAEA;CACA,qBAAA;AACA;AAEA;CACA,aAAA;AACA;AAEA;CACA,WAAA;CACA,yBAAA;AACA;AAEA;CACA,uBAAA;AACA;AAEA;;CAEA,kBAAA;CACA,SAAA;CACA,eAAA;CACA,MAAA;CACA,aAAA;CACA,qBAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;;;CAGA,wCAAA;AACA;AAEA;CACA,0CAAA;AACA;AAEA;CACA,qBAAA;AACA;AAEA;CACA,YAAA;CACA,qBAAA;AACA;AAEA;CACA,aAAA;CACA,OAAA;CACA,uBAAA;CACA,gBAAA;CACA,cAAA;AACA;AAEA;CACA,WAAA;AACA;AAEA;CACA,kBAAA;CACA,SAAA;CACA,wBAAA;CACA,iBAAA;CACA,mCAAA;CACA,8BAAA;AACA;AAEA;CACA,OAAA;CACA,WAAA;AACA;AAEA;CACA,kBAAA;CACA,YAAA;CACA,kBAAA;CACA,SAAA;AACA;AAEA;CACA,qBAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div v-drop-target="{allow: allowDrop, drop: (e) => $emit(\'drop\', e)}"\n\t\t:class="{\n\t\t\titem: true,\n\t\t\tactive,\n\t\t\t\'item--gridview\': viewMode === \'grid\'\n\t\t}"\n\t\t:style="{ background }"\n\t\t:draggable="draggable && !renaming"\n\t\t@dragstart="onDragStart">\n\t\t<template v-if="!renaming">\n\t\t\t<component :is="url? \'a\' : \'span\'"\n\t\t\t\t:href="url"\n\t\t\t\tclass="item__clickLink"\n\t\t\t\ttabindex="0"\n\t\t\t\ttarget="_blank"\n\t\t\t\t@click="onClick"\n\t\t\t\t@contextmenu="onRightClick">\n\t\t\t\t<div v-if="editable && selectable" ref="checkbox" class="item__checkbox">\n\t\t\t\t\t<input :checked="selected" class="checkbox" type="checkbox"><label v-tooltip="selectLabel"\n\t\t\t\t\t\t:aria-label="selectLabel"\n\t\t\t\t\t\t@click="$event.preventDefault(); $event.stopImmediatePropagation(); $emit(\'select\');" />\n\t\t\t\t</div>\n\t\t\t\t<div class="item__icon">\n\t\t\t\t\t<slot name="icon" />\n\t\t\t\t</div>\n\t\t\t\t<div class="item__labels">\n\t\t\t\t\t<slot name="title" />\n\t\t\t\t\t<slot name="tags">\n\t\t\t\t\t\t<TagLine :tags="tags" />\n\t\t\t\t\t</slot>\n\t\t\t\t</div>\n\t\t\t\t<div class="item__rating">\n\t\t\t\t\t<slot name="rating" />\n\t\t\t\t</div>\n\t\t\t\t<div v-if="editable && !selected"\n\t\t\t\t\tref="actions"\n\t\t\t\t\tclass="item__NcActions"\n\t\t\t\t\t@click="$event.preventDefault(); $event.stopPropagation()">\n\t\t\t\t\t<NcActions ref="actions">\n\t\t\t\t\t\t<slot name="actions" />\n\t\t\t\t\t</NcActions>\n\t\t\t\t</div>\n\t\t\t</component>\n\t\t</template>\n\t\t<div v-else class="item__rename">\n\t\t\t<slot name="icon" />\n\t\t\t<input ref="input"\n\t\t\t\tv-model="newTitle"\n\t\t\t\ttype="text"\n\t\t\t\t:placeholder="renamePlaceholder"\n\t\t\t\t@keyup.enter="onRenameSubmit">\n\t\t\t<NcActions>\n\t\t\t\t<NcActionButton @click="onRenameSubmit">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<CheckIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Submit\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t\t<NcActions>\n\t\t\t\t<NcActionButton @click="$emit(\'rename-cancel\')">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<CloseIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Cancel\') }}\n\t\t\t\t</NcActionButton>\n\t\t\t</NcActions>\n\t\t</div>\n\t</div>\n</template>\n<script>\nimport Vue from \'vue\'\nimport { NcActions, NcActionButton } from \'@nextcloud/vue\'\nimport TagLine from \'./TagLine.vue\'\nimport DragImage from \'./DragImage.vue\'\nimport { mutations } from \'../store/index.js\'\nimport { CheckIcon, CloseIcon } from \'./Icons.js\'\n\nexport default {\n\tname: \'Item\',\n\tcomponents: {\n\t\tNcActions,\n\t\tNcActionButton,\n\t\tTagLine,\n\t\tCheckIcon,\n\t\tCloseIcon,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\turl: {\n\t\t\ttype: String,\n\t\t\tdefault: undefined,\n\t\t},\n\t\tactive: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\teditable: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tselected: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tselectable: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tdraggable: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tallowDrop: {\n\t\t\ttype: Function,\n\t\t\tdefault: () => false,\n\t\t},\n\t\trenaming: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: false,\n\t\t},\n\t\tselectLabel: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\trenamePlaceholder: {\n\t\t\ttype: String,\n\t\t\trequired: true,\n\t\t},\n\t\tbackground: {\n\t\t\ttype: String,\n\t\t\tdefault: undefined,\n\t\t},\n\t\ttags: {\n\t\t\ttype: Array,\n\t\t\tdefault: undefined,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tnewTitle: this.title,\n\t\t}\n\t},\n\tcomputed: {\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t},\n\twatch: {\n\t\tasync renaming() {\n\t\t\tif (this.renaming) {\n\t\t\t\tawait Vue.nextTick()\n\t\t\t\tthis.$refs.input.focus()\n\t\t\t}\n\t\t},\n\t},\n\tmounted() {\n\t\tif (typeof this.$refs.input !== \'undefined\') {\n\t\t\tthis.$refs.input.focus()\n\t\t}\n\t},\n\tmethods: {\n\t\tasync onRenameSubmit(event) {\n\t\t\tthis.$emit(\'rename\', this.newTitle)\n\t\t},\n\t\tonClick(e) {\n\t\t\tif (this.$refs.actions === e.target\n\t\t\t\t\t|| (this.$refs.actions && this.$refs.actions.contains(e.target))\n\t\t\t\t\t|| (this.$refs.checkbox\n\t\t\t\t\t\t\t&& (this.$refs.checkbox.contains(e.target) || this.$refs.checkbox === e.target)\n\t\t\t\t\t)) {\n\t\t\t\te.stopImmediatePropagation()\n\t\t\t\treturn\n\t\t\t}\n\t\t\tthis.$emit(\'click\', e)\n\t\t},\n\t\tonRightClick(e) {\n\t\t\tif (this.$refs.actions) {\n\t\t\t\te.preventDefault()\n\t\t\t\tif (this.$refs.actions.openMenu) {\n\t\t\t\t\tthis.$refs.actions.openMenu()\n\t\t\t\t} else if (this.$refs.actions.querySelector) {\n\t\t\t\t\tthis.$refs.actions.querySelector(\'button\').click()\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\tasync onDragStart(e) {\n\t\t\tif (!this.draggable || this.renaming) {\n\t\t\t\treturn\n\t\t\t}\n\t\t\tif (!this.selected) {\n\t\t\t\tif (this.$store.state.selection.bookmarks.length || this.$store.state.selection.folders.length) {\n\t\t\t\t\t// If something is already selected not including the current element, reset selection\n\t\t\t\t\tthis.$store.commit(mutations.RESET_SELECTION)\n\t\t\t\t}\n\t\t\t\t// Select the current item\n\t\t\t\tthis.$emit(\'select\')\n\t\t\t\tawait this.$nextTick()\n\t\t\t}\n\t\t\t// Build the drag image\n\t\t\tconst element = document.createElement(\'div\')\n\t\t\tconst placeholder = element.appendChild(document.createElement(\'div\'))\n\t\t\tdocument.body.appendChild(element)\n\t\t\tconst vueInstance = new Vue({ el: placeholder, store: this.$store, render: (h) => h(DragImage) })\n\t\t\tawait vueInstance.$nextTick()\n\n\t\t\t// set drag data and drag image\n\t\t\te.dataTransfer.clearData()\n\t\t\te.dataTransfer.setData(\'text/plain\', JSON.stringify(this.$store.state.selection))\n\t\t\te.dataTransfer.setDragImage(element, 0, 0)\n\n\t\t\t// dispose of drag image element, as the browser only takes a visual snapshot once\n\t\t\tawait new Promise(resolve => setTimeout(resolve, 0))\n\t\t\tdocument.body.removeChild(element)\n\t\t},\n\t},\n}\n<\/script>\n<style>\n\n.item {\n\tborder-bottom: 1px solid var(--color-border);\n\tbackground-position: center !important;\n\tbackground-size: cover !important;\n\tbackground-color: var(--color-main-background);\n\tposition: relative;\n}\n\n.item--gridview {\n\twidth: 250px;\n\theight: 200px;\n\tbackground: var(--color-main-background);\n\tborder: 1px solid var(--color-border);\n\tbox-shadow: #efefef7d 0px 0 13px 0px inset;\n\tborder-radius: var(--border-radius-large);\n}\n\n.item__clickLink,\n.item__rename {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.item__rename {\n\tpadding: 0 8px 0 0;\n}\n\n.item__icon {\n\tposition: relative;\n}\n\n.item--gridview .item__rating {\n\tposition: absolute;\n\ttop: 10px;\n\tinset-inline-end: 10px;\n\tbackground: var(--color-main-background);\n\tborder-radius: var(--border-radius-large);\n}\n\n.item__rating .material-design-icon {\n\tdisplay: inline-block;\n}\n\n.item--gridview .item__rating .material-design-icon {\n\tdisplay: flex;\n}\n\n.item--gridview .item__icon {\n\ttop: -155px;\n\tinset-inline-start: 110px;\n}\n\n.item--gridview  .item__rename {\n\tpadding: 0 8px 5px 10px;\n}\n\n.item--gridview .item__clickLink,\n.item--gridview  .item__rename {\n\tposition: absolute;\n\tbottom: 0;\n\tinset-inline: 0;\n\ttop: 0;\n\tdisplay: flex;\n\talign-items: flex-end;\n}\n\n.item.dropTarget--available {\n\tbackground: var(--color-primary-element-light);\n}\n\n.item.dropTarget--active {\n\tbackground: var(--color-primary-element-light);\n}\n\n.item.active,\n.item:hover,\n.item:focus {\n\tbackground: var(--color-background-dark);\n}\n\n.item.item--gridview.active {\n\tborder-color: var(--color-primary-element);\n}\n\n.item__checkbox {\n\tdisplay: inline-block;\n}\n\n.item__checkbox label {\n\tpadding: 7px;\n\tdisplay: inline-block;\n}\n\n.item__labels {\n\tdisplay: flex;\n\tflex: 1;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tmargin: 10px 0;\n}\n\n.item:not(.item--gridview) .item__rename input {\n\twidth: 100%;\n}\n\n.item--gridview .item__checkbox {\n\tposition: absolute;\n\ttop: -1px;\n\tinset-inline-start: -1px;\n\tbackground: white;\n\tborder-radius: var(--border-radius);\n\tbox-shadow: #aaa 0 0 3px inset;\n}\n\n.item__NcActions {\n\tflex: 0;\n\tmargin: 3px;\n}\n\n.item--gridview .tagline {\n\tposition: absolute;\n\tbottom: 47px;\n\tinset-inline: 10px;\n\tmargin: 0;\n}\n\n.item--gridview .item__checkbox input[type=\'checkbox\'].checkbox + label::before {\n\tmargin: 0 3px 3px 3px;\n}\n\n</style>\n'],sourceRoot:""}]);const a=s},10501(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.bookmarkslist__emptyBookmarks[data-v-499e70ee] {\n\twidth: 500px;\n\tmargin: 0 auto;\n\tmargin-top: 100px;\n}\n.import[data-v-499e70ee] {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tinset-inline-start: -1000px;\n}\nbutton[data-v-499e70ee] {\n\tmargin-bottom: 15px;\n}\n.empty-content[data-v-499e70ee] {\n\tdisplay: flex;\n\theight: 100%;\n}\n","",{version:3,sources:["webpack://./src/components/NoBookmarks.vue"],names:[],mappings:";AAgIA;CACA,YAAA;CACA,cAAA;CACA,iBAAA;AACA;AAEA;CACA,UAAA;CACA,kBAAA;CACA,MAAA;CACA,2BAAA;AACA;AAEA;CACA,mBAAA;AACA;AAEA;CACA,aAAA;CACA,YAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class="bookmarkslist__emptyBookmarks">\n\t\t<NcEmptyContent v-if="$route.name === routes.ARCHIVED"\n\t\t\t:name="t(\'bookmarks\', \'No bookmarked files\')"\n\t\t\t:description="t(\'bookmarks\', \'Bookmarks to files like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline.\')">\n\t\t\t<template #icon>\n\t\t\t\t<FileDocumentMultipleIcon :size="20" />\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else-if="$route.name === routes.SEARCH"\n\t\t\t:name="t(\'bookmarks\', \'Nothing found\')"\n\t\t\t:description="t(\'bookmarks\', \'Your search yielded no results in the current folder.\')">\n\t\t\t<template #icon>\n\t\t\t\t<StarShootingIcon />\n\t\t\t</template>\n\t\t\t<template v-if="Number($route.params.folder) !== -1" #action>\n\t\t\t\t<NcButton @click="onSearchGlobally">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<MagnifyIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Repeat search in all folders\') }}\n\t\t\t\t</NcButton>\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else-if="$route.name === routes.UNAVAILABLE"\n\t\t\t:name="t(\'bookmarks\', \'No broken links\')"\n\t\t\t:description="t(\'bookmarks\', \'Bookmarked links are checked regularly and the ones that cannot be reached are listed here.\')">\n\t\t\t<template #icon>\n\t\t\t\t<LinkVariantOffIcon :size="20" />\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else-if="$route.name === routes.SHARED_FOLDERS"\n\t\t\t:name="t(\'bookmarks\', \'No shared folders\')"\n\t\t\t:description="t(\'bookmarks\', \'You can share bookmark folders with others. All folders shared with you are listed here.\')">\n\t\t\t<template #icon>\n\t\t\t\t<ShareVariantIcon :size="20" />\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else-if="$route.name === routes.DUPLICATED"\n\t\t\t:name="t(\'bookmarks\', \'No duplicated bookmarks\')"\n\t\t\t:description="t(\'bookmarks\', \'One bookmark can be in multiple folders at once. Updating it will update all copies. All duplicated bookmarks are listed here for convenience.\')">\n\t\t\t<template #icon>\n\t\t\t\t<VectorLinkIcon :size="20" />\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else-if="$route.name === routes.TRASHBIN"\n\t\t\t:name="t(\'bookmarks\', \'No deleted bookmarks\')"\n\t\t\t:description="t(\'bookmarks\', \'You haven\\\'t deleted anything yet.\')">\n\t\t\t<template #icon>\n\t\t\t\t<TrashbinIcon :size="20" />\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t\t<NcEmptyContent v-else\n\t\t\t:name="t(\'bookmarks\', \'No bookmarks here\')"\n\t\t\t:description="t(\'bookmarks\', \'Add bookmarks manually or import bookmarks from a HTML file.\')">\n\t\t\t<template #icon>\n\t\t\t\t<StarShootingIcon :size="20" />\n\t\t\t</template>\n\t\t\t<template v-if="!isPublic" #action>\n\t\t\t\t<input ref="import"\n\t\t\t\t\ttype="file"\n\t\t\t\t\tclass="import"\n\t\t\t\t\tsize="5"\n\t\t\t\t\t@change="onImportSubmit">\n\t\t\t\t<NcButton @click="onCreateOpen">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<PlusIcon :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Add a bookmark\') }}\n\t\t\t\t</NcButton>\n\t\t\t\t<NcButton @click="onImportOpen">\n\t\t\t\t\t<template #icon>\n\t\t\t\t\t\t<UploadIcon v-if="!importing" :size="20" />\n\t\t\t\t\t\t<NcLoadingIcon v-else :size="20" />\n\t\t\t\t\t</template>\n\t\t\t\t\t{{ t(\'bookmarks\', \'Import bookmarks\') }}\n\t\t\t\t</NcButton>\n\t\t\t</template>\n\t\t</NcEmptyContent>\n\t</div>\n</template>\n\n<script>\nimport { NcEmptyContent, NcButton, NcLoadingIcon } from \'@nextcloud/vue\'\nimport { actions, mutations } from \'../store/index.js\'\nimport { privateRoutes } from \'../router.js\'\nimport { TrashbinIcon, StarShootingIcon, UploadIcon, PlusIcon, ShareVariantIcon, VectorLinkIcon, LinkVariantOffIcon, FileDocumentMultipleIcon, MagnifyIcon } from \'./Icons.js\'\n\nexport default {\n\tname: \'NoBookmarks\',\n\tcomponents: { TrashbinIcon, NcEmptyContent, StarShootingIcon, NcButton, NcLoadingIcon, UploadIcon, PlusIcon, ShareVariantIcon, VectorLinkIcon, LinkVariantOffIcon, FileDocumentMultipleIcon, MagnifyIcon },\n\tdata() {\n\t\treturn { importing: false }\n\t},\n\tcomputed: {\n\t\troutes() {\n\t\t\treturn privateRoutes\n\t\t},\n\t},\n\tmethods: {\n\t\tonCreateOpen() {\n\t\t\tthis.$store.commit(mutations.DISPLAY_NEW_BOOKMARK, true)\n\t\t},\n\t\tonImportOpen() {\n\t\t\tthis.$refs.import.click()\n\t\t},\n\t\tasync onImportSubmit(e) {\n\t\t\tthis.importing = true\n\t\t\ttry {\n\t\t\t\tawait this.$store.dispatch(actions.IMPORT_BOOKMARKS, { file: e.target.files[0], folder: this.$route.params.folder || -1 })\n\t\t\t} catch (e) {\n\t\t\t\tconsole.warn(e)\n\t\t\t}\n\t\t\tthis.importing = false\n\t\t},\n\t\tonSearchGlobally() {\n\t\t\tthis.$router.push({ name: this.routes.SEARCH, params: { search: this.$route.params.search, folder: \'-1\' } })\n\t\t},\n\t},\n}\n<\/script>\n<style scoped>\n.bookmarkslist__emptyBookmarks {\n\twidth: 500px;\n\tmargin: 0 auto;\n\tmargin-top: 100px;\n}\n\n.import {\n\topacity: 0;\n\tposition: absolute;\n\ttop: 0;\n\tinset-inline-start: -1000px;\n}\n\nbutton {\n\tmargin-bottom: 15px;\n}\n\n.empty-content {\n\tdisplay: flex;\n\theight: 100%;\n}\n</style>\n'],sourceRoot:""}]);const a=s},97969(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.tagline {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n.tagline__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-inline-end: 3px;\n\tbackground-color: var(--color-main-background);\n\tcursor: pointer;\n}\n.tagline__tag:hover,\n.tagline__tag:focus {\n\tbackground-color: var(--color-background-dark);\n}\n","",{version:3,sources:["webpack://./src/components/TagLine.vue"],names:[],mappings:";AAiDA;CACA,eAAA;CACA,YAAA;CACA,cAAA;CACA,gBAAA;CACA,qBAAA;CACA,cAAA;AACA;AAEA;CACA,qBAAA;CACA,qCAAA;CACA,wCAAA;CACA,iBAAA;CACA,sBAAA;CACA,8CAAA;CACA,eAAA;AACA;AAEA;;CAEA,8CAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020-2024. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<div class="tagline">\n\t\t<div v-for="tag in tags"\n\t\t\t:key="tag"\n\t\t\tclass="tagline__tag"\n\t\t\trole="button"\n\t\t\t@click="clickTag($event, tag)">\n\t\t\t{{ tag }}\n\t\t</div>\n\t</div>\n</template>\n<script>\nimport { privateRoutes, publicRoutes } from \'../router.js\'\n\nexport default {\n\tname: \'TagLine\',\n\tcomponents: {},\n\tprops: {\n\t\ttags: {\n\t\t\ttype: Array,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {}\n\t},\n\tcomputed: {\n\t\troutes() {\n\t\t\treturn this.$store.state.public ? publicRoutes : privateRoutes\n\t\t},\n\t},\n\tcreated() {},\n\tmethods: {\n\t\tclickTag(e, tag) {\n\t\t\te.preventDefault()\n\t\t\te.stopImmediatePropagation()\n\t\t\te.stopPropagation()\n\t\t\tthis.$router.push({ name: this.routes.TAGS, params: { tags: tag } })\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.tagline {\n\tfont-size: 12px;\n\theight: 24px;\n\tline-height: 1;\n\toverflow: hidden;\n\tdisplay: inline-block;\n\tmargin: 0 15px;\n}\n\n.tagline__tag {\n\tdisplay: inline-block;\n\tborder: 1px solid var(--color-border);\n\tborder-radius: var(--border-radius-pill);\n\tpadding: 5px 10px;\n\tmargin-inline-end: 3px;\n\tbackground-color: var(--color-main-background);\n\tcursor: pointer;\n}\n\n.tagline__tag:hover,\n.tagline__tag:focus {\n\tbackground-color: var(--color-background-dark);\n}\n</style>\n'],sourceRoot:""}]);const a=s},49864(t,e,n){"use strict";n.d(e,{A:()=>a});var o=n(71354),r=n.n(o),i=n(76314),s=n.n(i)()(r());s.push([t.id,"\n.virtual-scroll[data-v-402a41e6] {\n\theight: calc(100vh - 50px - 50px - 10px);\n\tposition: relative;\n\toverflow-y: scroll;\n}\n.bookmarkslist--with-description .virtual-scroll[data-v-402a41e6] {\n\theight: calc(100vh - 50px - 50px - 130px);\n}\n.bookmarkslist--gridview .container-window[data-v-402a41e6] {\n\tdisplay: flex;\n\tflex-direction: row;\n\tflex-wrap: wrap;\n\talign-content: start;\n\tgap: 10px;\n\tpadding: 0 10px;\n\tpadding-top: 10px;\n}\n","",{version:3,sources:["webpack://./src/components/VirtualScroll.vue"],names:[],mappings:";AA0LA;CACA,wCAAA;CACA,kBAAA;CACA,kBAAA;AACA;AAEA;CACA,yCAAA;AACA;AAEA;CACA,aAAA;CACA,mBAAA;CACA,eAAA;CACA,oBAAA;CACA,SAAA;CACA,eAAA;CACA,iBAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2022. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n<script>\nconst GRID_ITEM_HEIGHT = 198 + 2 + 10\nconst GRID_ITEM_WIDTH = 248 + 2 + 10\nconst LIST_ITEM_HEIGHT = 45 + 1\n\nexport default {\n\tname: 'VirtualScroll',\n\tprops: {\n\t\treachedEnd: {\n\t\t\ttype: Boolean,\n\t\t\trequired: true,\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tviewport: { width: 0, height: 0 },\n\t\t\titemHeight: 0,\n\t\t\titemWidth: 0,\n\t\t\tstartIndex: 0,\n\t\t\tvisibleItems: 80,\n\t\t\tscrollTop: 0,\n\t\t\tscrollHeight: 500,\n\t\t\tinitialLoadingSkeleton: false,\n\t\t\tinitialLoadingTimeout: null,\n\t\t\ttimeout: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\tviewMode() {\n\t\t\treturn this.$store.state.viewMode\n\t\t},\n\t\tnewBookmark() {\n\t\t\treturn this.$store.state.displayNewBookmark\n\t\t},\n\t\tnewFolder() {\n\t\t\treturn this.$store.state.displayNewFolder\n\t\t},\n\t\tfetching() {\n\t\t\treturn this.$store.state.loading.bookmarks\n\t\t},\n\t\tsidebar() {\n\t\t\treturn this.$store.state.sidebar\n\t\t},\n\t},\n\twatch: {\n\t\tnewBookmark() {\n\t\t\tthis.$el.scrollTop = 0\n\t\t},\n\t\tnewFolder() {\n\t\t\tthis.$el.scrollTop = 0\n\t\t},\n\t\tviewMode() {\n\t\t\tthis.onViewModeChange()\n\t\t},\n\t\titemHeight() {\n\t\t\tthis.recalculateVisibleItems()\n\t\t},\n\t\titemWidth() {\n\t\t\tthis.recalculateVisibleItems()\n\t\t},\n\t\tsidebar() {\n\t\t\tthis.$nextTick(() => {\n\t\t\t\tthis.onScroll()\n\t\t\t})\n\t\t},\n\t},\n\tmounted() {\n\t\tthis.$nextTick(() => {\n\t\t\tthis.onViewModeChange()\n\t\t\tthis.onScroll()\n\t\t})\n\t\twindow.addEventListener('resize', this.onScroll)\n\t},\n\tdestroyed() {\n\t\twindow.removeEventListener('resize', this.onScroll)\n\t},\n\tmethods: {\n\t\tonViewModeChange() {\n\t\t\tthis.viewport.width = this.$el.clientWidth\n\t\t\tthis.viewport.height = this.$el.clientHeight\n\t\t\tif (this.viewMode === 'grid') {\n\t\t\t\tthis.itemHeight = GRID_ITEM_HEIGHT\n\t\t\t\tthis.itemWidth = GRID_ITEM_WIDTH\n\t\t\t} else {\n\t\t\t\tthis.itemHeight = LIST_ITEM_HEIGHT\n\t\t\t\tthis.itemWidth = this.viewport.width\n\t\t\t}\n\t\t},\n\t\trecalculateVisibleItems() {\n\t\t\tthis.visibleItems\n\t\t\t\t= (Math.ceil(this.viewport.height / this.itemHeight) + 2)\n\t\t\t\t* Math.floor(this.viewport.width / this.itemWidth)\n\t\t},\n\t\tonScroll() {\n\t\t\tthis.viewport.width = this.$el.clientWidth\n\t\t\tthis.viewport.height = this.$el.clientHeight\n\t\t\tconst scrollTop = this.$el.scrollTop\n\t\t\tthis.startIndex\n\t\t\t\t= Math.floor(scrollTop / this.itemHeight)\n\t\t\t\t* Math.floor(this.viewport.width / this.itemWidth)\n\t\t\tconst childComponents = this.$slots.default.filter(\n\t\t\t\t(child) => !!child.componentOptions,\n\t\t\t)\n\t\t\tif (\n\t\t\t\tscrollTop + this.viewport.height\n\t\t\t\t>= Math.ceil(childComponents.length / this.itemWidth)\n\t\t\t\t\t* this.itemHeight\n\t\t\t\t\t- 100\n\t\t\t) {\n\t\t\t\tif (!this.fetching) {\n\t\t\t\t\tthis.$emit('load-more')\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t},\n\trender(h) {\n\t\tif (!this.$slots.default || !this.$el) {\n\t\t\treturn h('div', {\n\t\t\t\tclass: 'virtual-scroll',\n\t\t\t})\n\t\t}\n\n\t\tconst childComponents = this.$slots.default.filter(\n\t\t\t(child) => !!child.componentOptions,\n\t\t)\n\n\t\tconst endIndex = Math.min(\n\t\t\tthis.startIndex + this.visibleItems,\n\t\t\tchildComponents.length,\n\t\t)\n\t\tconst visibleData = Array.from(\n\t\t\t{ length: endIndex - this.startIndex },\n\t\t\t(_, i) => this.startIndex + i,\n\t\t)\n\t\tconst itemsPerRow = Math.floor(this.viewport.width / this.itemWidth)\n\t\treturn h(\n\t\t\t'div',\n\t\t\t{\n\t\t\t\tclass: 'virtual-scroll',\n\t\t\t\ton: { scroll: () => this.onScroll() },\n\t\t\t},\n\t\t\t[\n\t\t\t\th(\n\t\t\t\t\t'div',\n\t\t\t\t\t{\n\t\t\t\t\t\tclass: 'container-window',\n\t\t\t\t\t\tstyle: {\n\t\t\t\t\t\t\theight: `${\n\t\t\t\t\t\t\t\tMath.ceil(\n\t\t\t\t\t\t\t\t\tchildComponents.length / itemsPerRow,\n\t\t\t\t\t\t\t\t) * this.itemHeight\n\t\t\t\t\t\t\t}px`,\n\t\t\t\t\t\t\tposition: 'relative',\n\t\t\t\t\t\t},\n\t\t\t\t\t},\n\t\t\t\t\tvisibleData.map((index) => {\n\t\t\t\t\t\tconst x = Math.floor(index / itemsPerRow)\n\t\t\t\t\t\tconst y = index - x * itemsPerRow\n\t\t\t\t\t\treturn h(\n\t\t\t\t\t\t\t'div',\n\t\t\t\t\t\t\t{\n\t\t\t\t\t\t\t\tkey: index,\n\t\t\t\t\t\t\t\tstyle: {\n\t\t\t\t\t\t\t\t\tposition: 'absolute',\n\t\t\t\t\t\t\t\t\ttop: `${x * this.itemHeight}px`,\n\t\t\t\t\t\t\t\t\tleft: `${y * this.itemWidth + (itemsPerRow === 1 ? 0 : 10)}px`,\n\t\t\t\t\t\t\t\t\theight: `${this.itemHeight}px`,\n\t\t\t\t\t\t\t\t\twidth: `${this.itemWidth}px`,\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t[childComponents[index]],\n\t\t\t\t\t\t)\n\t\t\t\t\t}),\n\t\t\t\t),\n\t\t\t],\n\t\t)\n\t},\n}\n<\/script>\n\n<style scoped>\n.virtual-scroll {\n\theight: calc(100vh - 50px - 50px - 10px);\n\tposition: relative;\n\toverflow-y: scroll;\n}\n\n.bookmarkslist--with-description .virtual-scroll {\n\theight: calc(100vh - 50px - 50px - 130px);\n}\n\n.bookmarkslist--gridview .container-window {\n\tdisplay: flex;\n\tflex-direction: row;\n\tflex-wrap: wrap;\n\talign-content: start;\n\tgap: 10px;\n\tpadding: 0 10px;\n\tpadding-top: 10px;\n}\n</style>\n"],sourceRoot:""}]);const a=s},15505(t,e,n){"use strict";n.d(e,{A:()=>y});var o=n(96192),r=n(74728),i=n.n(r),s=n(63814),a=n(11574);const l={name:"BookmarkContent",components:{NcEmptyContent:a.yI,DownloadIcon:o.s3},computed:{isActive(){return!!this.$store.state.sidebar&&"bookmark"===this.$store.state.sidebar.type},isWebLink(){return this.bookmark.url.startsWith("http")},scrapingEnabled(){return"true"===this.$store.state.settings["privacy.enableScraping"]},archiveEnabled(){return this.$store.state.settings["archive.enabled"]},bookmark(){if(this.isActive)return this.$store.getters.getBookmark(this.$store.state.sidebar.id)},hasMinLength(){return!this.bookmark.textContent||this.bookmark.textContent.length>=350},content(){return i()(this.bookmark.htmlContent,{allowProtocolRelative:!1})},archivedFileUrl(){const t=this.bookmark.archivedFilePath.split("/").slice(3).join("/");return(0,s.dC)(`webdav/${t}`)},archivedFile(){return this.bookmark.archivedFile?(0,s.Jv)(`/apps/files/?fileid=${this.bookmark.archivedFile}`):null}}};var c=n(85072),d=n.n(c),m=n(97825),A=n.n(m),h=n(77659),u=n.n(h),p=n(55056),k=n.n(p),f=n(10540),b=n.n(f),g=n(41113),C=n.n(g),v=n(21008),_={};_.styleTagTransform=C(),_.setAttributes=k(),_.insert=u().bind(null,"head"),_.domAPI=A(),_.insertStyleElement=b();d()(v.A,_);v.A&&v.A.locals&&v.A.locals;const y=(0,n(14486).A)(l,function(){var t=this,e=t._self._c;return t.isActive&&t.scrapingEnabled&&t.archiveEnabled&&t.hasMinLength&&!t.archivedFile&&t.isWebLink?e("div",{staticClass:"bookmark-content"},[t.bookmark.textContent?e("div",{staticClass:"content",domProps:{innerHTML:t._s(t.content)}}):e("div",[e("NcEmptyContent",{attrs:{name:t.t("bookmarks","Content pending"),description:t.t("bookmarks","This content is being downloaded for offline use. Please check back later.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DownloadIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2598526839)})],1)]):t._e()},[],!1,null,null,null).exports},72635(e,n,o){"use strict";o.d(n,{A:()=>pt});var r=o(11574),i=o(85471),s=o(39912);const a={name:"TagLine",components:{},props:{tags:{type:Array,required:!0}},data:()=>({}),computed:{routes(){return this.$store.state.public?s.qv:s.YO}},created(){},methods:{clickTag(t,e){t.preventDefault(),t.stopImmediatePropagation(),t.stopPropagation(),this.$router.push({name:this.routes.TAGS,params:{tags:e}})}}};var l=o(85072),c=o.n(l),d=o(97825),m=o.n(d),A=o(77659),h=o.n(A),u=o(55056),p=o.n(u),k=o(10540),f=o.n(k),b=o(41113),g=o.n(b),C=o(97969),v={};v.styleTagTransform=g(),v.setAttributes=p(),v.insert=h().bind(null,"head"),v.domAPI=m(),v.insertStyleElement=f();c()(C.A,v);C.A&&C.A.locals&&C.A.locals;var _=o(14486);const y=(0,_.A)(a,function(){var t=this,e=t._self._c;return e("div",{staticClass:"tagline"},t._l(t.tags,function(n){return e("div",{key:n,staticClass:"tagline__tag",attrs:{role:"button"},on:{click:function(e){return t.clickTag(e,n)}}},[t._v("\n\t\t"+t._s(n)+"\n\t")])}),0)},[],!1,null,null,null).exports;var I=o(96192);const x={name:"DragImage",components:{FolderIcon:I.sj,EarthIcon:I.OV},computed:{selectionDescription(){return 0!==this.$store.state.selection.bookmarks.length&&0!==this.$store.state.selection.folders.length?this.t("bookmarks","{folders} folders and {bookmarks} bookmarks",{folders:this.$store.state.selection.folders.length,bookmarks:this.$store.state.selection.bookmarks.length}):0!==this.$store.state.selection.bookmarks.length?1===this.$store.state.selection.bookmarks.length?this.$store.state.selection.bookmarks[0].title:this.n("bookmarks","%n bookmark","%n bookmarks",this.$store.state.selection.bookmarks.length):0!==this.$store.state.selection.folders.length?1===this.$store.state.selection.folders.length?this.$store.state.selection.folders[0].title:this.n("bookmarks","%n folder","%n folders",this.$store.state.selection.folders.length):""}}};var S=o(81946),w={};w.styleTagTransform=g(),w.setAttributes=p(),w.insert=h().bind(null,"head"),w.domAPI=m(),w.insertStyleElement=f();c()(S.A,w);S.A&&S.A.locals&&S.A.locals;const E=(0,_.A)(x,function(){var t=this,e=t._self._c;return e("div",{staticClass:"dragImage"},[t.$store.state.selection.folders.length?e("FolderIcon",{attrs:{size:20,"fill-color":t.colorPrimaryElement}}):e("EarthIcon",{attrs:{size:20,"fill-color":t.colorPrimaryElement}}),e("span",{staticClass:"description"},[t._v(t._s(t.selectionDescription))])],1)},[],!1,null,"362d49f6",null).exports;var $=o(2326);const N={name:"Item",components:{NcActions:r.B6,NcActionButton:r.Ko,TagLine:y,CheckIcon:I.Sr,CloseIcon:I.US},props:{title:{type:String,required:!0},url:{type:String,default:void 0},active:{type:Boolean,default:!1},editable:{type:Boolean,default:!1},selected:{type:Boolean,default:!1},selectable:{type:Boolean,default:!1},draggable:{type:Boolean,default:!1},allowDrop:{type:Function,default:()=>!1},renaming:{type:Boolean,default:!1},selectLabel:{type:String,required:!0},renamePlaceholder:{type:String,required:!0},background:{type:String,default:void 0},tags:{type:Array,default:void 0}},data(){return{newTitle:this.title}},computed:{viewMode(){return this.$store.state.viewMode}},watch:{async renaming(){this.renaming&&(await i.Ay.nextTick(),this.$refs.input.focus())}},mounted(){void 0!==this.$refs.input&&this.$refs.input.focus()},methods:{async onRenameSubmit(t){this.$emit("rename",this.newTitle)},onClick(t){this.$refs.actions===t.target||this.$refs.actions&&this.$refs.actions.contains(t.target)||this.$refs.checkbox&&(this.$refs.checkbox.contains(t.target)||this.$refs.checkbox===t.target)?t.stopImmediatePropagation():this.$emit("click",t)},onRightClick(t){this.$refs.actions&&(t.preventDefault(),this.$refs.actions.openMenu?this.$refs.actions.openMenu():this.$refs.actions.querySelector&&this.$refs.actions.querySelector("button").click())},async onDragStart(t){if(!this.draggable||this.renaming)return;this.selected||((this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length)&&this.$store.commit($.z4.RESET_SELECTION),this.$emit("select"),await this.$nextTick());const e=document.createElement("div"),n=e.appendChild(document.createElement("div"));document.body.appendChild(e);const o=new i.Ay({el:n,store:this.$store,render:t=>t(E)});await o.$nextTick(),t.dataTransfer.clearData(),t.dataTransfer.setData("text/plain",JSON.stringify(this.$store.state.selection)),t.dataTransfer.setDragImage(e,0,0),await new Promise(t=>setTimeout(t,0)),document.body.removeChild(e)}}};var B=o(77432),T={};T.styleTagTransform=g(),T.setAttributes=p(),T.insert=h().bind(null,"head"),T.domAPI=m(),T.insertStyleElement=f();c()(B.A,T);B.A&&B.A.locals&&B.A.locals;var O=(0,_.A)(N,function(){var t=this,e=t._self._c;return e("div",{directives:[{name:"drop-target",rawName:"v-drop-target",value:{allow:t.allowDrop,drop:e=>t.$emit("drop",e)},expression:"{allow: allowDrop, drop: (e) => $emit('drop', e)}"}],class:{item:!0,active:t.active,"item--gridview":"grid"===t.viewMode},style:{background:t.background},attrs:{draggable:t.draggable&&!t.renaming},on:{dragstart:t.onDragStart}},[t.renaming?e("div",{staticClass:"item__rename"},[t._t("icon"),t._v(" "),e("input",{directives:[{name:"model",rawName:"v-model",value:t.newTitle,expression:"newTitle"}],ref:"input",attrs:{type:"text",placeholder:t.renamePlaceholder},domProps:{value:t.newTitle},on:{keyup:function(e){return!e.type.indexOf("key")&&t._k(e.keyCode,"enter",13,e.key,"Enter")?null:t.onRenameSubmit.apply(null,arguments)},input:function(e){e.target.composing||(t.newTitle=e.target.value)}}}),t._v(" "),e("NcActions",[e("NcActionButton",{on:{click:t.onRenameSubmit},scopedSlots:t._u([{key:"icon",fn:function(){return[e("CheckIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Submit"))+"\n\t\t\t")])],1),t._v(" "),e("NcActions",[e("NcActionButton",{on:{click:function(e){return t.$emit("rename-cancel")}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("CloseIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Cancel"))+"\n\t\t\t")])],1)],2):[e(t.url?"a":"span",{tag:"component",staticClass:"item__clickLink",attrs:{href:t.url,tabindex:"0",target:"_blank"},on:{click:t.onClick,contextmenu:t.onRightClick}},[t.editable&&t.selectable?e("div",{ref:"checkbox",staticClass:"item__checkbox"},[e("input",{staticClass:"checkbox",attrs:{type:"checkbox"},domProps:{checked:t.selected}}),e("label",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.selectLabel,expression:"selectLabel"}],attrs:{"aria-label":t.selectLabel},on:{click:function(e){e.preventDefault(),e.stopImmediatePropagation(),t.$emit("select")}}})]):t._e(),t._v(" "),e("div",{staticClass:"item__icon"},[t._t("icon")],2),t._v(" "),e("div",{staticClass:"item__labels"},[t._t("title"),t._v(" "),t._t("tags",function(){return[e("TagLine",{attrs:{tags:t.tags}})]})],2),t._v(" "),e("div",{staticClass:"item__rating"},[t._t("rating")],2),t._v(" "),t.editable&&!t.selected?e("div",{ref:"actions",staticClass:"item__NcActions",on:{click:function(t){t.preventDefault(),t.stopPropagation()}}},[e("NcActions",{ref:"actions"},[t._t("actions")],2)],1):t._e()])]],2)},[],!1,null,null,null);const D=O.exports;var R=o(21777),F=o(63814),L=o(66802);const M={name:"Bookmark",components:{Item:D,NcActionButton:r.Ko,NcActionCheckbox:r.RI,FolderPlusIcon:I.YP,FolderMoveIcon:I.P1,FolderIcon:I.sj,ContentCopyIcon:I.c8,PencilIcon:I.R2,InformationVariantIcon:I.fM,DeleteIcon:I.d7,DeleteForeverIcon:I.M9,UndeleteIcon:I.In,StarIcon:I.Gg,NcPopover:r.rI,Hotness:I.vu,HotnessZero:I.z3},props:{bookmark:{type:Object,required:!0}},data(){return{title:this.bookmark.title,renaming:!1,backgroundImage:void 0,iconImage:void 0,iconLoaded:!1,popoverShown:!1}},computed:{apiUrl(){return this.isPublic?(0,F.Jv)("/apps/bookmarks/public/rest/v2"):(0,F.Jv)("/apps/bookmarks")},iconUrl(){return this.apiUrl+"/bookmark/"+this.bookmark.id+"/favicon"+(this.$store.state.public?"?token="+this.$store.state.authToken:"")},imageUrl(){return this.apiUrl+"/bookmark/"+this.bookmark.id+"/image"+(this.$store.state.public?"?token="+this.$store.state.authToken:"")},url(){return this.bookmark.url},displayTitle(){return this.bookmark.title||this.bookmark.url},isOpen(){return!(!this.$store.state.sidebar||"bookmark"!==this.$store.state.sidebar.type)&&this.$store.state.sidebar.id===this.bookmark.id},viewMode(){return this.$store.state.viewMode},isOwner(){const t=(0,R.HW)();return t&&this.bookmark.userId===t.uid},permissions(){return this.$store.getters.getPermissionsForBookmark(this.bookmark.id)},isDraggable(){return this.isEditable&&!this.isTrashbin},isEditable(){return this.isOwner||!this.isOwner&&this.permissions.canWrite},selectedBookmarks(){return this.$store.state.selection.bookmarks},selectable(){return Boolean((this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length)&&!this.isTrashbin)},selected(){return this.selectedBookmarks.map(t=>t.id).includes(this.bookmark.id)},isActive(){return this.isOpen||this.selected},background(){return"grid"===this.viewMode?this.backgroundImage:void 0},folder(){return this.$store.getters.getFolder(this.$store.state.fetchState.query.folder)[0]},isTrashbin(){return this.folder&&this.folder.softDeleted||this.$route.name===this.routes.TRASHBIN},hotness(){const t=this.$store.state.allClicksCount/this.$store.state.withClicksCount;if(this.$store.state.allClicksCount<100){const t=this.$store.state.allClicksCount;return this.bookmark.clickcount<=0?0:this.bookmark.clickcount<.25*t?1:this.bookmark.clickcount<.5*t?2:3}const e=Math.log10(t);return this.bookmark.clickcount<=0?0:Math.log10(this.bookmark.clickcount)<.5*e?1:Math.log10(this.bookmark.clickcount)<1.5*e?2:3}},mounted(){this.fetchBackgroundImage(),this.fetchIcon()},methods:{largeNumbers:t=>t>1e4?Math.round(t/1e3)+"K":t>=1e3?Math.round(t/100)/10+"K":t,getFolderPath(t){return"/"+this.$store.getters.getFolder(t).reverse().map(t=>t.title).join("/")},onDelete(e){e&&!confirm(t("bookmarks","Do you really want to delete this bookmark?"))||(this.$route.name!==this.routes.FOLDER&&this.$route.name!==this.routes.HOME||!this.$store.state.fetchState.query.folder?this.bookmark.folders.forEach(t=>this.$store.dispatch($.o1.DELETE_BOOKMARK,{id:this.bookmark.id,folder:t,hard:e})):this.$store.dispatch($.o1.DELETE_BOOKMARK,{id:this.bookmark.id,folder:this.$store.state.fetchState.query.folder,hard:e}))},onUndelete(){this.$route.name===this.routes.FOLDER&&this.$store.state.fetchState.query.folder?this.$store.dispatch($.o1.UNDELETE_BOOKMARK,{id:this.bookmark.id,folder:this.$store.state.fetchState.query.folder}):this.bookmark.folders.forEach(t=>this.$store.dispatch($.o1.UNDELETE_BOOKMARK,{id:this.bookmark.id,folder:t}))},onDetails(){this.$store.dispatch($.o1.OPEN_BOOKMARK,this.bookmark.id)},onMove(){this.isTrashbin||(this.$store.commit($.z4.RESET_SELECTION),this.$store.commit($.z4.ADD_SELECTION_BOOKMARK,this.bookmark),this.$store.commit($.z4.DISPLAY_MOVE_DIALOG,!0))},onCopy(){this.isTrashbin||(this.$store.commit($.z4.RESET_SELECTION),this.$store.commit($.z4.ADD_SELECTION_BOOKMARK,this.bookmark),this.$store.commit($.z4.DISPLAY_COPY_DIALOG,!0))},async onRename(){this.renaming=!0},async onRenameSubmit(t){this.bookmark.title=t,await this.$store.dispatch($.o1.SAVE_BOOKMARK,this.bookmark.id),this.renaming=!1},onSelect(){this.isTrashbin||(this.selected?this.$store.commit($.z4.REMOVE_SELECTION_BOOKMARK,this.bookmark):this.$store.commit($.z4.ADD_SELECTION_BOOKMARK,this.bookmark))},onClick(){this.bookmark.url.startsWith("file:")&&this.$store.commit($.z4.SET_ERROR,"Most browsers will not allow clicking on file links. Try copying the URL"),this.$store.dispatch($.o1.CLICK_BOOKMARK,this.bookmark)},onCopyUrl(){navigator.clipboard.writeText(this.bookmark.target),this.$store.commit($.z4.SET_NOTIFICATION,this.t("bookmarks","Link copied to clipboard"))},async fetchBackgroundImage(){if(this.bookmark.lastPreview)try{const t=await L.Ay.get(this.imageUrl,{responseType:"blob"}),e=URL.createObjectURL(t.data);this.backgroundImage=`linear-gradient(0deg, var(--color-main-background) 25%, rgba(0, 212, 255, 0) 50%), url('${e}')`}catch(t){}},async fetchIcon(){if(this.iconLoaded=!1,this.bookmark.lastPreview)try{const t=await L.Ay.get(this.iconUrl,{responseType:"blob"}),e=URL.createObjectURL(t.data);this.iconImage=`url('${e}')`,this.iconLoaded=!0}catch(t){this.iconLoaded=!1}}}};var P=o(72674),z={};z.styleTagTransform=g(),z.setAttributes=p(),z.insert=h().bind(null,"head"),z.domAPI=m(),z.insertStyleElement=f();c()(P.A,z);P.A&&P.A.locals&&P.A.locals;const H=(0,_.A)(M,function(){var t=this,e=t._self._c;return e("NcPopover",{attrs:{"popup-role":"dialog",shown:t.popoverShown},scopedSlots:t._u([{key:"trigger",fn:function(){return[e("div",{on:{mouseenter:function(e){![t.routes.FOLDER,t.routes.HOME].includes(t.$route.name)&&(t.popoverShown=!0)},mouseleave:function(e){t.popoverShown=!1}}},[e("Item",{attrs:{title:t.bookmark.title,tags:t.bookmark.tags,"rename-placeholder":t.t("bookmarks","Enter new title"),"select-label":t.t("bookmarks","Select bookmark"),active:t.isActive,editable:t.isEditable,selected:t.selected,draggable:t.isDraggable,renaming:t.renaming,background:t.background,url:t.url,selectable:t.selectable},on:{select:t.onSelect,rename:t.onRenameSubmit,"rename-cancel":function(e){t.renaming=!1},click:t.onClick},scopedSlots:t._u([{key:"icon",fn:function(){return[t.bookmark.preliminary?e("span",{staticClass:"icon-loading-small bookmark__icon"}):t.iconLoaded?e("figure",{staticClass:"bookmark__icon",style:{backgroundImage:t.iconImage}}):e("StarIcon",{staticClass:"bookmark__icon",attrs:{size:20}})]},proxy:!0},{key:"title",fn:function(){return[e("div",{staticClass:"bookmark__title"},[e("h3",{attrs:{title:t.displayTitle}},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.displayTitle)+"\n\t\t\t\t\t\t")]),t._v(" "),t.bookmark.description?e("span",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.bookmark.description,expression:"bookmark.description"}],staticClass:"bookmark__description"},[e("figure",{staticClass:"icon-file"}),t._v("\n\t\t\t\t\t\t\t"+t._s(t.bookmark.description))]):t._e()])]},proxy:!0},{key:"rating",fn:function(){return[0===t.hotness?[e("div",{attrs:{title:t.t("bookmarks","You have never clicked this link")}},[e("HotnessZero",{attrs:{size:20}})],1)]:t._e(),t._v(" "),1===t.hotness?[e("div",{attrs:{title:t.t("bookmarks","You have clicked this link {count} times",{count:t.largeNumbers(t.bookmark.clickcount)})}},[e("Hotness",{attrs:{size:20}})],1)]:t._e(),t._v(" "),2===t.hotness?[e("div",{attrs:{title:t.t("bookmarks","You have clicked this link {count} times",{count:t.largeNumbers(t.bookmark.clickcount)})}},[e("Hotness",{attrs:{size:20}}),e("Hotness",{attrs:{size:20}})],1)]:t._e(),t._v(" "),3===t.hotness?[e("div",{attrs:{title:t.t("bookmarks","You have clicked this link {count} times",{count:t.largeNumbers(t.bookmark.clickcount)})}},[e("Hotness",{attrs:{size:20}}),e("Hotness",{attrs:{size:20}}),e("Hotness",{attrs:{size:20}})],1)]:t._e()]},proxy:!0},{key:"actions",fn:function(){return[t.isTrashbin?[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onUndelete},scopedSlots:t._u([{key:"icon",fn:function(){return[e("UndeleteIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.t("bookmarks","Restore bookmark"))+"\n\t\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:function(e){return t.onDelete(!0)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteForeverIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.t("bookmarks","Delete bookmark permanently"))+"\n\t\t\t\t\t\t")])]:[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onDetails},scopedSlots:t._u([{key:"icon",fn:function(){return[e("InformationVariantIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3093928408)},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.t("bookmarks","Details"))+"\n\t\t\t\t\t\t")]),t._v(" "),e("NcActionCheckbox",{on:{change:t.onSelect}},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.t("bookmarks","Select bookmark"))+"\n\t\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onRename},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PencilIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,4260349822)},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.t("bookmarks","Rename"))+"\n\t\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onCopyUrl},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ContentCopyIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,361197807)},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.t("bookmarks","Copy link"))+"\n\t\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onMove},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderMoveIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,705273188)},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.t("bookmarks","Move"))+"\n\t\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onCopy},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderPlusIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2198745935)},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.t("bookmarks","Add to folders"))+"\n\t\t\t\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:function(e){return t.onDelete(!1)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,1311746650)},[t._v("\n\t\t\t\t\t\t\t"+t._s(t.t("bookmarks","Put bookmark into trash bin"))+"\n\t\t\t\t\t\t")])]]},proxy:!0}])})],1)]},proxy:!0}])},[t._v(" "),e("ul",{staticClass:"bookmark__folder-tooltip"},t._l(t.bookmark.folders,function(n){return e("li",{key:n},[e("FolderIcon",{attrs:{size:20}}),t._v(" "+t._s(t.getFolderPath(n))+"\n\t\t")],1)}),0)])},[],!1,null,null,null).exports;const V={name:"Folder",components:{Item:D,NcActionButton:r.Ko,NcActionCheckbox:r.RI,FolderIcon:I.sj,FolderMoveIcon:I.P1,ShareVariantIcon:I.wr,DeleteIcon:I.d7,DeleteForeverIcon:I.M9,UndeleteIcon:I.In,PencilIcon:I.R2,InformationVariantIcon:I.fM},props:{folder:{type:Object,required:!0}},data:()=>({renaming:!1}),computed:{viewMode(){return this.$store.state.viewMode},currentUser:()=>(0,R.HW)().uid,isOwner(){const t=(0,R.HW)();return t&&this.folder.userId===t.uid},containingFolder(){return this.$store.getters.getFolder(this.$store.state.fetchState.query.folder)[0]},isTrashbin(){return this.containingFolder&&this.containingFolder.softDeleted||this.$route.name===this.routes.TRASHBIN},permissions(){return this.$store.getters.getPermissionsForFolder(this.folder.id)},isDirectShare(){return void 0!==this.$store.state.sharedFoldersById[this.folder.id]},isEditable(){return this.isOwner||this.isDirectShare||this.permissions.canWrite},isDraggable(){return this.isEditable&&!this.isTrashbin},shares(){return this.$store.getters.getSharesOfFolder(this.folder.id)},publicToken(){return this.$store.getters.getTokenOfFolder(this.folder.id)},isShared(){return Boolean(this.shares.length)},isSharedPublicly(){return Boolean(this.publicToken)},selectedFolders(){return this.$store.state.selection.folders},selectable(){return Boolean(this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length)},selected(){return this.selectedFolders.map(t=>t.id).includes(this.folder.id)}},mounted(){setTimeout(()=>{this.$store.dispatch($.o1.LOAD_SHARES_OF_FOLDER,this.folder.id),this.$store.dispatch($.o1.LOAD_PUBLIC_LINK,this.folder.id),this.$store.dispatch($.o1.COUNT_BOOKMARKS,this.folder.id)},2e3)},methods:{onDetails(){this.$store.dispatch($.o1.OPEN_FOLDER_DETAILS,this.folder.id)},onShare(){this.$store.dispatch($.o1.OPEN_FOLDER_SHARING,this.folder.id)},onDelete(e){e&&!confirm(t("bookmarks","Do you really want to permanently delete this folder?"))||this.$store.dispatch($.o1.DELETE_FOLDER,{id:this.folder.id,hard:e})},onUndelete(){this.$store.dispatch($.o1.UNDELETE_FOLDER,{id:this.folder.id})},onMove(){this.isTrashbin||(this.$store.commit($.z4.RESET_SELECTION),this.$store.commit($.z4.ADD_SELECTION_FOLDER,this.folder),this.$store.commit($.z4.DISPLAY_MOVE_DIALOG,!0))},onSelect(t){this.$router.push({name:this.routes.FOLDER,params:{folder:this.folder.id}}),this.$store.state.sidebar&&"folder"===this.$store.state.sidebar.type&&this.$store.dispatch($.o1.OPEN_FOLDER_DETAILS,this.folder.id),t.preventDefault()},async onRename(){this.renaming=!0},onRenameSubmit(t){this.folder.title=t,this.$store.dispatch($.o1.SAVE_FOLDER,this.folder.id),this.renaming=!1},clickSelect(t){this.isTrashbin||(this.selected?this.$store.commit($.z4.REMOVE_SELECTION_FOLDER,this.folder):this.$store.commit($.z4.ADD_SELECTION_FOLDER,this.folder))},allowDrop(){return!this.isTrashbin&&!this.$store.state.selection.folders.includes(this.folder)&&(this.$store.state.selection.folders.length||this.$store.state.selection.bookmarks.length)},async onDrop(t){t.preventDefault();try{await this.$store.dispatch($.o1.MOVE_SELECTION,this.folder.id)}finally{this.$store.commit($.z4.RESET_SELECTION)}}}};var U=o(95895),Y={};Y.styleTagTransform=g(),Y.setAttributes=p(),Y.insert=h().bind(null,"head"),Y.domAPI=m(),Y.insertStyleElement=f();c()(U.A,Y);U.A&&U.A.locals&&U.A.locals;const K=(0,_.A)(V,function(){var t=this,e=t._self._c;return e("Item",{attrs:{active:t.selected,editable:t.isEditable,draggable:t.isDraggable,selected:t.selected,title:t.folder.title,renaming:t.renaming,"select-label":t.t("bookmarks","Select folder"),"rename-placeholder":t.t("bookmarks","Enter folder title"),selectable:t.selectable,"allow-drop":t.allowDrop},on:{drop:t.onDrop,select:t.clickSelect,rename:t.onRenameSubmit,"rename-cancel":function(e){t.renaming=!1},click:t.onSelect},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderIcon",{class:"folder__icon",attrs:{size:20,"fill-color":t.colorPrimaryElement},on:{click:t.onSelect}}),t._v(" "),t.isShared||!t.isOwner||t.isSharedPublicly?e("ShareVariantIcon",{class:["folder__icon","shared"],attrs:{size:20,"fill-color":t.colorPrimaryElement}}):t._e()]},proxy:!0},{key:"title",fn:function(){return[e("h3",{staticClass:"folder__title"},[t._v("\n\t\t\t"+t._s(t.folder.title)+"\n\t\t")])]},proxy:!0},{key:"tags",fn:function(){return[e("div",{staticClass:"folder__tags"},[t.isOwner||t.isSharedPublicly?t._e():e("div",{staticClass:"folder__tag"},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Shared by {user}",{user:t.folder.userDisplayName}))+"\n\t\t\t")])])]},proxy:!0},{key:"actions",fn:function(){return[t.isTrashbin?[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onUndelete},scopedSlots:t._u([{key:"icon",fn:function(){return[e("UndeleteIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Restore folder"))+"\n\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:function(e){return t.onDelete(!0)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteForeverIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Delete folder permanently"))+"\n\t\t\t")])]:[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onDetails},scopedSlots:t._u([{key:"icon",fn:function(){return[e("InformationVariantIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3093928408)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Details"))+"\n\t\t\t")]),t._v(" "),e("NcActionCheckbox",{on:{change:t.clickSelect}},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Select folder"))+"\n\t\t\t")]),t._v(" "),t.permissions.canShare?e("NcActionButton",{attrs:{icon:"icon-share","close-after-click":!0},on:{click:t.onShare},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ShareVariantIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,1624511161)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Share folder"))+"\n\t\t\t")]):t._e(),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onRename},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PencilIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,4260349822)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Rename folder"))+"\n\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onMove},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderMoveIcon",{attrs:{size:20,"fill-color":t.colorMainText}})]},proxy:!0}],null,!1,609337574)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Move folder"))+"\n\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:function(e){return t.onDelete(!1)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,1311746650)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Put folder into trashbin"))+"\n\t\t\t")])]]},proxy:!0}])})},[],!1,null,null,null).exports;const G={name:"CreateBookmark",components:{Item:D,EarthIcon:I.OV},computed:{creating(){return this.$store.state.loading.createBookmark},isFolderView(){return this.$route.name===this.$store.getters.getRoutes().FOLDER},isTagView(){return this.$route.name===this.$store.getters.getRoutes().TAGS}},methods:{submit(t){this.$store.dispatch($.o1.CREATE_BOOKMARK,{url:t,...this.isFolderView&&{folders:[this.$route.params.folder]},...this.isTagView&&{tags:this.$route.params.tags.split(",")}})},cancel(){this.$store.commit($.z4.DISPLAY_NEW_BOOKMARK,!1)}}};var q=o(92229),W={};W.styleTagTransform=g(),W.setAttributes=p(),W.insert=h().bind(null,"head"),W.domAPI=m(),W.insertStyleElement=f();c()(q.A,W);q.A&&q.A.locals&&q.A.locals;const j=(0,_.A)(G,function(){var t=this,e=t._self._c;return e("Item",{attrs:{selectable:!1,renaming:!0,title:"",editable:!0,"rename-placeholder":t.t("bookmarks","Enter a link"),"select-label":""},on:{rename:t.submit,"rename-cancel":t.cancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("EarthIcon",{staticClass:"icon",attrs:{size:20,"fill-color":t.colorMainText}})]},proxy:!0}])})},[],!1,null,"96c6698c",null).exports;const J={name:"CreateFolder",components:{Item:D,FolderIcon:I.sj},computed:{loading(){return this.$store.state.loading.createFolder}},methods:{submit(t){const e=this.$route.params.folder;this.$store.dispatch($.o1.CREATE_FOLDER,{parentFolder:e,title:t})},cancel(){this.$store.commit($.z4.DISPLAY_NEW_FOLDER,!1)}}};var Q=o(42325),X={};X.styleTagTransform=g(),X.setAttributes=p(),X.insert=h().bind(null,"head"),X.domAPI=m(),X.insertStyleElement=f();c()(Q.A,X);Q.A&&Q.A.locals&&Q.A.locals;const Z=(0,_.A)(J,function(){var t=this,e=t._self._c;return e("Item",{attrs:{selectable:!1,renaming:!0,title:"",editable:!0,"rename-placeholder":t.t("bookmarks","Enter a title"),"select-label":""},on:{rename:t.submit,"rename-cancel":t.cancel},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderIcon",{staticClass:"icon",attrs:{size:20,"fill-color":t.colorPrimaryElement}})]},proxy:!0}])})},[],!1,null,"14270aa2",null).exports;const tt={name:"NoBookmarks",components:{TrashbinIcon:I.X,NcEmptyContent:r.yI,StarShootingIcon:I.fR,NcButton:r.x1,NcLoadingIcon:r.ne,UploadIcon:I.a_,PlusIcon:I.c1,ShareVariantIcon:I.wr,VectorLinkIcon:I.LW,LinkVariantOffIcon:I.KD,FileDocumentMultipleIcon:I.ni,MagnifyIcon:I.jh},data:()=>({importing:!1}),computed:{routes:()=>s.YO},methods:{onCreateOpen(){this.$store.commit($.z4.DISPLAY_NEW_BOOKMARK,!0)},onImportOpen(){this.$refs.import.click()},async onImportSubmit(t){this.importing=!0;try{await this.$store.dispatch($.o1.IMPORT_BOOKMARKS,{file:t.target.files[0],folder:this.$route.params.folder||-1})}catch(t){console.warn(t)}this.importing=!1},onSearchGlobally(){this.$router.push({name:this.routes.SEARCH,params:{search:this.$route.params.search,folder:"-1"}})}}};var et=o(10501),nt={};nt.styleTagTransform=g(),nt.setAttributes=p(),nt.insert=h().bind(null,"head"),nt.domAPI=m(),nt.insertStyleElement=f();c()(et.A,nt);et.A&&et.A.locals&&et.A.locals;const ot=(0,_.A)(tt,function(){var t=this,e=t._self._c;return e("div",{staticClass:"bookmarkslist__emptyBookmarks"},[t.$route.name===t.routes.ARCHIVED?e("NcEmptyContent",{attrs:{name:t.t("bookmarks","No bookmarked files"),description:t.t("bookmarks","Bookmarks to files like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FileDocumentMultipleIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,127782362)}):t.$route.name===t.routes.SEARCH?e("NcEmptyContent",{attrs:{name:t.t("bookmarks","Nothing found"),description:t.t("bookmarks","Your search yielded no results in the current folder.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("StarShootingIcon")]},proxy:!0},-1!==Number(t.$route.params.folder)?{key:"action",fn:function(){return[e("NcButton",{on:{click:t.onSearchGlobally},scopedSlots:t._u([{key:"icon",fn:function(){return[e("MagnifyIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2188526064)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Repeat search in all folders"))+"\n\t\t\t")])]},proxy:!0}:null],null,!0)}):t.$route.name===t.routes.UNAVAILABLE?e("NcEmptyContent",{attrs:{name:t.t("bookmarks","No broken links"),description:t.t("bookmarks","Bookmarked links are checked regularly and the ones that cannot be reached are listed here.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("LinkVariantOffIcon",{attrs:{size:20}})]},proxy:!0}])}):t.$route.name===t.routes.SHARED_FOLDERS?e("NcEmptyContent",{attrs:{name:t.t("bookmarks","No shared folders"),description:t.t("bookmarks","You can share bookmark folders with others. All folders shared with you are listed here.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ShareVariantIcon",{attrs:{size:20}})]},proxy:!0}])}):t.$route.name===t.routes.DUPLICATED?e("NcEmptyContent",{attrs:{name:t.t("bookmarks","No duplicated bookmarks"),description:t.t("bookmarks","One bookmark can be in multiple folders at once. Updating it will update all copies. All duplicated bookmarks are listed here for convenience.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("VectorLinkIcon",{attrs:{size:20}})]},proxy:!0}])}):t.$route.name===t.routes.TRASHBIN?e("NcEmptyContent",{attrs:{name:t.t("bookmarks","No deleted bookmarks"),description:t.t("bookmarks","You haven't deleted anything yet.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("TrashbinIcon",{attrs:{size:20}})]},proxy:!0}])}):e("NcEmptyContent",{attrs:{name:t.t("bookmarks","No bookmarks here"),description:t.t("bookmarks","Add bookmarks manually or import bookmarks from a HTML file.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("StarShootingIcon",{attrs:{size:20}})]},proxy:!0},t.isPublic?null:{key:"action",fn:function(){return[e("input",{ref:"import",staticClass:"import",attrs:{type:"file",size:"5"},on:{change:t.onImportSubmit}}),t._v(" "),e("NcButton",{on:{click:t.onCreateOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PlusIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2953566425)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Add a bookmark"))+"\n\t\t\t")]),t._v(" "),e("NcButton",{on:{click:t.onImportOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[t.importing?e("NcLoadingIcon",{attrs:{size:20}}):e("UploadIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,810939278)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Import bookmarks"))+"\n\t\t\t")])]},proxy:!0}],null,!0)})],1)},[],!1,null,"499e70ee",null).exports;const rt={name:"FirstRun",components:{NcEmptyContent:r.yI,SyncIcon:I.Fj,NcButton:r.x1,PlusIcon:I.c1,UploadIcon:I.a_,NcLoadingIcon:r.ne,StarShootingIcon:I.fR},data:()=>({importing:!1}),computed:{routes:()=>s.YO},methods:{onCreateOpen(){this.$store.commit($.z4.DISPLAY_NEW_BOOKMARK,!0)},onImportOpen(){this.$refs.import.click()},onSyncOpen(){window.open("https://floccus.org","_blank")},async onImportSubmit(t){this.importing=!0;try{await this.$store.dispatch($.o1.IMPORT_BOOKMARKS,{file:t.target.files[0],folder:this.$route.params.folder||-1})}catch(t){console.warn(t)}this.importing=!1}}};var it=o(78013),st={};st.styleTagTransform=g(),st.setAttributes=p(),st.insert=h().bind(null,"head"),st.domAPI=m(),st.insertStyleElement=f();c()(it.A,st);it.A&&it.A.locals&&it.A.locals;const at=(0,_.A)(rt,function(){var t=this,e=t._self._c;return e("div",{staticClass:"bookmarkslist__emptyBookmarks"},[e("NcEmptyContent",{attrs:{name:t.t("bookmarks","Welcome to Bookmarks"),description:t.t("bookmarks","This app allows you to manage links to your favorite places on the web. Sort your bookmarks into folders, label them with tags and share them with others! The app will regularly check all your links for availability and display unavailable links. If you add a link to a file on the web, the file will be automatically downloaded to your Nextcloud Files. You can also import bookmarks exported from other services or directly sync bookmarks from all your browsers with this app.")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("StarShootingIcon",{attrs:{size:20}})]},proxy:!0},{key:"action",fn:function(){return[e("input",{ref:"import",staticClass:"import",attrs:{type:"file",size:"5"},on:{change:t.onImportSubmit}}),t._v(" "),e("NcButton",{on:{click:t.onCreateOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PlusIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Add a bookmark"))+"\n\t\t\t")]),t._v(" "),e("NcButton",{on:{click:t.onImportOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[t.importing?e("NcLoadingIcon"):e("UploadIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Import bookmarks"))+"\n\t\t\t")]),t._v(" "),e("NcButton",{on:{click:t.onSyncOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[e("SyncIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Sync with your browser"))+"\n\t\t\t")])]},proxy:!0}])})],1)},[],!1,null,"3f36d5a7",null).exports,lt={name:"VirtualScroll",props:{reachedEnd:{type:Boolean,required:!0}},data:()=>({viewport:{width:0,height:0},itemHeight:0,itemWidth:0,startIndex:0,visibleItems:80,scrollTop:0,scrollHeight:500,initialLoadingSkeleton:!1,initialLoadingTimeout:null,timeout:null}),computed:{viewMode(){return this.$store.state.viewMode},newBookmark(){return this.$store.state.displayNewBookmark},newFolder(){return this.$store.state.displayNewFolder},fetching(){return this.$store.state.loading.bookmarks},sidebar(){return this.$store.state.sidebar}},watch:{newBookmark(){this.$el.scrollTop=0},newFolder(){this.$el.scrollTop=0},viewMode(){this.onViewModeChange()},itemHeight(){this.recalculateVisibleItems()},itemWidth(){this.recalculateVisibleItems()},sidebar(){this.$nextTick(()=>{this.onScroll()})}},mounted(){this.$nextTick(()=>{this.onViewModeChange(),this.onScroll()}),window.addEventListener("resize",this.onScroll)},destroyed(){window.removeEventListener("resize",this.onScroll)},methods:{onViewModeChange(){this.viewport.width=this.$el.clientWidth,this.viewport.height=this.$el.clientHeight,"grid"===this.viewMode?(this.itemHeight=210,this.itemWidth=260):(this.itemHeight=46,this.itemWidth=this.viewport.width)},recalculateVisibleItems(){this.visibleItems=(Math.ceil(this.viewport.height/this.itemHeight)+2)*Math.floor(this.viewport.width/this.itemWidth)},onScroll(){this.viewport.width=this.$el.clientWidth,this.viewport.height=this.$el.clientHeight;const t=this.$el.scrollTop;this.startIndex=Math.floor(t/this.itemHeight)*Math.floor(this.viewport.width/this.itemWidth);const e=this.$slots.default.filter(t=>!!t.componentOptions);t+this.viewport.height>=Math.ceil(e.length/this.itemWidth)*this.itemHeight-100&&(this.fetching||this.$emit("load-more"))}},render(t){if(!this.$slots.default||!this.$el)return t("div",{class:"virtual-scroll"});const e=this.$slots.default.filter(t=>!!t.componentOptions),n=Math.min(this.startIndex+this.visibleItems,e.length),o=Array.from({length:n-this.startIndex},(t,e)=>this.startIndex+e),r=Math.floor(this.viewport.width/this.itemWidth);return t("div",{class:"virtual-scroll",on:{scroll:()=>this.onScroll()}},[t("div",{class:"container-window",style:{height:Math.ceil(e.length/r)*this.itemHeight+"px",position:"relative"}},o.map(n=>{const o=Math.floor(n/r),i=n-o*r;return t("div",{key:n,style:{position:"absolute",top:o*this.itemHeight+"px",left:i*this.itemWidth+(1===r?0:10)+"px",height:`${this.itemHeight}px`,width:`${this.itemWidth}px`}},[e[n]])}))])}};var ct=o(49864),dt={};dt.styleTagTransform=g(),dt.setAttributes=p(),dt.insert=h().bind(null,"head"),dt.domAPI=m(),dt.insertStyleElement=f();c()(ct.A,dt);ct.A&&ct.A.locals&&ct.A.locals;const mt=(0,_.A)(lt,void 0,void 0,!1,null,"402a41e6",null).exports,At={name:"BookmarksList",components:{NcButton:r.x1,CreateFolder:Z,CreateBookmark:j,VirtualScroll:mt,FirstRun:at,NoBookmarks:ot,Bookmark:H,Folder:K,NcNoteCard:r.mQ,MagnifyIcon:I.jh},computed:{bookmarks(){return this.$store.state.bookmarks},reachedEnd(){return this.$store.state.fetchState.reachedEnd},descriptionShown(){return this.$route.name===this.routes.ARCHIVED||this.$route.name===this.routes.SEARCH&&-1!==Number(this.$route.params.folder)||this.$route.name===this.routes.UNAVAILABLE||this.$route.name===this.routes.SHARED_FOLDERS||this.$route.name===this.routes.DUPLICATED},allBookmarksCount(){return this.$store.state.countsByFolder[-1]},children(){if(this.$route.name!==this.routes.HOME&&this.$route.name!==this.routes.FOLDER)return[];const t=this.$route.params.folder||"-1";return t?this.$store.getters.getFolderChildren(t):[]},subFolders(){if(this.$route.name===this.routes.SHARED_FOLDERS)return Object.keys(this.$store.state.sharedFoldersById).map(t=>this.$store.getters.getFolder(t)[0]).filter(Boolean);if(this.$route.name===this.routes.TRASHBIN)return this.$store.state.deletedFolders;if(this.$route.name===this.routes.SEARCH){const t=e=>{const n=e.children.flatMap(t);return e.title&&this.$store.state.fetchState.query.search&&this.$store.state.fetchState.query.search.every(t=>t.trim()&&e.title.toLowerCase().includes(t.toLowerCase()))&&n.push(e),n};return this.$store.getters.getFolder(this.$store.state.fetchState.query.folder||-1)[0].children.flatMap(t)}if(this.$route.name!==this.routes.HOME&&this.$route.name!==this.routes.FOLDER)return[];const t=this.$route.params.folder||"-1";if(!t)return[];const e=this.$store.getters.getFolder(t)[0];return e?(this.$store.dispatch($.o1.LOAD_SHARES_OF_FOLDER,t),e.children):[]},newBookmark(){return this.$store.state.displayNewBookmark},newFolder(){return this.$store.state.displayNewFolder},viewMode(){return this.$store.state.viewMode},sortOrder(){return this.$store.state.settings.sorting},loading(){return this.$store.state.loading.bookmarks||this.$store.state.loading.folders}},methods:{loadMore(){this.$route.name!==s.YO.SHARED_FOLDERS?this.$store.dispatch($.o1.FETCH_PAGE):this.$store.commit($.z4.REACHED_END)},getFolder(t){return this.$store.getters.getFolder(t)[0]},getBookmark(t){return this.$store.getters.getBookmark(t)},onSearchGlobally(){this.$router.push({name:this.routes.SEARCH,params:{search:this.$route.params.search,folder:"-1"}})}}};var ht=o(75285),ut={};ut.styleTagTransform=g(),ut.setAttributes=p(),ut.insert=h().bind(null,"head"),ut.domAPI=m(),ut.insertStyleElement=f();c()(ht.A,ut);ht.A&&ht.A.locals&&ht.A.locals;const pt=(0,_.A)(At,function(){var t=this,e=t._self._c;return e("div",{class:{bookmarkslist:!0,"bookmarkslist--gridview":"grid"===t.viewMode,"bookmarkslist--with-description":t.descriptionShown}},[t.$route.name===t.routes.TRASHBIN&&(t.bookmarks.length||t.subFolders.length)?e("div",{staticClass:"bookmarkslist__description"},[e("NcNoteCard",{attrs:{type:"info"}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","These are your deleted items. Items will be deleted permanently after two months."))+"\n\t\t")])],1):t._e(),t._v(" "),t.$route.name===t.routes.ARCHIVED&&t.bookmarks.length?e("div",{staticClass:"bookmarkslist__description"},[e("NcNoteCard",{attrs:{type:"info"}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Bookmarks to files on the web like photos or PDFs will automatically be saved to your Nextcloud files, so you can still find them even when the link goes offline."))+"\n\t\t")])],1):t._e(),t._v(" "),t.$route.name===t.routes.SEARCH&&(t.bookmarks.length||t.subFolders.length)&&-1!==Number(t.$route.params.folder)?e("div",{staticClass:"bookmarkslist__description"},[e("NcNoteCard",{attrs:{type:"info"}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Searching in the current folder only."))+"\n\t\t\t"),e("NcButton",{on:{click:t.onSearchGlobally},scopedSlots:t._u([{key:"icon",fn:function(){return[e("MagnifyIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2188526064)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Repeat search in all folders"))+"\n\t\t\t")])],1)],1):t._e(),t._v(" "),t.$route.name===t.routes.UNAVAILABLE&&t.bookmarks.length?e("div",{staticClass:"bookmarkslist__description"},[e("NcNoteCard",{attrs:{type:"info"}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Bookmarked links are checked regularly and the ones that cannot be reached are listed here."))+"\n\t\t")])],1):t._e(),t._v(" "),t.$route.name===t.routes.SHARED_FOLDERS&&t.bookmarks.length?e("div",{staticClass:"bookmarkslist__description"},[e("NcNoteCard",{attrs:{type:"info"}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","You can share bookmark folders with others. All folders shared with you are listed here."))+"\n\t\t")])],1):t._e(),t._v(" "),t.$route.name===t.routes.DUPLICATED&&t.bookmarks.length?e("div",{staticClass:"bookmarkslist__description"},[e("NcNoteCard",{attrs:{type:"info"}},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","One bookmark can be in multiple folders at once. Updating it will update all copies. All duplicated bookmarks are listed here for convenience."))+"\n\t\t")])],1):t._e(),t._v(" "),e("VirtualScroll",{attrs:{"reached-end":t.reachedEnd},on:{"load-more":t.loadMore}},[t.newBookmark?e("CreateBookmark"):t._e(),t._v(" "),t.newFolder?e("CreateFolder"):t._e(),t._v(" "),t.$route.name===t.routes.FOLDER||t.$route.name===t.routes.HOME?["index"===t.sortOrder&&t.children.length?[t._l(t.children,function(n){return["folder"===n.type&&t.getFolder(n.id)?e("Folder",{key:"customsort"+n.type+n.id,attrs:{folder:t.getFolder(n.id)}}):t._e(),t._v(" "),"bookmark"===n.type&&t.getBookmark(n.id)?e("Bookmark",{key:"nosort"+n.type+n.id,attrs:{bookmark:t.getBookmark(n.id)}}):t._e()]})]:0!==t.subFolders.length||0!==t.bookmarks.length?[t._l(t.subFolders,function(t){return e("Folder",{key:"normalsortfolder"+t.id,attrs:{folder:t}})}),t._v(" "),t.bookmarks.length?t._l(t.bookmarks,function(t){return e("Bookmark",{key:"nosortbookmark"+t.id,attrs:{bookmark:t}})}):t._e()]:t.subFolders.length||t.bookmarks.length||t.children.length?t._e():[!t.loading&&(t.allBookmarksCount>0||t.isPublic)?e("NoBookmarks"):t.loading?t._e():e("FirstRun")]]:t.$route.name===t.routes.SHARED_FOLDERS?[t._l(t.subFolders,function(t){return e("Folder",{key:"sharedfoldersfolder"+t.id,attrs:{folder:t}})}),t._v(" "),0===t.subFolders.length?[!t.loading&&(t.allBookmarksCount>0||t.isPublic)?e("NoBookmarks"):t.loading?t._e():e("FirstRun")]:t._e()]:[t._l(t.subFolders,function(t){return e("Folder",{key:"nosortfolder"+t.id,attrs:{folder:t}})}),t._v(" "),t._l(t.bookmarks,function(t){return e("Bookmark",{key:"nosortbookmark"+t.id,attrs:{bookmark:t}})}),t._v(" "),t.subFolders.length||t.bookmarks.length?t._e():[!t.loading&&(t.allBookmarksCount>0||t.isPublic)?e("NoBookmarks"):t.loading?t._e():e("FirstRun")]]],2)],1)},[],!1,null,null,null).exports},94079(e,n,o){"use strict";o.d(n,{A:()=>N});var r=o(11574),i=o(96192),s=o(2326),a=o(63814),l=o(5287),c=o.n(l);const d={name:"BulkEditing",components:{NcActionInput:r.Az,NcActionSeparator:r.z,FolderPlusIcon:i.YP,FolderMoveIcon:i.P1,NcActionButton:r.Ko,NcActions:r.B6,OpenInNewIcon:i.PH,TagIcon:i.gq,SelectAllIcon:i.nh,SelectOffIcon:i.XI,DeleteIcon:i.d7},data:()=>({selectionTags:[]}),computed:{allTags(){return this.$store.state.tags.map(t=>t.name)},selectedFolders(){return this.$store.state.selection.folders},selectedBookmarks(){return this.$store.state.selection.bookmarks},selectionDescription(){return 0!==this.$store.state.selection.bookmarks.length&&0!==this.$store.state.selection.folders.length?this.t("bookmarks","Selected {folders} folders and {bookmarks} bookmarks",{folders:this.$store.state.selection.folders.length,bookmarks:this.$store.state.selection.bookmarks.length}):0!==this.$store.state.selection.bookmarks.length?this.n("bookmarks","Selected %n bookmark","Selected %n bookmarks",this.$store.state.selection.bookmarks.length):0!==this.$store.state.selection.folders.length?this.n("bookmarks","Selected %n folder","Selected %n folders",this.$store.state.selection.folders.length):""}},watch:{selectedBookmarks(t){this.updateSelectionTags()}},methods:{async onBulkOpen(){for(const{url:t}of this.$store.state.selection.bookmarks)window.open(t),await new Promise(t=>setTimeout(t,200))},async onBulkDelete(){confirm(t("bookmarks","Do you really want to delete these items?"))&&(await this.$store.dispatch(s.o1.DELETE_SELECTION,{folder:this.$route.params.folder}),this.$store.commit(s.z4.RESET_SELECTION))},onBulkMove(){this.$store.commit(s.z4.DISPLAY_MOVE_DIALOG,!0)},onBulkCopy(){this.$store.commit(s.z4.DISPLAY_COPY_DIALOG,!0)},async onBulkTag(t){const e=this.selectionTags;this.selectionTags=t,await this.$store.dispatch(s.o1.TAG_SELECTION,{tags:t,originalTags:e})},onCancelSelection(){this.$store.commit(s.z4.RESET_SELECTION)},async onSelectAll(){await this.$store.dispatch(s.o1.FETCH_ALL),this.$store.state.bookmarks.forEach(t=>{this.$store.commit(s.z4.ADD_SELECTION_BOOKMARK,t)})},updateSelectionTags(){this.selectionTags=c()(...this.selectedBookmarks.map(t=>t.tags))}}};var m=o(85072),A=o.n(m),h=o(97825),u=o.n(h),p=o(77659),k=o.n(p),f=o(55056),b=o.n(f),g=o(10540),C=o.n(g),v=o(41113),_=o.n(v),y=o(25080),I={};I.styleTagTransform=_(),I.setAttributes=b(),I.insert=k().bind(null,"head"),I.domAPI=u(),I.insertStyleElement=C();A()(y.A,I);y.A&&y.A.locals&&y.A.locals;var x=o(14486);const S=(0,x.A)(d,function(){var t=this,e=t._self._c;return e("div",{staticClass:"bulkediting"},[e("NcActions",{attrs:{primary:!0,"menu-name":t.selectionDescription}},[e("NcActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkOpen},scopedSlots:t._u([{key:"icon",fn:function(){return[e("OpenInNewIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Open all selected"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkMove},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderMoveIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Move selection"))+"\n\t\t")]),t._v(" "),t.selectedFolders.length?t._e():e("NcActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkCopy},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderPlusIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2198745935)},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Add to folders"))+"\n\t\t")]),t._v(" "),t.selectedFolders.length?t._e():e("NcActionInput",{attrs:{value:t.selectionTags,type:"multiselect",options:t.allTags,multiple:!0,taggable:!0},on:{tag:function(e){return t.onBulkTag([...t.selectionTags,e])},input:t.onBulkTag},scopedSlots:t._u([{key:"icon",fn:function(){return[e("TagIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3295128625)},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Edit tags of selection"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":""},on:{click:t.onBulkDelete},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Delete selection"))+"\n\t\t")]),t._v(" "),e("NcActionSeparator"),t._v(" "),e("NcActionButton",{on:{click:t.onSelectAll},scopedSlots:t._u([{key:"icon",fn:function(){return[e("SelectAllIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Select all"))+"\n\t\t")]),t._v(" "),e("NcActionButton",{on:{click:t.onCancelSelection},scopedSlots:t._u([{key:"icon",fn:function(){return[e("SelectOffIcon",{attrs:{size:20}})]},proxy:!0}])},[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Cancel selection"))+"\n\t\t")])],1)],1)},[],!1,null,null,null).exports,w={name:"Controls",components:{NcButton:r.x1,BulkEditing:S,DeleteForeverIcon:i.M9,TrashbinIcon:i.X,NcSelect:r.EQ,NcActions:r.B6,NcActionButton:r.Ko,NcActionInput:r.Az,NcActionRouter:r.b3,RssIcon:i.wi,SortAscendingIcon:i.GC,SortCalendarAscendingIcon:i._z,SortAlphabeticalAscendingIcon:i.Wb,SortClockAscendingOutlineIcon:i.cD,SortBoolAscendingIcon:i.EV,SortNumericAscendingIcon:i.fY,FolderIcon:i.sj,ArrowLeftIcon:i.A6,PlusIcon:i.c1,ViewGridIcon:i.Tv,ViewListIcon:i.HJ,EarthIcon:i.OV,ShareVariantIcon:i.wr,TagIcon:i.gq,NcTextField:r.v,MagnifyIcon:i.jh,InformationVariantIcon:i.fM},props:{},data(){return{searchTimeout:null,url:"",search:this.$route.params.search||"",sortingOptions:{added:{icon:"SortCalendarAscendingIcon",description:this.t("bookmarks","Sort by created date")},lastmodified:{icon:"SortClockAscendingOutlineIcon",description:this.t("bookmarks","Sort by last modified")},title:{icon:"SortAlphabeticalAscendingIcon",description:this.t("bookmarks","Sort by title")},clickcount:{icon:"SortBoolAscendingIcon",description:this.t("bookmarks","Sort by click count")},index:{icon:"SortAscendingIcon",description:this.t("bookmarks","Sort by manual order")},url:{icon:"SortNumericAscendingIcon",description:this.t("bookmarks","Sort by URL")}}}},computed:{isTrashbin(){return this.$route.name===this.routes.TRASHBIN||this.$route.name===this.routes.FOLDER&&this.folder&&this.folder.softDeleted},isTrashbinRoot(){return this.$route.name===this.routes.TRASHBIN},backLink(){return this.folder&&this.folderPath.length>1?{name:this.routes.FOLDER,params:{folder:this.folder.parent_folder}}:this.isTrashbin?{name:this.routes.TRASHBIN}:{name:this.routes.HOME}},permissions(){const t=this.folder;return t?this.$store.getters.getPermissionsForFolder(t.id):{}},allTags(){return this.$store.state.tags.map(t=>t.name)},tags(){const t=this.$route.params.tags;return t?t.split(","):[]},folderPath(){const t=this.$route.params.folder;return t?this.$store.getters.getFolder(t).reverse():[]},folder(){const t=this.$route.params.folder;if(t)return this.$store.getters.getFolder(t)[0]},viewMode(){return this.$store.state.viewMode},hasSelection(){return this.$store.state.selection.bookmarks.length||this.$store.state.selection.folders.length},rssURL(){const t=new URLSearchParams;for(const e in this.$store.state.fetchState.query)Array.isArray(this.$store.state.fetchState.query[e])?this.$store.state.fetchState.query[e].forEach(n=>{t.append(e+"[]",n)}):t.append(e,this.$store.state.fetchState.query[e]);return t.set("format","rss"),t.set("page","-1"),this.$store.state.public&&t.set("token",this.$store.state.authToken),window.location.origin+(0,a.Jv)("/apps/bookmarks/public/rest/v2/bookmark?"+t.toString())},sorting(){return this.$store.state.settings.sorting}},created(){},methods:{onSelectHome(){this.$router.push({name:this.routes.HOME})},onClickBack(){this.$router.push(this.backLink)},onTagsChange(t){this.$router.push({name:this.routes.TAGS,params:{tags:t.join(",")}})},onSelectFolder(t){this.$router.push({name:this.routes.FOLDER,params:{folder:t}})},onOpenFolderShare(){this.folder&&this.$store.dispatch(s.o1.OPEN_FOLDER_SHARING,this.folder.id)},onOpenFolderDetails(){this.folder&&this.$store.dispatch(s.o1.OPEN_FOLDER_DETAILS,this.folder.id)},onAddFolder(){this.$store.commit(s.z4.DISPLAY_NEW_FOLDER,!this.$store.state.displayNewFolder)},onAddBookmark(){this.$store.commit(s.z4.DISPLAY_NEW_BOOKMARK,!this.$store.state.displayNewBookmark)},onToggleViewMode(){this.$store.dispatch(s.o1.SET_SETTING,{key:"viewMode",value:"grid"===this.$store.state.viewMode?"list":"grid"})},onSearch(t){this.searchTimeout&&clearTimeout(this.searchTimeout),this.searchTimeout=setTimeout(()=>{t.trim().length<3||(t.trim()?this.$router.push({name:this.routes.SEARCH,params:{search:t,folder:this.folder?.id||-1}}):this.$route.name===this.routes.SEARCH&&(this.folder?this.$router.push({name:this.routes.FOLDER,params:{folder:this.folder.id}}):this.$router.push({name:this.routes.HOME})))},350)},copyRssUrl(){navigator.clipboard.writeText(this.rssURL),this.$store.commit(s.z4.SET_NOTIFICATION,t("bookmarks","RSS feed copied"))},async onChangeSorting(t){await this.$store.dispatch(s.o1.SET_SETTING,{key:"sorting",value:t}),await this.$store.dispatch(s.o1.FETCH_PAGE)},async onEmptyTrashbin(){await this.$store.dispatch(s.o1.EMPTY_TRASHBIN)}}};var E=o(43069),$={};$.styleTagTransform=_(),$.setAttributes=b(),$.insert=k().bind(null,"head"),$.domAPI=u(),$.insertStyleElement=C();A()(E.A,$);E.A&&E.A.locals&&E.A.locals;const N=(0,x.A)(w,function(){var t=this,e=t._self._c;return e("div",{class:["controls",t.$store.state.public&&"wide"]},[e("div",{staticClass:"controls__left"},[t.isTrashbin?e("TrashbinIcon",{attrs:{size:20}}):t._e(),t._v(" "),t.isTrashbin?e("h2",[t._v("\n\t\t\t"+t._s(t.t("bookmarks","Trash Bin"))+"\n\t\t")]):t._e(),t._v(" "),t.$route.name===t.routes.FOLDER||t.$route.name===t.routes.SEARCH&&-1!==Number(t.$route.params.folder)?e("NcActions",[e("NcActionButton",{on:{click:t.onClickBack},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ArrowLeftIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2392303489)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Go back"))+"\n\t\t\t")])],1):t._e(),t._v(" "),t.$route.name===t.routes.FOLDER||t.$route.name===t.routes.SEARCH&&-1!==Number(t.$route.params.folder)?[e("h2",[e("FolderIcon",{attrs:{size:20}}),t._v(" "),t.folder?e("span",{class:{strikethrough:t.isTrashbin}},[t._v(t._s(t.folder.title))]):t._e()],1),t._v(" "),t.permissions.canShare&&!t.isTrashbin?e("NcActions",[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onOpenFolderShare},scopedSlots:t._u([{key:"icon",fn:function(){return[e("ShareVariantIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,1624511161)},[t._v("\n\t\t\t\t\t"+t._s(t.t("bookmarks","Share folder"))+"\n\t\t\t\t")])],1):t._e(),t._v(" "),t.isTrashbin?t._e():e("NcActions",[e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onOpenFolderDetails},scopedSlots:t._u([{key:"icon",fn:function(){return[e("InformationVariantIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3093928408)},[t._v("\n\t\t\t\t\t"+t._s(t.t("bookmarks","Open folder details"))+"\n\t\t\t\t")])],1)]:t._e(),t._v(" "),t.$route.name===t.routes.TAGS?[e("TagIcon",{attrs:{size:20}}),t._v(" "),e("NcSelect",{staticClass:"controls__tags",attrs:{value:t.tags,"auto-limit":!1,limit:7,options:t.allTags,multiple:!0,placeholder:t.t("bookmarks","Select one or more tags")},on:{input:t.onTagsChange}})]:t._e(),t._v(" "),t.isPublic||t.isTrashbin?t._e():e("NcActions",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.t("bookmarks","New"),expression:"t('bookmarks', 'New')"}],attrs:{name:t.t("bookmarks","New")},scopedSlots:t._u([{key:"icon",fn:function(){return[e("PlusIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,2953566425)},[t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onAddBookmark},scopedSlots:t._u([{key:"icon",fn:function(){return[e("EarthIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,900221033)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","New bookmark"))+"\n\t\t\t")]),t._v(" "),e("NcActionButton",{attrs:{"close-after-click":!0},on:{click:t.onAddFolder},scopedSlots:t._u([{key:"icon",fn:function(){return[e("FolderIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,228007765)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","New folder"))+"\n\t\t\t")])],1),t._v(" "),t.hasSelection?e("BulkEditing"):t._e()],2),t._v(" "),e("div",{staticClass:"controls__right"},[e("div",[e("NcActions",[e("NcActionButton",{attrs:{name:"list"===t.viewMode?t.t("bookmarks","Change to grid view"):t.t("bookmarks","Change to list view")},on:{click:t.onToggleViewMode},scopedSlots:t._u([{key:"icon",fn:function(){return["list"!==t.viewMode?e("ViewListIcon",{attrs:{size:20}}):e("ViewGridIcon",{attrs:{size:20}})]},proxy:!0}])})],1)],1),t._v(" "),e("NcActions",{directives:[{name:"tooltip",rawName:"v-tooltip",value:t.sortingOptions[t.sorting].description,expression:"sortingOptions[sorting].description"}],scopedSlots:t._u([{key:"icon",fn:function(){return[e(t.sortingOptions[t.sorting].icon,{tag:"component",attrs:{"fill-color":t.colorMainText}})]},proxy:!0}])},[t._v(" "),t._l(t.sortingOptions,function(n,o){return e("NcActionButton",{key:o,attrs:{"close-after-click":!0},on:{click:function(e){return t.onChangeSorting(o)}},scopedSlots:t._u([{key:"icon",fn:function(){return[e(n.icon,{tag:"component",attrs:{size:20,"fill-color":o===t.sorting?t.colorPrimaryElement:t.colorMainText}})]},proxy:!0}],null,!0)},[t._v("\n\t\t\t\t"+t._s(n.description)+"\n\t\t\t")])})],2),t._v(" "),t.isTrashbin?t._e():e("NcActions",{attrs:{"force-menu":""},scopedSlots:t._u([{key:"icon",fn:function(){return[e("RssIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3906975985)},[t._v(" "),e("NcActionButton",{attrs:{name:t.t("bookmarks","Copy RSS Feed of current view"),"close-after-click":!0},on:{click:t.copyRssUrl},scopedSlots:t._u([{key:"icon",fn:function(){return[e("RssIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3906975985)},[t._v("\n\t\t\t\t"+t._s(t.$store.state.public?"":t.t("bookmarks","The RSS feed requires authentication with your Nextcloud credentials"))+"\n\t\t\t")])],1),t._v(" "),t.isTrashbin?t._e():e("NcTextField",{staticClass:"inline-search",attrs:{value:t.search,label:t.t("bookmarks","Search"),placeholder:t.t("bookmarks","Search")},on:{"update:value":[function(e){t.search=e},function(e){return t.onSearch(e)}]}},[e("MagnifyIcon",{attrs:{size:20}})],1),t._v(" "),t.isTrashbinRoot?[e("NcButton",{on:{click:t.onEmptyTrashbin},scopedSlots:t._u([{key:"icon",fn:function(){return[e("DeleteForeverIcon",{attrs:{size:20}})]},proxy:!0}],null,!1,3006144741)},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","Empty trash bin"))+"\n\t\t\t")])]:t._e()],2)])},[],!1,null,null,null).exports},7643(t,e,n){"use strict";var o=n(79477),r=n(13888);(0,n(14486).A)(r.A,o.X,o.Y,!1,null,null,null).exports},13888(t,e,n){"use strict";n.d(e,{A:()=>o});const o=n(70977).A},49746(){},19977(){},197(){},21866(){},52739(){}}]);
//# sourceMappingURL=bookmarks-src_components_BookmarkContent_vue-src_components_BookmarksList_vue-src_components_Controls_vue.js.map?v=3b2599bd8b663937a0ac