// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStdFunctionTypeUInt32Array
 * @brief   std function implicit array of vtkTypeUInt32.
 *
 * vtkStdFunctionTypeUInt32Array is an affine implicit array of values of type vtkTypeUInt32.
 * see vtkStdFunctionArray, std::function<vtkTypeUInt32(int)>
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStdFunctionTypeUInt32Array_h
#define vtkStdFunctionTypeUInt32Array_h

#include "vtkStdFunctionArray.h" // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStdFunctionArray<vtkTypeUInt32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStdFunctionTypeUInt32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStdFunctionTypeUInt32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStdFunctionTypeUInt32Array* New();
  static vtkStdFunctionTypeUInt32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt32);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStdFunctionTypeUInt32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStdFunctionTypeUInt32Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the std::function to be used as backend.
   */
  void ConstructBackend(std::function<vtkTypeUInt32(int)> func);

protected:
  vtkStdFunctionTypeUInt32Array();
  ~vtkStdFunctionTypeUInt32Array() override;

private:
  typedef vtkStdFunctionArray<vtkTypeUInt32> RealSuperclass;

  vtkStdFunctionTypeUInt32Array(const vtkStdFunctionTypeUInt32Array&) = delete;
  void operator=(const vtkStdFunctionTypeUInt32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStdFunctionTypeUInt32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
