// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkStdFunctionTypeInt64Array
 * @brief   std function implicit array of vtkTypeInt64.
 *
 * vtkStdFunctionTypeInt64Array is an affine implicit array of values of type vtkTypeInt64.
 * see vtkStdFunctionArray, std::function<vtkTypeInt64(int)>
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkStdFunctionTypeInt64Array_h
#define vtkStdFunctionTypeInt64Array_h

#include "vtkStdFunctionArray.h" // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkStdFunctionArray<vtkTypeInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkStdFunctionTypeInt64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkStdFunctionTypeInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkStdFunctionTypeInt64Array* New();
  static vtkStdFunctionTypeInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkStdFunctionTypeInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkStdFunctionTypeInt64Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the std::function to be used as backend.
   */
  void ConstructBackend(std::function<vtkTypeInt64(int)> func);

protected:
  vtkStdFunctionTypeInt64Array();
  ~vtkStdFunctionTypeInt64Array() override;

private:
  typedef vtkStdFunctionArray<vtkTypeInt64> RealSuperclass;

  vtkStdFunctionTypeInt64Array(const vtkStdFunctionTypeInt64Array&) = delete;
  void operator=(const vtkStdFunctionTypeInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkStdFunctionTypeInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
