// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkScaledSOATypeInt16Array
 * @brief   scaled soa array of vtkTypeInt16.
 *
 * vtkScaledSOATypeInt16Array is a scaled soa array of values of type vtkTypeInt16.
 * see vtkScaledSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkScaledSOATypeInt16Array_h
#define vtkScaledSOATypeInt16Array_h

#include "vtkCommonCoreModule.h"           // For export macro
#include "vtkScaledSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkScaledSOADataArrayTemplate<vtkTypeInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkScaledSOATypeInt16Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkScaledSOATypeInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkScaledSOATypeInt16Array* New();
  static vtkScaledSOATypeInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkScaledSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateScaledSOAWrappedArrayInterface(vtkTypeInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkScaledSOATypeInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkScaledSOATypeInt16Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkScaledSOATypeInt16Array();
  ~vtkScaledSOATypeInt16Array() override;

private:
  typedef vtkScaledSOADataArrayTemplate<vtkTypeInt16> RealSuperclass;

  vtkScaledSOATypeInt16Array(const vtkScaledSOATypeInt16Array&) = delete;
  void operator=(const vtkScaledSOATypeInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkScaledSOATypeInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
