// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkSOATypeUInt64Array
 * @brief   soa array of vtkTypeUInt64.
 *
 * vtkSOATypeUInt64Array is a soa array of values of type vtkTypeUInt64.
 * see vtkSOADataArrayTemplate
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkSOATypeUInt64Array_h
#define vtkSOATypeUInt64Array_h

#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkSOADataArrayTemplate.h" // Real Superclass
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkSOADataArrayTemplate<vtkTypeUInt64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkSOATypeUInt64Array : public vtkDataArray
{
public:
  vtkTypeMacro(vtkSOATypeUInt64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkSOATypeUInt64Array* New();
  static vtkSOATypeUInt64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkSOADataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateSOAWrappedArrayInterface(vtkTypeUInt64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkSOATypeUInt64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkSOATypeUInt64Array*>(Superclass::FastDownCast(source));
  }

protected:
  vtkSOATypeUInt64Array();
  ~vtkSOATypeUInt64Array() override;

private:
  typedef vtkSOADataArrayTemplate<vtkTypeUInt64> RealSuperclass;

  vtkSOATypeUInt64Array(const vtkSOATypeUInt64Array&) = delete;
  void operator=(const vtkSOATypeUInt64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkSOATypeUInt64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
