// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedUnsignedIntArray
 * @brief   indexed implicit array of unsigned int.
 *
 * vtkIndexedUnsignedIntArray is an indexed implicit array of values of type unsigned int.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkIndexedUnsignedIntArray_h
#define vtkIndexedUnsignedIntArray_h

#include "vtkIndexedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<unsigned int>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkIndexedType*Array instead") vtkIndexedUnsignedIntArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedUnsignedIntArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedUnsignedIntArray* New();
  static vtkIndexedUnsignedIntArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned int);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedUnsignedIntArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedUnsignedIntArray*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedUnsignedIntArray();
  ~vtkIndexedUnsignedIntArray() override;

private:
  typedef vtkIndexedArray<unsigned int> RealSuperclass;

  vtkIndexedUnsignedIntArray(const vtkIndexedUnsignedIntArray&) = delete;
  void operator=(const vtkIndexedUnsignedIntArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedUnsignedIntArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
