// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedTypeFloat64Array
 * @brief   indexed implicit array of vtkTypeFloat64.
 *
 * vtkIndexedTypeFloat64Array is an indexed implicit array of values of type vtkTypeFloat64.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkIndexedTypeFloat64Array_h
#define vtkIndexedTypeFloat64Array_h

#include "vtkIndexedArray.h"     // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<vtkTypeFloat64>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkIndexedTypeFloat64Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedTypeFloat64Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedTypeFloat64Array* New();
  static vtkIndexedTypeFloat64Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeFloat64);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedTypeFloat64Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedTypeFloat64Array*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedTypeFloat64Array();
  ~vtkIndexedTypeFloat64Array() override;

private:
  typedef vtkIndexedArray<vtkTypeFloat64> RealSuperclass;

  vtkIndexedTypeFloat64Array(const vtkIndexedTypeFloat64Array&) = delete;
  void operator=(const vtkIndexedTypeFloat64Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedTypeFloat64Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
