// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantUnsignedIntArray
 * @brief   constant implicit array of unsigned int.
 *
 * vtkConstantUnsignedIntArray is a constant implicit array of values of type unsigned int.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantUnsignedIntArray_h
#define vtkConstantUnsignedIntArray_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<unsigned int>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkConstantType*Array instead") vtkConstantUnsignedIntArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantUnsignedIntArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(unsigned int);
#endif

  static vtkConstantUnsignedIntArray* New();
  static vtkConstantUnsignedIntArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantUnsignedIntArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantUnsignedIntArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(unsigned int value);

protected:
  vtkConstantUnsignedIntArray();
  ~vtkConstantUnsignedIntArray() override;

private:
  typedef vtkConstantArray<unsigned int> RealSuperclass;

  vtkConstantUnsignedIntArray(const vtkConstantUnsignedIntArray&) = delete;
  void operator=(const vtkConstantUnsignedIntArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantUnsignedIntArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
