// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantTypeFloat32Array
 * @brief   constant implicit array of vtkTypeFloat32.
 *
 * vtkConstantTypeFloat32Array is a constant implicit array of values of type vtkTypeFloat32.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantTypeFloat32Array_h
#define vtkConstantTypeFloat32Array_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<vtkTypeFloat32>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkConstantTypeFloat32Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantTypeFloat32Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeFloat32);
#endif

  static vtkConstantTypeFloat32Array* New();
  static vtkConstantTypeFloat32Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantTypeFloat32Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantTypeFloat32Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(vtkTypeFloat32 value);

protected:
  vtkConstantTypeFloat32Array();
  ~vtkConstantTypeFloat32Array() override;

private:
  typedef vtkConstantArray<vtkTypeFloat32> RealSuperclass;

  vtkConstantTypeFloat32Array(const vtkConstantTypeFloat32Array&) = delete;
  void operator=(const vtkConstantTypeFloat32Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantTypeFloat32Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
