// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkConstantSignedCharArray
 * @brief   constant implicit array of signed char.
 *
 * vtkConstantSignedCharArray is a constant implicit array of values of type signed char.
 * see vtkConstantArray, vtkConstantImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkConstantSignedCharArray_h
#define vtkConstantSignedCharArray_h

#include "vtkConstantArray.h"    // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkConstantArray<signed char>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkConstantType*Array instead") vtkConstantSignedCharArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkConstantSignedCharArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  // This macro expands to the set of method declarations that
  // make up the interface of vtkAOSDataArrayTemplate, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(signed char);
#endif

  static vtkConstantSignedCharArray* New();
  static vtkConstantSignedCharArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkConstantSignedCharArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkConstantSignedCharArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the constant value for this array.
   */
  void ConstructBackend(signed char value);

protected:
  vtkConstantSignedCharArray();
  ~vtkConstantSignedCharArray() override;

private:
  typedef vtkConstantArray<signed char> RealSuperclass;

  vtkConstantSignedCharArray(const vtkConstantSignedCharArray&) = delete;
  void operator=(const vtkConstantSignedCharArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkConstantSignedCharArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
