// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeFloatArray
 * @brief   composite implicit array of float.
 *
 * vtkCompositeFloatArray is a composite implicit array of values of type float.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkCompositeFloatArray_h
#define vtkCompositeFloatArray_h

#include "vtkCompositeArray.h"   // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<float>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkCompositeType*Array instead") vtkCompositeFloatArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeFloatArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeFloatArray* New();
  static vtkCompositeFloatArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(float);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeFloatArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeFloatArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeFloatArray();
  ~vtkCompositeFloatArray() override;

private:
  typedef vtkCompositeArray<float> RealSuperclass;

  vtkCompositeFloatArray(const vtkCompositeFloatArray&) = delete;
  void operator=(const vtkCompositeFloatArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeFloatArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
