// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkCompositeDoubleArray
 * @brief   composite implicit array of double.
 *
 * vtkCompositeDoubleArray is a composite implicit array of values of type double.
 * see vtkCompositeArray, vtkCompositeImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkCompositeDoubleArray_h
#define vtkCompositeDoubleArray_h

#include "vtkCompositeArray.h"   // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkCompositeArray<double>
#endif
VTK_ABI_NAMESPACE_BEGIN
class vtkDataArrayCollection;

class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkCompositeType*Array instead") vtkCompositeDoubleArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkCompositeDoubleArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkCompositeDoubleArray* New();
  static vtkCompositeDoubleArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(double);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkCompositeDoubleArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkCompositeDoubleArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the underlying arrays to use.
   */
  void ConstructBackend(vtkDataArrayCollection* arrays);

protected:
  vtkCompositeDoubleArray();
  ~vtkCompositeDoubleArray() override;

private:
  typedef vtkCompositeArray<double> RealSuperclass;

  vtkCompositeDoubleArray(const vtkCompositeDoubleArray&) = delete;
  void operator=(const vtkCompositeDoubleArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkCompositeDoubleArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
