// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAffineTypeUInt16Array
 * @brief   affine implicit array of vtkTypeUInt16.
 *
 * vtkAffineTypeUInt16Array is an affine implicit array of values of type vtkTypeUInt16.
 * see vtkAffineArray, vtkAffineImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkAffineTypeUInt16Array_h
#define vtkAffineTypeUInt16Array_h

#include "vtkAffineArray.h"      // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkAffineArray<vtkTypeUInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkAffineTypeUInt16Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkAffineTypeUInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkAffineTypeUInt16Array* New();
  static vtkAffineTypeUInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeUInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkAffineTypeUInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkAffineTypeUInt16Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the parameters for the affine backend.
   * slope is the unit variation and intercept is the value at 0.
   * Value at index is:
   *   value = slope * index + intercept
   */
  void ConstructBackend(vtkTypeUInt16 slope, vtkTypeUInt16 intercept);

protected:
  vtkAffineTypeUInt16Array();
  ~vtkAffineTypeUInt16Array() override;

private:
  typedef vtkAffineArray<vtkTypeUInt16> RealSuperclass;

  vtkAffineTypeUInt16Array(const vtkAffineTypeUInt16Array&) = delete;
  void operator=(const vtkAffineTypeUInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkAffineTypeUInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
