// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAffineTypeInt16Array
 * @brief   affine implicit array of vtkTypeInt16.
 *
 * vtkAffineTypeInt16Array is an affine implicit array of values of type vtkTypeInt16.
 * see vtkAffineArray, vtkAffineImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkAffineTypeInt16Array_h
#define vtkAffineTypeInt16Array_h

#include "vtkAffineArray.h"      // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkAffineArray<vtkTypeInt16>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT  vtkAffineTypeInt16Array : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkAffineTypeInt16Array, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkAffineTypeInt16Array* New();
  static vtkAffineTypeInt16Array* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(vtkTypeInt16);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkAffineTypeInt16Array* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkAffineTypeInt16Array*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the parameters for the affine backend.
   * slope is the unit variation and intercept is the value at 0.
   * Value at index is:
   *   value = slope * index + intercept
   */
  void ConstructBackend(vtkTypeInt16 slope, vtkTypeInt16 intercept);

protected:
  vtkAffineTypeInt16Array();
  ~vtkAffineTypeInt16Array() override;

private:
  typedef vtkAffineArray<vtkTypeInt16> RealSuperclass;

  vtkAffineTypeInt16Array(const vtkAffineTypeInt16Array&) = delete;
  void operator=(const vtkAffineTypeInt16Array&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkAffineTypeInt16Array);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
