// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkAffineCharArray
 * @brief   affine implicit array of char.
 *
 * vtkAffineCharArray is an affine implicit array of values of type char.
 * see vtkAffineArray, vtkAffineImplicitBackend
 *
 * This file is generated by vtkTypeArrays.cmake
 */

#ifndef vtkAffineCharArray_h
#define vtkAffineCharArray_h

#include "vtkAffineArray.h"      // Real Superclass
#include "vtkCommonCoreModule.h" // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkAffineArray<char>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT VTK_DEPRECATED_IN_9_6_0("Use vtkAffineType*Array instead") vtkAffineCharArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkAffineCharArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkAffineCharArray* New();
  static vtkAffineCharArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(char);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkAffineCharArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkAffineCharArray*>(Superclass::FastDownCast(source));
  }

  /**
   * Set the parameters for the affine backend.
   * slope is the unit variation and intercept is the value at 0.
   * Value at index is:
   *   value = slope * index + intercept
   */
  void ConstructBackend(char slope, char intercept);

protected:
  vtkAffineCharArray();
  ~vtkAffineCharArray() override;

private:
  typedef vtkAffineArray<char> RealSuperclass;

  vtkAffineCharArray(const vtkAffineCharArray&) = delete;
  void operator=(const vtkAffineCharArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkAffineCharArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
