/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.FixedSizeItemsBlock;

class TimeColumn
extends AbstractColumn {
    TimeColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 48;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        FixedSizeItemsBlock data = new FixedSizeItemsBlock().read(buffer, offset);
        offset = data.getOffset();
        Calendar cal = DateHelper.popCalendar();
        byte[][] rawData = data.getData();
        this.m_data = new Date[rawData.length];
        for (int index = 0; index < rawData.length; ++index) {
            if (rawData[index].length <= 1) continue;
            int value = FastTrackUtility.getShort(rawData[index], 0);
            cal.set(11, value / 60);
            cal.set(12, value % 60);
            cal.set(13, 0);
            cal.set(14, 0);
            this.m_data[index] = cal.getTime();
        }
        DateHelper.pushCalendar(cal);
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        pw.println("  [Data");
        for (Object item : this.m_data) {
            pw.println("    " + df.format((Date)item));
        }
        pw.println("  ]");
    }
}

