/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class StringContentProposalProvider
implements IContentProposalProvider {
    private String[] proposals;
    private String possibleChars;
    private boolean constrainProposalList;
    private boolean stopPropose;

    public StringContentProposalProvider() {
    }

    public StringContentProposalProvider(String ... proposals) {
        this.setProposals(proposals);
    }

    public StringContentProposalProvider(boolean constrainProposalList, String ... proposals) {
        this.setProposals(proposals);
        this.constrainProposalList = constrainProposalList;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (this.stopPropose && position < 2) {
            this.stopPropose = false;
        }
        ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
        int startPos = 0;
        for (int i = position - 1; i >= 0; --i) {
            char ch = Character.toUpperCase(contents.charAt(i));
            if (Character.isLetterOrDigit(ch) || this.possibleChars.indexOf(ch) != -1) continue;
            startPos = i + 1;
            break;
        }
        Character lastChar = null;
        if (contents.length() > 0) {
            lastChar = Character.valueOf(contents.charAt(contents.length() - 1));
        }
        if (lastChar != null && !Character.isLetterOrDigit(lastChar.charValue()) && lastChar.charValue() != '_' && lastChar.charValue() != '.' && lastChar.charValue() != ' ' && this.constrainProposalList) {
            this.stopPropose = true;
            return new IContentProposal[0];
        }
        if (this.stopPropose && position > 1) {
            return new IContentProposal[0];
        }
        String word = contents.substring(startPos, position);
        for (String proposal : this.proposals) {
            if (proposal.length() < word.length() || !proposal.substring(0, word.length()).equalsIgnoreCase(word)) continue;
            list.add(new ContentProposal(proposal));
        }
        return list.toArray(new IContentProposal[0]);
    }

    public void setProposals(String[] items) {
        this.proposals = items;
        StringBuilder allChars = new StringBuilder();
        for (String prop : this.proposals) {
            for (char c : prop.toCharArray()) {
                if (allChars.indexOf(String.valueOf(c = Character.toUpperCase(c))) != -1) continue;
                allChars.append(c);
            }
        }
        this.possibleChars = allChars.toString();
    }
}

