/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.stickyscroll.DefaultStickyLinesProvider;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyLinesProviderDescriptor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLinesProvider;

public class StickyLinesProviderRegistry {
    public static final String STICKY_LINES_PROVIDERS_EXTENSION_POINT = "stickyLinesProviders";
    private StickyLinesProviderDescriptor[] fDescriptors;
    private boolean fLoaded = false;
    private final IExtensionRegistry fExtensionRegistry;
    private final StickyLinesProviderDescriptorFactory descriptorFactory;

    public StickyLinesProviderRegistry() {
        this(Platform.getExtensionRegistry(), element -> new StickyLinesProviderDescriptor(element));
    }

    public StickyLinesProviderRegistry(IExtensionRegistry extensionRegistry, StickyLinesProviderDescriptorFactory StickyLinesProviderDescriptorFactory2) {
        this.fExtensionRegistry = extensionRegistry;
        this.descriptorFactory = StickyLinesProviderDescriptorFactory2;
    }

    public IStickyLinesProvider getProvider(ISourceViewer viewer, ITextEditor editor) {
        StickyLinesProviderDescriptor[] stickyLinesProviderDescriptorArray = this.getDescriptors();
        int n = stickyLinesProviderDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStickyLinesProvider provider;
            StickyLinesProviderDescriptor descriptor = stickyLinesProviderDescriptorArray[n2];
            if (descriptor.matches(viewer, editor) && (provider = descriptor.createStickyLinesProvider()) != null) {
                return provider;
            }
            ++n2;
        }
        return new DefaultStickyLinesProvider();
    }

    private StickyLinesProviderDescriptor[] getDescriptors() {
        this.ensureExtensionsLoaded();
        return this.fDescriptors;
    }

    public synchronized void reloadExtensions() {
        IConfigurationElement[] elements;
        ArrayList<StickyLinesProviderDescriptor> descriptors = new ArrayList<StickyLinesProviderDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements = this.fExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.editors", STICKY_LINES_PROVIDERS_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                StickyLinesProviderDescriptor descriptor = this.descriptorFactory.create(element);
                descriptors.add(descriptor);
            }
            catch (CoreException e) {
                EditorsPlugin.getDefault().getLog().log((IStatus)new Status(4, element.getNamespaceIdentifier(), e.getMessage()));
            }
            ++n2;
        }
        this.fDescriptors = (StickyLinesProviderDescriptor[])descriptors.toArray(StickyLinesProviderDescriptor[]::new);
        this.fLoaded = true;
    }

    private void ensureExtensionsLoaded() {
        if (!this.fLoaded) {
            this.reloadExtensions();
        }
    }

    public static interface StickyLinesProviderDescriptorFactory {
        public StickyLinesProviderDescriptor create(IConfigurationElement var1) throws CoreException;
    }
}

