/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import vtk.vtkActor;
import vtk.vtkAlgorithmOutput;
import vtk.vtkCanvas;
import vtk.vtkCellPicker;
import vtk.vtkImageData;
import vtk.vtkImagePlaneWidget;
import vtk.vtkNativeLibrary;
import vtk.vtkOutlineFilter;
import vtk.vtkPolyDataMapper;
import vtk.vtkVolume16Reader;

public class ImagePlaneWidget
extends vtkCanvas {
    private static final long serialVersionUID = 1L;
    private int width = 512;
    private int height = 512;

    public ImagePlaneWidget(String string) {
        vtkVolume16Reader vtkVolume16Reader2 = new vtkVolume16Reader();
        vtkVolume16Reader2.SetDataDimensions(64, 64);
        vtkVolume16Reader2.SetDataByteOrderToLittleEndian();
        vtkVolume16Reader2.SetFilePrefix(string);
        vtkVolume16Reader2.SetImageRange(1, 93);
        vtkVolume16Reader2.SetDataSpacing(3.2, 3.2, 1.5);
        vtkVolume16Reader2.Update();
        this.setImageData(vtkVolume16Reader2.GetOutput(), vtkVolume16Reader2.GetOutputPort());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this, "Center");
        JFrame jFrame = new JFrame("ImagePlaneWidget Test");
        jFrame.setBounds(10, 10, this.width, this.height);
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jFrame.setVisible(true);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
    }

    public void setImageData(vtkImageData vtkImageData2, vtkAlgorithmOutput vtkAlgorithmOutput2) {
        vtkCellPicker vtkCellPicker2 = new vtkCellPicker();
        vtkCellPicker2.SetTolerance(0.005);
        vtkImagePlaneWidget vtkImagePlaneWidget2 = new vtkImagePlaneWidget();
        vtkImagePlaneWidget2.DisplayTextOn();
        vtkImagePlaneWidget2.SetInputData(vtkImageData2);
        vtkImagePlaneWidget2.SetInteractor(this.getRenderWindowInteractor());
        vtkImagePlaneWidget2.SetPlaneOrientationToXAxes();
        vtkImagePlaneWidget2.SetSliceIndex(32);
        vtkImagePlaneWidget2.SetPicker(vtkCellPicker2);
        vtkImagePlaneWidget2.SetKeyPressActivationValue('x');
        vtkImagePlaneWidget2.GetPlaneProperty().SetColor(1.0, 0.0, 0.0);
        vtkImagePlaneWidget2.On();
        vtkImagePlaneWidget vtkImagePlaneWidget3 = new vtkImagePlaneWidget();
        vtkImagePlaneWidget3.DisplayTextOn();
        vtkImagePlaneWidget3.SetInputData(vtkImageData2);
        vtkImagePlaneWidget3.SetInteractor(this.getRenderWindowInteractor());
        vtkImagePlaneWidget3.SetPlaneOrientationToYAxes();
        vtkImagePlaneWidget3.SetSliceIndex(32);
        vtkImagePlaneWidget3.SetPicker(vtkCellPicker2);
        vtkImagePlaneWidget3.SetKeyPressActivationValue('y');
        vtkImagePlaneWidget3.GetPlaneProperty().SetColor(1.0, 1.0, 0.0);
        vtkImagePlaneWidget3.SetLookupTable(vtkImagePlaneWidget2.GetLookupTable());
        vtkImagePlaneWidget3.On();
        vtkImagePlaneWidget vtkImagePlaneWidget4 = new vtkImagePlaneWidget();
        vtkImagePlaneWidget4.DisplayTextOn();
        vtkImagePlaneWidget4.SetInputData(vtkImageData2);
        vtkImagePlaneWidget4.TextureInterpolateOff();
        vtkImagePlaneWidget4.SetInteractor(this.getRenderWindowInteractor());
        vtkImagePlaneWidget4.SetPlaneOrientationToZAxes();
        vtkImagePlaneWidget4.SetSliceIndex(46);
        vtkImagePlaneWidget4.SetPicker(vtkCellPicker2);
        vtkImagePlaneWidget4.SetKeyPressActivationValue('z');
        vtkImagePlaneWidget4.GetPlaneProperty().SetColor(0.0, 0.0, 1.0);
        vtkImagePlaneWidget4.SetLookupTable(vtkImagePlaneWidget2.GetLookupTable());
        vtkImagePlaneWidget4.On();
        vtkOutlineFilter vtkOutlineFilter2 = new vtkOutlineFilter();
        vtkOutlineFilter2.SetInputConnection(vtkAlgorithmOutput2);
        vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
        vtkPolyDataMapper2.SetInputConnection(vtkOutlineFilter2.GetOutputPort());
        vtkActor vtkActor2 = new vtkActor();
        vtkActor2.SetMapper(vtkPolyDataMapper2);
        this.GetRenderer().AddActor(vtkActor2);
        this.GetRenderer().GetCullers().RemoveAllItems();
        this.GetRenderer().SetBackground(0.1, 0.1, 0.2);
    }

    public static void printUsage(String string) {
        if (!string.equals("")) {
            System.err.println("Error: " + string);
        }
        System.err.println("Usage: java ImagePlaneWidget [-D path]");
        System.err.println("Where:");
        System.err.println("      path is location of your VTKData directory");
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        File file;
        int n = stringArray.length;
        String string = "";
        int n2 = 0;
        try {
            while (n > n2) {
                if (stringArray[n2].equals("-D")) {
                    string = stringArray[++n2];
                    ++n2;
                    continue;
                }
                ImagePlaneWidget.printUsage("");
            }
        }
        catch (Exception exception) {
            ImagePlaneWidget.printUsage("");
        }
        if (string.equals("")) {
            ImagePlaneWidget.printUsage("");
        }
        if (!((file = new File(string + "/Data/headsq")).exists() && file.canRead() && file.isDirectory())) {
            ImagePlaneWidget.printUsage(file.getAbsolutePath() + " does not exist or cannot be read.");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ImagePlaneWidget(file.getAbsolutePath() + "/quarter");
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
                if (vtkNativeLibrary2.IsLoaded()) continue;
                System.out.println(vtkNativeLibrary2.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }
}

