/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.cpdsadapter;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.Jdbc41Bridge;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.PoolableCallableStatement;
import org.apache.tomcat.dbcp.dbcp2.PoolablePreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.cpdsadapter.ConnectionImpl;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

final class PooledConnectionImpl
implements PooledConnection,
KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    private static final String CLOSED = "Attempted to use PooledConnection after closed() was called.";
    private Connection connection;
    private final DelegatingConnection<?> delegatingConnection;
    private Connection logicalConnection;
    private final List<ConnectionEventListener> eventListeners;
    private final List<StatementEventListener> statementEventListeners = Collections.synchronizedList(new ArrayList());
    private boolean closed;
    private KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pStmtPool;
    private boolean accessToUnderlyingConnectionAllowed;

    PooledConnectionImpl(Connection connection) {
        this.connection = connection;
        this.delegatingConnection = connection instanceof DelegatingConnection ? (DelegatingConnection<Object>)connection : new DelegatingConnection<Connection>(connection);
        this.eventListeners = Collections.synchronizedList(new ArrayList());
        this.closed = false;
    }

    @Override
    public void activateObject(PStmtKey pStmtKey, PooledObject<DelegatingPreparedStatement> pooledObject) throws SQLException {
        pooledObject.getObject().activate();
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (!this.eventListeners.contains(connectionEventListener)) {
            this.eventListeners.add(connectionEventListener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (!this.statementEventListeners.contains(statementEventListener)) {
            this.statementEventListeners.add(statementEventListener);
        }
    }

    private void assertOpen() throws SQLException {
        if (this.closed || this.connection == null) {
            throw new SQLException(CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block14: {
            this.assertOpen();
            this.closed = true;
            try {
                if (this.pStmtPool == null) break block14;
                try {
                    this.pStmtPool.close();
                }
                finally {
                    this.pStmtPool = null;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLException("Cannot close connection (return to pool failed)", exception);
            }
            finally {
                try {
                    this.connection.close();
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    protected PStmtKey createKey(String string) {
        return new PStmtKey(string, this.getCatalogOrNull(), this.getSchemaOrNull());
    }

    protected PStmtKey createKey(String string, int n) {
        return new PStmtKey(string, this.getCatalogOrNull(), this.getSchemaOrNull(), n);
    }

    protected PStmtKey createKey(String string, int n, int n2) {
        return new PStmtKey(string, this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2);
    }

    protected PStmtKey createKey(String string, int n, int n2, int n3) {
        return new PStmtKey(string, this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, n3);
    }

    protected PStmtKey createKey(String string, int n, int n2, int n3, PoolingConnection.StatementType statementType) {
        return new PStmtKey(string, this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, n3, statementType);
    }

    protected PStmtKey createKey(String string, int n, int n2, PoolingConnection.StatementType statementType) {
        return new PStmtKey(string, this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, statementType);
    }

    protected PStmtKey createKey(String string, int[] nArray) {
        return new PStmtKey(string, this.getCatalogOrNull(), this.getSchemaOrNull(), nArray);
    }

    protected PStmtKey createKey(String string, PoolingConnection.StatementType statementType) {
        return new PStmtKey(string, this.getCatalogOrNull(), this.getSchemaOrNull(), statementType);
    }

    protected PStmtKey createKey(String string, String[] stringArray) {
        return new PStmtKey(string, this.getCatalogOrNull(), this.getSchemaOrNull(), stringArray);
    }

    @Override
    public void destroyObject(PStmtKey pStmtKey, PooledObject<DelegatingPreparedStatement> pooledObject) throws SQLException {
        Statement statement;
        DelegatingPreparedStatement delegatingPreparedStatement;
        if (pooledObject != null && (delegatingPreparedStatement = pooledObject.getObject()) != null && (statement = delegatingPreparedStatement.getInnermostDelegate()) != null) {
            statement.close();
        }
    }

    protected void finalize() throws Throwable {
        Utils.close(this.connection, null);
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was gc'ed, without its last Connection being closed.");
        }
    }

    private String getCatalogOrNull() {
        try {
            return this.connection == null ? null : this.connection.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.assertOpen();
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was reused, without its previous Connection being closed.");
        }
        this.logicalConnection = new ConnectionImpl(this, this.connection, this.isAccessToUnderlyingConnectionAllowed());
        return this.logicalConnection;
    }

    private Connection getRawConnection() throws SQLException {
        this.assertOpen();
        return this.connection;
    }

    private String getSchemaOrNull() {
        try {
            return this.connection == null ? null : Jdbc41Bridge.getSchema(this.connection);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public PooledObject<DelegatingPreparedStatement> makeObject(PStmtKey pStmtKey) throws SQLException {
        if (null == pStmtKey) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        if (pStmtKey.getStmtType() == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            PreparedStatement preparedStatement = (PreparedStatement)pStmtKey.createStatement(this.connection);
            PoolablePreparedStatement<PStmtKey> poolablePreparedStatement = new PoolablePreparedStatement<PStmtKey>(preparedStatement, pStmtKey, this.pStmtPool, this.delegatingConnection);
            return new DefaultPooledObject<DelegatingPreparedStatement>(poolablePreparedStatement);
        }
        CallableStatement callableStatement = (CallableStatement)pStmtKey.createStatement(this.connection);
        PoolableCallableStatement poolableCallableStatement = new PoolableCallableStatement(callableStatement, pStmtKey, this.pStmtPool, this.delegatingConnection);
        return new DefaultPooledObject<DelegatingPreparedStatement>(poolableCallableStatement);
    }

    void notifyListeners() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        new ArrayList<ConnectionEventListener>(this.eventListeners).forEach(connectionEventListener -> connectionEventListener.connectionClosed(connectionEvent));
    }

    @Override
    public void passivateObject(PStmtKey pStmtKey, PooledObject<DelegatingPreparedStatement> pooledObject) throws SQLException {
        DelegatingPreparedStatement delegatingPreparedStatement = pooledObject.getObject();
        delegatingPreparedStatement.clearParameters();
        delegatingPreparedStatement.passivate();
    }

    CallableStatement prepareCall(String string) throws SQLException {
        if (this.pStmtPool == null) {
            return this.getRawConnection().prepareCall(string);
        }
        try {
            return (CallableStatement)((Object)this.pStmtPool.borrowObject(this.createKey(string, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareCall from pool failed", exception);
        }
    }

    CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.pStmtPool == null) {
            return this.getRawConnection().prepareCall(string, n, n2);
        }
        try {
            return (CallableStatement)((Object)this.pStmtPool.borrowObject(this.createKey(string, n, n2, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareCall from pool failed", exception);
        }
    }

    CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (this.pStmtPool == null) {
            return this.getRawConnection().prepareCall(string, n, n2, n3);
        }
        try {
            return (CallableStatement)((Object)this.pStmtPool.borrowObject(this.createKey(string, n, n2, n3, PoolingConnection.StatementType.CALLABLE_STATEMENT)));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareCall from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.pStmtPool == null) {
            return this.getRawConnection().prepareStatement(string);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(string));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.pStmtPool == null) {
            return this.getRawConnection().prepareStatement(string, n);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(string, n));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.pStmtPool == null) {
            return this.getRawConnection().prepareStatement(string, n, n2);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(string, n, n2));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.pStmtPool == null) {
            return this.getRawConnection().prepareStatement(string, n, n2, n3);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(string, n, n2, n3));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.pStmtPool == null) {
            return this.getRawConnection().prepareStatement(string, nArray);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(string, nArray));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.pStmtPool == null) {
            return this.getRawConnection().prepareStatement(string, stringArray);
        }
        try {
            return this.pStmtPool.borrowObject(this.createKey(string, stringArray));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.eventListeners.remove(connectionEventListener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        this.statementEventListeners.remove(statementEventListener);
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    public void setStatementPool(KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> keyedObjectPool) {
        this.pStmtPool = keyedObjectPool;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("[connection=");
        stringBuilder.append(this.connection);
        stringBuilder.append(", delegatingConnection=");
        stringBuilder.append(this.delegatingConnection);
        stringBuilder.append(", logicalConnection=");
        stringBuilder.append(this.logicalConnection);
        stringBuilder.append(", eventListeners=");
        stringBuilder.append(this.eventListeners);
        stringBuilder.append(", statementEventListeners=");
        stringBuilder.append(this.statementEventListeners);
        stringBuilder.append(", closed=");
        stringBuilder.append(this.closed);
        stringBuilder.append(", pStmtPool=");
        stringBuilder.append(this.pStmtPool);
        stringBuilder.append(", accessToUnderlyingConnectionAllowed=");
        stringBuilder.append(this.accessToUnderlyingConnectionAllowed);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public boolean validateObject(PStmtKey pStmtKey, PooledObject<DelegatingPreparedStatement> pooledObject) {
        return true;
    }
}

