/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.catalina.startup.Bootstrap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CatalinaProperties {
    private static final Log log = LogFactory.getLog(CatalinaProperties.class);
    private static Properties properties = null;

    public static String getProperty(String string) {
        return properties.getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        Object object;
        Object object2;
        Enumeration<?> enumeration;
        InputStream inputStream = null;
        String string = "catalina.properties";
        try {
            enumeration = System.getProperty("catalina.config");
            if (enumeration != null) {
                if (((String)((Object)enumeration)).indexOf(47) == -1) {
                    string = enumeration;
                } else {
                    inputStream = new URI((String)((Object)enumeration)).toURL().openStream();
                }
            }
        }
        catch (Throwable throwable) {
            CatalinaProperties.handleThrowable(throwable);
        }
        if (inputStream == null) {
            try {
                enumeration = new File(Bootstrap.getCatalinaBase());
                object2 = new File((File)((Object)enumeration), "conf");
                object = new File((File)object2, string);
                inputStream = new FileInputStream((File)object);
            }
            catch (Throwable throwable) {
                CatalinaProperties.handleThrowable(throwable);
            }
        }
        if (inputStream == null) {
            try {
                inputStream = CatalinaProperties.class.getResourceAsStream("/org/apache/catalina/startup/catalina.properties");
            }
            catch (Throwable throwable) {
                CatalinaProperties.handleThrowable(throwable);
            }
        }
        if (inputStream != null) {
            try {
                properties = new Properties();
                properties.load(inputStream);
            }
            catch (Throwable throwable) {
                CatalinaProperties.handleThrowable(throwable);
                log.warn((Object)throwable.getMessage(), throwable);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.warn((Object)"Could not close catalina properties file", (Throwable)iOException);
                }
            }
        }
        if (inputStream == null) {
            log.warn((Object)"Failed to load catalina properties file");
            properties = new Properties();
        }
        enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = properties.getProperty((String)object2);
            if (object == null) continue;
            System.setProperty((String)object2, (String)object);
        }
    }

    private static void handleThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    static {
        CatalinaProperties.loadProperties();
    }
}

