/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.Token;

public final class BooleanTokenExpression
extends Token {
    private static final Logger logger = LoggerFactory.getLogger(BooleanTokenExpression.class);
    private static final long serialVersionUID = 7003426193298054476L;

    public BooleanTokenExpression(String value) {
        super(Boolean.valueOf(value));
    }

    public BooleanTokenExpression(Boolean value) {
        super(value);
    }

    static BooleanTokenExpression parseBooleanTokenExpression(String input) {
        if ("true".equalsIgnoreCase(input) || "false".equalsIgnoreCase(input)) {
            return new BooleanTokenExpression(input);
        }
        return null;
    }

    static Object executeBooleanTokenExpression(IExpressionContext context, BooleanTokenExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating boolean token: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }
}

