/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.introduce;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.refactoring.PyReplaceExpressionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceValidator {
    private final NamesValidator myNamesValidator = LanguageNamesValidation.INSTANCE.forLanguage((Language)PythonLanguage.getInstance());

    public boolean isNameValid(String name, Project project) {
        return name != null && this.myNamesValidator.isIdentifier(name, project) && !this.myNamesValidator.isKeyword(name, project);
    }

    public boolean checkPossibleName(@NotNull String name, @NotNull PyExpression expression) {
        if (name == null) {
            IntroduceValidator.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            IntroduceValidator.$$$reportNull$$$0(1);
        }
        return this.check(name, (PsiElement)expression) == null;
    }

    @Nullable
    public abstract String check(String var1, PsiElement var2);

    public static boolean isDefinedInScope(String name, PsiElement psiElement) {
        PsiElement context;
        if (psiElement.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE) != null) {
            Pair data = (Pair)psiElement.getUserData(PyReplaceExpressionUtil.SELECTION_BREAKS_AST_NODE);
            psiElement = (PsiElement)data.first;
        }
        if ((context = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyFunction.class)) == null) {
            context = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyClass.class);
        }
        if (context == null) {
            context = psiElement.getContainingFile();
        }
        return PyUtil.collectUsedNames(context).contains(name) || PyBuiltinCache.getInstance(psiElement).getByName(name) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/refactoring/introduce/IntroduceValidator";
        objectArray[2] = "checkPossibleName";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

