/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Triple;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.hasher.PasswordHasher;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.securityconf.Hashed;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.support.SecurityJsonNode;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class AccountApiAction
extends AbstractApiAction {
    private final PasswordHasher passwordHasher;
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/account"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/account")));
    private static final List<RestHandler.DeprecatedRoute> deprecatedRoutes = Utils.addLegacyRoutesPrefix((List<RestHandler.DeprecatedRoute>)ImmutableList.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/account", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead."), (Object)new RestHandler.DeprecatedRoute(RestRequest.Method.PUT, "/account", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead.")));

    public AccountApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies, PasswordHasher passwordHasher) {
        super(Endpoint.ACCOUNT, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(this::accountApiRequestHandlers);
        this.passwordHasher = passwordHasher;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return deprecatedRoutes;
    }

    @Override
    protected CType<?> getConfigType() {
        return CType.INTERNALUSERS;
    }

    private void accountApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.allMethodsNotImplemented().override(RestRequest.Method.GET, (channel, request, client) -> this.withUserAndRemoteAddress().map(userAndRemoteAddress -> this.loadConfiguration(this.getConfigType(), false, false).map(configuration -> ValidationResult.success(Triple.of((Object)((User)userAndRemoteAddress.getLeft()), (Object)((TransportAddress)userAndRemoteAddress.getRight()), (Object)configuration)))).valid(userRemoteAddressAndConfig -> {
            User user = (User)userRemoteAddressAndConfig.getLeft();
            TransportAddress remoteAddress = (TransportAddress)userRemoteAddressAndConfig.getMiddle();
            SecurityDynamicConfiguration configuration = (SecurityDynamicConfiguration)userRemoteAddressAndConfig.getRight();
            this.userAccount(channel, user, remoteAddress, configuration);
        }).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)))).onChangeRequest(RestRequest.Method.PUT, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.withUserAndRemoteAddress().map(userAndRemoteAddress -> this.loadConfigurationWithRequestContent(((User)userAndRemoteAddress.getLeft()).getName(), (RestRequest)request)).map(this.endpointValidator::entityExists).map(this.endpointValidator::onConfigChange).map(this::validCurrentPassword).map(this::updatePassword)));
    }

    private void userAccount(RestChannel channel, User user, TransportAddress remoteAddress, SecurityDynamicConfiguration<?> configuration) {
        PrivilegesEvaluationContext context = this.securityApiDependencies.privilegesEvaluator().createContext(user, null);
        Responses.ok(channel, (builder, params) -> builder.startObject().field("user_name", user.getName()).field("is_reserved", configuration.isReserved(user.getName())).field("is_hidden", configuration.isHidden(user.getName())).field("is_internal_user", configuration.exists(user.getName())).field("user_requested_tenant", user.getRequestedTenant()).field("backend_roles", user.getRoles()).field("custom_attribute_names", (Iterable)user.getCustomAttributesMap().keySet()).field("tenants", this.securityApiDependencies.privilegesEvaluator().tenantPrivileges().tenantMap(context)).field("roles", context.getMappedRoles()).endObject());
    }

    ValidationResult<SecurityConfiguration> validCurrentPassword(SecurityConfiguration securityConfiguration) {
        String username = securityConfiguration.entityName();
        JsonNode content = securityConfiguration.requestContent();
        String currentPassword = content.get("current_password").asText();
        Hashed internalUserEntry = (Hashed)securityConfiguration.configuration().getCEntry(username);
        String currentHash = internalUserEntry.getHash();
        if (currentHash == null || !this.passwordHasher.check(currentPassword.toCharArray(), currentHash)) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Could not validate your current password."));
        }
        return ValidationResult.success(securityConfiguration);
    }

    ValidationResult<SecurityConfiguration> updatePassword(SecurityConfiguration securityConfiguration) {
        String username = securityConfiguration.entityName();
        SecurityJsonNode securityJsonNode = new SecurityJsonNode(securityConfiguration.requestContent());
        Hashed internalUserEntry = (Hashed)securityConfiguration.configuration().getCEntry(username);
        String password = securityJsonNode.get("password").asString();
        String hash = Strings.isNullOrEmpty((String)password) ? securityJsonNode.get("hash").asString() : this.passwordHasher.hash(password.toCharArray());
        if (Strings.isNullOrEmpty((String)hash)) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Both provided password and hash cannot be null/empty."));
        }
        internalUserEntry.setHash(hash);
        return ValidationResult.success(securityConfiguration);
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return AccountApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return AccountApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public RequestContentValidator createRequestContentValidator(Object ... params) {
                final User user = (User)AccountApiAction.this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return new Object[]{user.getName()};
                    }

                    @Override
                    public Settings settings() {
                        return AccountApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Set<String> mandatoryKeys() {
                        return ImmutableSet.of((Object)"current_password");
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return ImmutableMap.of((Object)"hash", (Object)((Object)RequestContentValidator.DataType.STRING), (Object)"password", (Object)((Object)RequestContentValidator.DataType.STRING), (Object)"current_password", (Object)((Object)RequestContentValidator.DataType.STRING));
                    }
                });
            }
        };
    }
}

