/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;

public class KeyAgreementProcessorRegistry {
    @Nonnull
    private Map<String, KeyAgreementProcessor> processors = new HashMap<String, KeyAgreementProcessor>();

    public void register(@Nonnull KeyAgreementProcessor processor) {
        Constraint.isNotNull(processor, "KeyAgreementProcessor was null");
        Constraint.isNotNull(processor.getAlgorithm(), "KeyAgreementProcessor algorithm was null");
        this.processors.put(processor.getAlgorithm(), processor);
    }

    public void deregister(@Nonnull String algorithm) {
        String alg = Constraint.isNotNull(StringSupport.trimOrNull(algorithm), "KeyAgreementProcessor algorithm was null or empty");
        this.processors.remove(alg);
    }

    public void clear() {
        this.processors.clear();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getRegisteredAlgorithms() {
        return CollectionSupport.copyToSet(this.processors.keySet());
    }

    @Nullable
    public KeyAgreementProcessor getProcessor(@Nonnull String algorithm) {
        String alg = Constraint.isNotNull(StringSupport.trimOrNull(algorithm), "KeyAgreementProcessor algorithm was null or empty");
        return this.processors.get(alg);
    }
}

