/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sequence;

import com.oracle.labs.mlrg.olcut.config.ConfigurationManager;
import com.oracle.labs.mlrg.olcut.config.Option;
import com.oracle.labs.mlrg.olcut.config.Options;
import com.oracle.labs.mlrg.olcut.config.UsageException;
import com.oracle.labs.mlrg.olcut.util.LabsLogFormatter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.tribuo.classification.Label;
import org.tribuo.classification.sequence.LabelSequenceEvaluation;
import org.tribuo.classification.sequence.LabelSequenceEvaluator;
import org.tribuo.classification.sequence.example.SequenceDataGenerator;
import org.tribuo.sequence.SequenceDataset;
import org.tribuo.sequence.SequenceTrainer;
import org.tribuo.util.Util;

public class SeqTrainTest {
    private static final Logger logger = Logger.getLogger(SeqTrainTest.class.getName());

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws ClassNotFoundException, IOException {
        LabsLogFormatter.setAllLogFormatters();
        o = new SeqTrainTestOptions();
        try {
            cm = new ConfigurationManager(args, (Options)o);
        }
        catch (UsageException e) {
            SeqTrainTest.logger.info(e.getMessage());
            return;
        }
        var5_5 = o.datasetName;
        var6_7 = -1;
        switch (var5_5.hashCode()) {
            case 1874604354: {
                if (!var5_5.equals("Gorilla")) break;
                var6_7 = 0;
                break;
            }
            case 209951074: {
                if (!var5_5.equals("gorilla")) break;
                var6_7 = 1;
            }
        }
        switch (var6_7) {
            case 0: 
            case 1: {
                SeqTrainTest.logger.info("Generating gorilla dataset");
                train = SequenceDataGenerator.generateGorillaDataset(1);
                test = SequenceDataGenerator.generateGorillaDataset(1);
                break;
            }
            default: {
                if (o.trainDataset == null || o.testDataset == null) ** GOTO lbl80
                SeqTrainTest.logger.info("Loading training data from " + o.trainDataset);
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(o.trainDataset.toFile())));
                var8_10 = null;
                oits = new ObjectInputStream(new BufferedInputStream(new FileInputStream(o.testDataset.toFile())));
                var10_15 = null;
                try {
                    train = tmpTrain = (SequenceDataset)ois.readObject();
                    SeqTrainTest.logger.info(String.format("Loaded %d training examples for %s", new Object[]{train.size(), train.getOutputs().toString()}));
                    SeqTrainTest.logger.info("Found " + train.getFeatureIDMap().size() + " features");
                    SeqTrainTest.logger.info("Loading testing data from " + o.testDataset);
                    test = tmpTest = (SequenceDataset)oits.readObject();
                    SeqTrainTest.logger.info(String.format("Loaded %d testing examples", new Object[]{test.size()}));
                }
                catch (Throwable tmpTrain) {
                    var10_15 = tmpTrain;
                    throw tmpTrain;
                }
                finally {
                    if (oits != null) {
                        if (var10_15 != null) {
                            try {
                                oits.close();
                            }
                            catch (Throwable tmpTrain) {
                                var10_15.addSuppressed(tmpTrain);
                            }
                        } else {
                            oits.close();
                        }
                    }
                }
                if (ois == null) break;
                if (var8_10 == null) ** GOTO lbl63
                try {
                    ois.close();
                }
                catch (Throwable var9_13) {
                    var8_10.addSuppressed(var9_13);
                }
                break;
lbl63:
                // 1 sources

                ois.close();
                break;
                catch (Throwable var9_14) {
                    try {
                        var8_10 = var9_14;
                        throw var9_14;
                    }
                    catch (Throwable var15_25) {
                        if (ois != null) {
                            if (var8_10 != null) {
                                try {
                                    ois.close();
                                }
                                catch (Throwable var16_26) {
                                    var8_10.addSuppressed(var16_26);
                                }
                            } else {
                                ois.close();
                            }
                        }
                        throw var15_25;
                    }
                }
lbl80:
                // 1 sources

                SeqTrainTest.logger.warning("Unknown dataset " + o.datasetName);
                SeqTrainTest.logger.info(cm.usage());
                return;
            }
        }
        SeqTrainTest.logger.info("Training using " + o.trainer.toString());
        trainStart = System.currentTimeMillis();
        model = o.trainer.train(train);
        trainStop = System.currentTimeMillis();
        SeqTrainTest.logger.info("Finished training classifier " + Util.formatDuration((long)trainStart, (long)trainStop));
        labelEvaluator = new LabelSequenceEvaluator();
        testStart = System.currentTimeMillis();
        evaluation = (LabelSequenceEvaluation)labelEvaluator.evaluate(model, test);
        testStop = System.currentTimeMillis();
        SeqTrainTest.logger.info("Finished evaluating model " + Util.formatDuration((long)testStart, (long)testStop));
        System.out.println(evaluation.toString());
        System.out.println();
        System.out.println(evaluation.getConfusionMatrix().toString());
        if (o.outputPath != null) {
            oos = new ObjectOutputStream(new FileOutputStream(o.outputPath.toFile()));
            var17_28 = null;
            try {
                oos.writeObject(model);
                SeqTrainTest.logger.info("Serialized model to file: " + o.outputPath);
            }
            catch (Throwable var18_30) {
                var17_28 = var18_30;
                throw var18_30;
            }
            finally {
                if (oos != null) {
                    if (var17_28 != null) {
                        try {
                            oos.close();
                        }
                        catch (Throwable var18_29) {
                            var17_28.addSuppressed(var18_29);
                        }
                    } else {
                        oos.close();
                    }
                }
            }
        }
    }

    public static class SeqTrainTestOptions
    implements Options {
        @Option(charName=100, longName="dataset-name", usage="Name of the example dataset, options are {gorilla}.")
        public String datasetName = "";
        @Option(charName=102, longName="output-path", usage="Path to serialize model to.")
        public Path outputPath;
        @Option(charName=117, longName="train-dataset", usage="Path to a serialised SequenceDataset used for training.")
        public Path trainDataset = null;
        @Option(charName=118, longName="test-dataset", usage="Path to a serialised SequenceDataset used for testing.")
        public Path testDataset = null;
        @Option(charName=116, longName="trainer-name", usage="Name of the trainer in the configuration file.")
        public SequenceTrainer<Label> trainer;

        public String getOptionsDescription() {
            return "Trains and tests a sequence classification model on the specified dataset.";
        }
    }
}

