/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.knn.indices.ModelCache;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheNodeRequest;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheNodeResponse;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheRequest;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheResponse;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class RemoveModelFromCacheTransportAction
extends TransportNodesAction<RemoveModelFromCacheRequest, RemoveModelFromCacheResponse, RemoveModelFromCacheNodeRequest, RemoveModelFromCacheNodeResponse> {
    private static Logger logger = LogManager.getLogger(RemoveModelFromCacheTransportAction.class);

    @Inject
    public RemoveModelFromCacheTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/knn_remove_model_from_cache_action", threadPool, clusterService, transportService, actionFilters, RemoveModelFromCacheRequest::new, RemoveModelFromCacheNodeRequest::new, "same", RemoveModelFromCacheNodeResponse.class);
    }

    protected RemoveModelFromCacheResponse newResponse(RemoveModelFromCacheRequest nodesRequest, List<RemoveModelFromCacheNodeResponse> responses, List<FailedNodeException> failures) {
        return new RemoveModelFromCacheResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected RemoveModelFromCacheNodeRequest newNodeRequest(RemoveModelFromCacheRequest request) {
        return new RemoveModelFromCacheNodeRequest(request.getModelId());
    }

    protected RemoveModelFromCacheNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new RemoveModelFromCacheNodeResponse(in);
    }

    protected RemoveModelFromCacheNodeResponse nodeOperation(RemoveModelFromCacheNodeRequest nodeRequest) {
        logger.debug("[KNN] Removing model \"" + nodeRequest.getModelId() + "\" on node \"" + this.clusterService.localNode().getId() + ".");
        ModelCache.getInstance().remove(nodeRequest.getModelId());
        return new RemoveModelFromCacheNodeResponse(this.clusterService.localNode());
    }
}

