/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.opensearch.knn.memoryoptsearch.faiss.FaissHNSW;
import org.opensearch.knn.memoryoptsearch.faiss.FaissSection;

public class FaissHnswGraph
extends HnswGraph {
    private final FaissHNSW faissHnsw;
    private final IndexInput indexInput;
    private final int numVectors;
    private int[] neighborIdList;
    private int numNeighbors;
    private int nextNeighborIndex;

    public FaissHnswGraph(FaissHNSW faissHNSW, IndexInput indexInput) {
        this.faissHnsw = faissHNSW;
        Objects.requireNonNull(faissHNSW.getOffsetsReader());
        this.indexInput = indexInput;
        this.numVectors = Math.toIntExact(faissHNSW.getTotalNumberOfVectors());
    }

    public void seek(int level, int internalVectorId) {
        long o = this.faissHnsw.getOffsetsReader().get((long)internalVectorId);
        long begin = o + (long)this.faissHnsw.getCumNumberNeighborPerLevel()[level];
        long end = o + (long)this.faissHnsw.getCumNumberNeighborPerLevel()[level + 1];
        this.loadNeighborIdList(begin, end);
    }

    private void loadNeighborIdList(long begin, long end) {
        long maxLength = end - begin;
        if (this.neighborIdList == null || (long)this.neighborIdList.length < maxLength) {
            this.neighborIdList = new int[(int)maxLength];
        }
        try {
            this.indexInput.seek(this.faissHnsw.getNeighbors().getBaseOffset() + 4L * begin);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int index = 0;
        try {
            int neighborId;
            for (long i = begin; i < end && (neighborId = this.indexInput.readInt()) >= 0; ++i) {
                this.neighborIdList[index++] = neighborId;
            }
            this.numNeighbors = index;
            this.nextNeighborIndex = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.numVectors;
    }

    public int nextNeighbor() {
        if (this.nextNeighborIndex < this.numNeighbors) {
            return this.neighborIdList[this.nextNeighborIndex++];
        }
        return Integer.MAX_VALUE;
    }

    public int numLevels() {
        return this.faissHnsw.getMaxLevel();
    }

    public int entryNode() {
        return this.faissHnsw.getEntryPoint();
    }

    public HnswGraph.NodesIterator getNodesOnLevel(final int level) {
        try {
            FaissSection levelsSection = this.faissHnsw.getLevels();
            final IndexInput levelIndexInput = this.indexInput.clone();
            levelIndexInput.seek(levelsSection.getBaseOffset());
            int numVectorsAtLevel = 0;
            for (int i = 0; i < this.numVectors; ++i) {
                int maxLevel = levelIndexInput.readInt();
                if (maxLevel <= level) continue;
                ++numVectorsAtLevel;
            }
            levelIndexInput.seek(levelsSection.getBaseOffset());
            return new HnswGraph.NodesIterator(this, numVectorsAtLevel){
                int vectorNo;
                int numVisitedVectors;
                {
                    super(size);
                    this.vectorNo = -1;
                    this.numVisitedVectors = 0;
                }

                public boolean hasNext() {
                    return this.numVisitedVectors < this.size;
                }

                public int nextInt() {
                    try {
                        int maxLevel;
                        do {
                            ++this.vectorNo;
                        } while ((maxLevel = levelIndexInput.readInt()) <= level);
                        ++this.numVisitedVectors;
                        return this.vectorNo;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public int consume(int[] ints) {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int copySize = Math.min(this.size - this.numVisitedVectors, ints.length);
                    for (int i = 0; i < copySize; ++i) {
                        ints[i] = this.nextInt();
                    }
                    return copySize;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int neighborCount() {
        return this.numNeighbors;
    }

    public int maxConn() {
        return this.faissHnsw.getMaxNumNeighbors();
    }
}

