/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.snapshot.SnapshotReader;
import org.apache.kafka.snapshot.SnapshotWriter;

public interface RaftClient<T>
extends AutoCloseable {
    public void register(Listener<T> var1);

    public void unregister(Listener<T> var1);

    public OptionalLong highWatermark();

    public LeaderAndEpoch leaderAndEpoch();

    public OptionalInt nodeId();

    public long prepareAppend(int var1, List<T> var2);

    public void schedulePreparedAppend();

    public CompletableFuture<Void> shutdown(int var1);

    public void resign(int var1);

    public Optional<SnapshotWriter<T>> createSnapshot(OffsetAndEpoch var1, long var2);

    public Optional<OffsetAndEpoch> latestSnapshotId();

    public long logEndOffset();

    public KRaftVersion kraftVersion();

    public void upgradeKRaftVersion(int var1, KRaftVersion var2, boolean var3);

    public static interface Listener<T> {
        public void handleCommit(BatchReader<T> var1);

        public void handleLoadSnapshot(SnapshotReader<T> var1);

        default public void handleLeaderChange(LeaderAndEpoch leader) {
        }

        default public void beginShutdown() {
        }
    }
}

