/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.DynamicTableColumnExtensionPoint;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.MappedTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.TableSortState;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.docking.settings.Settings;
import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.gui.MemoryMatchTableLoader;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HTMLUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.CodeUnitTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

public class MemoryMatchTableModel
extends AddressBasedTableModel<MemoryMatch> {
    private Color CHANGED_COLOR = GThemeDefaults.Colors.Tables.ERROR_UNSELECTED;
    private Color CHANGED_SELECTED_COLOR = GThemeDefaults.Colors.Tables.ERROR_SELECTED;
    private MemoryMatchTableLoader loader;

    MemoryMatchTableModel(ServiceProvider serviceProvider, Program program) {
        super("Memory Search", serviceProvider, program, null, true);
    }

    @Override
    protected TableColumnDescriptor<MemoryMatch> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new MatchBytesColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new MatchValueColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new CodeUnitTableColumn()));
        return descriptor;
    }

    protected void doLoad(Accumulator<MemoryMatch> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.loader == null) {
            return;
        }
        this.loader.loadResults(accumulator, monitor);
        this.loader = null;
    }

    void setLoader(MemoryMatchTableLoader loader) {
        this.loader = loader;
        this.reload();
    }

    public boolean isSortedOnAddress() {
        TableSortState sortState = this.getTableSortState();
        if (sortState.isUnsorted()) {
            return false;
        }
        ColumnSortState primaryState = (ColumnSortState)sortState.getAllSortStates().get(0);
        DynamicTableColumn column = this.getColumn(primaryState.getColumnModelIndex());
        String name = column.getColumnName();
        return "Location".equals(name);
    }

    @Override
    public ProgramLocation getProgramLocation(int modelRow, int modelColumn) {
        Program p = this.getProgram();
        if (p == null) {
            return null;
        }
        DynamicTableColumn column = this.getColumn(modelColumn);
        Class columnClass = column.getClass();
        if (column instanceof MappedTableColumn) {
            MappedTableColumn mappedColumn = (MappedTableColumn)column;
            columnClass = mappedColumn.getMappedColumnClass();
        }
        if (columnClass == AddressTableColumn.class || columnClass == MatchBytesColumn.class || columnClass == MatchValueColumn.class) {
            return new BytesFieldLocation(p, this.getAddress(modelRow));
        }
        return super.getProgramLocation(modelRow, modelColumn);
    }

    @Override
    public Address getAddress(int row) {
        MemoryMatch result = (MemoryMatch)this.getRowObject(row);
        return result.getAddress();
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet addressSet = new AddressSet();
        for (int row : rows) {
            Address minAddr;
            MemoryMatch result = (MemoryMatch)this.getRowObject(row);
            int addOn = result.getLength() - 1;
            Address maxAddr = minAddr = this.getAddress(row);
            try {
                maxAddr = minAddr.addNoWrap((long)addOn);
                addressSet.addRange(minAddr, maxAddr);
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return new ProgramSelection((AddressSetView)addressSet);
    }

    public class MatchBytesColumn
    extends DynamicTableColumnExtensionPoint<MemoryMatch, String, Program> {
        private ByteArrayRenderer renderer;

        public MatchBytesColumn() {
            this.renderer = new ByteArrayRenderer();
        }

        public String getColumnName() {
            return "Match Bytes";
        }

        public String getValue(MemoryMatch match, Settings settings, Program pgm, ServiceProvider service) throws IllegalArgumentException {
            return this.getByteString(match.getBytes());
        }

        private String getByteString(byte[] bytes) {
            StringBuilder b = new StringBuilder();
            int max = bytes.length - 1;
            int i = 0;
            while (true) {
                b.append(String.format("%02x", bytes[i]));
                if (i == max) break;
                b.append(" ");
                ++i;
            }
            return b.toString();
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    public class MatchValueColumn
    extends DynamicTableColumnExtensionPoint<MemoryMatch, String, Program> {
        private ValueRenderer renderer;

        public MatchValueColumn() {
            this.renderer = new ValueRenderer();
        }

        public String getColumnName() {
            return "Match Value";
        }

        public String getValue(MemoryMatch match, Settings settings, Program pgm, ServiceProvider service) throws IllegalArgumentException {
            ByteMatcher byteMatcher = match.getByteMatcher();
            SearchSettings searchSettings = byteMatcher.getSettings();
            SearchFormat format = searchSettings.getSearchFormat();
            return format.getValueString(match.getBytes(), searchSettings);
        }

        public int getColumnPreferredWidth() {
            return 200;
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class ValueRenderer
    extends AbstractGColumnRenderer<String> {
        private ValueRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            this.setText((String)data.getValue());
            MemoryMatch match = (MemoryMatch)data.getRowObject();
            if (match.isChanged()) {
                this.setForeground(data.isSelected() ? MemoryMatchTableModel.this.CHANGED_SELECTED_COLOR : MemoryMatchTableModel.this.CHANGED_COLOR);
            }
            return this;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }

    private class ByteArrayRenderer
    extends AbstractGColumnRenderer<String> {
        public ByteArrayRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        protected Font getDefaultFont() {
            return this.fixedWidthFont;
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            MemoryMatch match = (MemoryMatch)data.getRowObject();
            String text = data.getValue().toString();
            if (match.isChanged()) {
                text = this.getHtmlColoredString(match, data.isSelected());
            }
            this.setText(text);
            return this;
        }

        private String getHtmlColoredString(MemoryMatch match, boolean isSelected) {
            GColor color = isSelected ? GThemeDefaults.Colors.Tables.ERROR_SELECTED : GThemeDefaults.Colors.Tables.ERROR_UNSELECTED;
            StringBuilder b = new StringBuilder();
            b.append("<HTML>");
            byte[] bytes = match.getBytes();
            byte[] previousBytes = match.getPreviousBytes();
            int max = bytes.length - 1;
            int i = 0;
            while (true) {
                String byteString = String.format("%02x", bytes[i]);
                if (bytes[i] != previousBytes[i]) {
                    byteString = HTMLUtilities.colorString((Color)color, (String)byteString);
                }
                b.append(byteString);
                if (i == max) break;
                b.append(" ");
                ++i;
            }
            return b.toString();
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }
}

