/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.widgets.OptionDialog;
import generic.concurrent.GThreadPool;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.AnalysisBackgroundCommand;
import ghidra.app.plugin.core.analysis.AnalysisScheduler;
import ghidra.app.plugin.core.analysis.AnalysisTaskList;
import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManagerListener;
import ghidra.app.plugin.core.analysis.DefaultDataTypeManagerService;
import ghidra.app.plugin.core.analysis.OneShotAnalysisCommand;
import ghidra.app.plugin.core.analysis.StoredAnalyzerTimes;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventQueueID;
import ghidra.framework.model.EventType;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSetViewAdapter;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionChangeRecord;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.PriorityQueue;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.map.LazyMap;

public class AutoAnalysisManager {
    private static final String SHARED_THREAD_POOL_NAME = "Analysis";
    private static final String OPTION_NAME_THREAD_USE = "Max Threads";
    private static final String OPTION_DESCRIPTION_THREAD_USE = "Maximum number of threads to use at once for tasks that run in parallel";
    private static int analysisSharedThreadPoolSize = SystemUtilities.getDefaultThreadPoolSize();
    private static Map<Program, AutoAnalysisManager> managerMap = new WeakHashMap<Program, AutoAnalysisManager>();
    private static final Factory<WeakSet<PluginTool>> SET_FACTORY = () -> WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private static Map<Program, WeakSet<PluginTool>> toolMap = LazyMap.lazyMap(new WeakHashMap(), SET_FACTORY);
    private volatile Program program;
    private DefaultDataTypeManagerService service = null;
    private AnalysisTaskList byteTasks;
    private AnalysisTaskList functionTasks;
    private AnalysisTaskList functionModifierChangedTasks;
    private AnalysisTaskList functionSignatureChangedTasks;
    private AnalysisTaskList instructionTasks;
    private AnalysisTaskList dataTasks;
    private AnalysisTaskList[] taskArray;
    private AddressSet protectedLocations = new AddressSet();
    private PriorityQueue<BackgroundCommand<Program>> queue = new PriorityQueue();
    private Map<String, Long> timedTasks = new HashMap<String, Long>();
    private Map<String, Long> cumulativeTasks = new HashMap<String, Long>();
    private boolean backgroundAnalysisPending = false;
    private Thread analysisThread;
    private AnalysisTaskWrapper activeTask;
    private Stack<AnalysisTaskWrapper> yieldedTasks = new Stack();
    private boolean alreadyAskedThisSession = false;
    private PluginTool analysisTool;
    boolean debugOn = false;
    private int totalTaskTime = 0;
    private volatile boolean ignoreChanges;
    private boolean isEnabled = true;
    private MessageLog log = new MessageLog();
    private List<AutoAnalysisManagerListener> listeners = new CopyOnWriteArrayList<AutoAnalysisManagerListener>();
    private EventQueueID eventQueueID;
    private DomainObjectListener domainObjectListener = this.createDomainObjectListener();

    private AutoAnalysisManager(Program program) {
        this.program = program;
        this.eventQueueID = program.createPrivateEventQueue(this.domainObjectListener, 500);
        program.addCloseListener(dobj -> this.dispose());
        this.initializeAnalyzers();
    }

    private void initializeAnalyzers() {
        this.byteTasks = new AnalysisTaskList(this, AnalyzerType.BYTE_ANALYZER.getName());
        this.functionTasks = new AnalysisTaskList(this, AnalyzerType.FUNCTION_ANALYZER.getName());
        this.functionModifierChangedTasks = new AnalysisTaskList(this, AnalyzerType.FUNCTION_MODIFIERS_ANALYZER.getName());
        this.functionSignatureChangedTasks = new AnalysisTaskList(this, AnalyzerType.FUNCTION_SIGNATURES_ANALYZER.getName());
        this.instructionTasks = new AnalysisTaskList(this, AnalyzerType.INSTRUCTION_ANALYZER.getName());
        this.dataTasks = new AnalysisTaskList(this, AnalyzerType.DATA_ANALYZER.getName());
        this.taskArray = new AnalysisTaskList[]{this.byteTasks, this.instructionTasks, this.functionTasks, this.functionModifierChangedTasks, this.functionSignatureChangedTasks, this.dataTasks};
        List analyzers = ClassSearcher.getInstances(Analyzer.class);
        for (Analyzer analyzer : analyzers) {
            if (!analyzer.canAnalyze(this.program)) continue;
            AnalyzerType type = analyzer.getAnalysisType();
            if (type == AnalyzerType.BYTE_ANALYZER) {
                this.byteTasks.add(analyzer);
                continue;
            }
            if (type == AnalyzerType.DATA_ANALYZER) {
                this.dataTasks.add(analyzer);
                continue;
            }
            if (type == AnalyzerType.FUNCTION_ANALYZER) {
                this.functionTasks.add(analyzer);
                continue;
            }
            if (type == AnalyzerType.FUNCTION_MODIFIERS_ANALYZER) {
                this.functionModifierChangedTasks.add(analyzer);
                continue;
            }
            if (type == AnalyzerType.FUNCTION_SIGNATURES_ANALYZER) {
                this.functionSignatureChangedTasks.add(analyzer);
                continue;
            }
            if (type == AnalyzerType.INSTRUCTION_ANALYZER) {
                this.instructionTasks.add(analyzer);
                continue;
            }
            Msg.showError((Object)this, null, (String)"Unknown Analysis Type", (Object)("Unexpected Analysis type " + String.valueOf((Object)type)));
        }
        this.registerOptions();
        this.initializeOptions();
    }

    public MessageLog getMessageLog() {
        return this.log;
    }

    public Analyzer getAnalyzer(String analyzerName) {
        for (AnalysisTaskList taskList : this.taskArray) {
            Iterator<AnalysisScheduler> iterator = taskList.iterator();
            while (iterator.hasNext()) {
                AnalysisScheduler scheduler = iterator.next();
                if (!scheduler.getAnalyzer().getName().equals(analyzerName)) continue;
                return scheduler.getAnalyzer();
            }
        }
        return null;
    }

    public Program getProgram() {
        return this.program;
    }

    public void scheduleOneTimeAnalysis(Analyzer analyzer, AddressSetView set) {
        Options options = this.program.getOptions("Analyzers");
        analyzer.optionsChanged(options.getOptions(analyzer.getName()), this.getProgram());
        OneShotAnalysisCommand cmd = new OneShotAnalysisCommand(analyzer, set, this.log);
        this.schedule(cmd, analyzer.getPriority().priority());
    }

    public void externalAdded(Address extAddr) {
        if (this.ignoreChanges) {
            return;
        }
        if (extAddr != null) {
            this.byteTasks.notifyAdded(extAddr);
        } else {
            this.byteTasks.notifyAdded((AddressSetView)new AddressSet(AddressSpace.EXTERNAL_SPACE.getMinAddress(), AddressSpace.EXTERNAL_SPACE.getMaxAddress()));
        }
    }

    public void blockAdded(AddressSetView set) {
        if (!this.ignoreChanges && set != null && !set.isEmpty()) {
            this.byteTasks.notifyAdded(set);
        }
    }

    public void codeDefined(Address addr) {
        if (!this.ignoreChanges && addr != null) {
            this.instructionTasks.notifyAdded(addr);
        }
    }

    public void codeDefined(AddressSetView set) {
        if (!this.ignoreChanges && set != null && !set.isEmpty()) {
            this.instructionTasks.notifyAdded(set);
        }
    }

    public void dataDefined(AddressSetView set) {
        if (!this.ignoreChanges && set != null && !set.isEmpty()) {
            this.dataTasks.notifyAdded(set);
        }
    }

    public void functionDefined(Address addr) {
        if (!this.ignoreChanges && addr != null) {
            this.functionTasks.notifyAdded(addr);
        }
    }

    public void functionDefined(AddressSetView set) {
        if (!this.ignoreChanges && set != null && !set.isEmpty()) {
            this.functionTasks.notifyAdded(set);
        }
    }

    public void functionModifierChanged(Address addr) {
        if (!this.ignoreChanges && addr != null) {
            this.functionModifierChangedTasks.notifyAdded(addr);
        }
    }

    public void functionModifierChanged(AddressSetView set) {
        if (!this.ignoreChanges && set != null && !set.isEmpty()) {
            this.functionModifierChangedTasks.notifyAdded(set);
        }
    }

    public void functionSignatureChanged(Address addr) {
        if (!this.ignoreChanges && addr != null) {
            this.functionSignatureChangedTasks.notifyAdded(addr);
        }
    }

    public void functionSignatureChanged(AddressSetView set) {
        if (!this.ignoreChanges && set != null && !set.isEmpty()) {
            this.functionSignatureChangedTasks.notifyAdded(set);
        }
    }

    public void reAnalyzeAll(AddressSetView restrictSet) {
        if (restrictSet == null || restrictSet.isEmpty()) {
            this.externalAdded(null);
            restrictSet = this.program.getMemory();
        }
        this.blockAdded(restrictSet);
        if (this.program.getListing().getNumInstructions() != 0L) {
            this.codeDefined(restrictSet);
        }
        if (this.program.getListing().getNumDefinedData() != 0L) {
            this.dataDefined(restrictSet);
        }
        if (this.program.getFunctionManager().getFunctions(true).hasNext()) {
            this.functionDefined(restrictSet);
            this.functionSignatureChanged(restrictSet);
        }
    }

    public void setDebug(boolean b) {
        this.debugOn = b;
    }

    private void handleCodeAdded(ProgramChangeRecord rec) {
        if (rec.getNewValue() instanceof Data) {
            AddressSet addressSet = new AddressSet(rec.getStart(), rec.getEnd());
            this.dataDefined((AddressSetView)addressSet);
        }
    }

    private void handleOverrides(ProgramChangeRecord rec) {
        this.codeDefined((AddressSetView)new AddressSet(rec.getStart()));
    }

    private void handleFunctionAddedOrBodyChanged(ProgramChangeRecord rec) {
        Function func = (Function)rec.getObject();
        if (!func.isExternal()) {
            this.functionDefined(func.getEntryPoint());
        }
    }

    private void handleFunctionChanged(FunctionChangeRecord rec) {
        Address entry = rec.getFunction().getEntryPoint();
        if (rec.isFunctionSignatureChange()) {
            this.functionSignatureChanged(entry);
        } else if (rec.isFunctionModifierChange()) {
            this.functionModifierChanged(entry);
        }
    }

    private void resetOptions() {
        this.initializeOptions();
        Preferences.store();
    }

    private DomainObjectListener createDomainObjectListener() {
        return ((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)this).ignoreWhen(this::shouldIgnoreEvent)).any(new EventType[]{ProgramEvent.LANGUAGE_CHANGED}).call(this::initializeAnalyzers)).any(new EventType[]{DomainObjectEvent.RESTORED, DomainObjectEvent.PROPERTY_CHANGED}).call(this::resetOptions)).with(FunctionChangeRecord.class).each(new EventType[]{ProgramEvent.FUNCTION_CHANGED}).call(r -> this.handleFunctionChanged((FunctionChangeRecord)r)).with(ProgramChangeRecord.class).each(new EventType[]{ProgramEvent.FUNCTION_ADDED, ProgramEvent.FUNCTION_BODY_CHANGED}).call(r -> this.handleFunctionAddedOrBodyChanged((ProgramChangeRecord)r)).each(new EventType[]{ProgramEvent.FUNCTION_REMOVED}).call(r -> this.functionTasks.notifyRemoved(r.getStart())).each(new EventType[]{ProgramEvent.FALLTHROUGH_CHANGED, ProgramEvent.FLOW_OVERRIDE_CHANGED, ProgramEvent.LENGTH_OVERRIDE_CHANGED}).call(r -> this.handleOverrides((ProgramChangeRecord)r)).each(new EventType[]{ProgramEvent.CODE_ADDED}).call(r -> this.handleCodeAdded((ProgramChangeRecord)r)).build();
    }

    private boolean shouldIgnoreEvent() {
        if (this.program == null) {
            return true;
        }
        if (this.program.isClosed()) {
            this.cancelQueuedTasks();
            this.dispose();
            return true;
        }
        return this.ignoreChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void yield(Integer limitPriority, TaskMonitor monitor) {
        if (limitPriority != null && limitPriority == 0) {
            limitPriority = Integer.MAX_VALUE;
        }
        boolean originalIgnoreChanges = this.setIgnoreChanges(false);
        try {
            this.startAnalysis(monitor, true, limitPriority, false);
        }
        finally {
            this.setIgnoreChanges(originalIgnoreChanges);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAnalysis(final Integer limitPriority, TaskMonitor monitor) {
        if (Thread.currentThread() != this.analysisThread) {
            if (SystemUtilities.isInHeadlessMode()) {
                if (this.analysisThread != null) {
                    throw new IllegalStateException();
                }
                this.startAnalysis(monitor, false, limitPriority, true);
                return;
            }
            this.program.flushPrivateEventQueue(this.eventQueueID);
            AutoAnalysisManager autoAnalysisManager = this;
            synchronized (autoAnalysisManager) {
                if (this.analysisThread == null && this.queue.isEmpty()) {
                    return;
                }
            }
            try {
                this.scheduleWorker(new AnalysisWorker(){

                    @Override
                    public boolean analysisWorkerCallback(Program p, Object workerContext, TaskMonitor workerMonitor) throws Exception, CancelledException {
                        AutoAnalysisManager.this.waitForAnalysis(limitPriority, workerMonitor);
                        return true;
                    }

                    @Override
                    public String getWorkerName() {
                        return "Wait for Analysis";
                    }
                }, null, true, monitor);
            }
            catch (CancelledException cancelledException) {
            }
            catch (InvocationTargetException e) {
                Msg.error((Object)this, (Object)"Error occurred while waiting for analysis", (Throwable)e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return;
        }
        if (this.activeTask == null) {
            throw new AssertException();
        }
        Integer originalPriority = this.activeTask.taskPriority;
        this.activeTask.taskPriority = limitPriority;
        try {
            this.yield(limitPriority, monitor);
        }
        finally {
            this.activeTask.taskPriority = originalPriority;
        }
    }

    public boolean setIgnoreChanges(boolean state) {
        if (this.analysisThread != Thread.currentThread()) {
            Msg.warn((Object)this, (Object)"AutoAnalysisManager.setIgnoreChanges had no affect since it was not invoked within the analysis thread");
            return this.ignoreChanges;
        }
        return this.doSetIgnoreChanges(state);
    }

    private boolean doSetIgnoreChanges(boolean state) {
        if (this.ignoreChanges == state) {
            return state;
        }
        this.program.flushPrivateEventQueue(this.eventQueueID);
        this.ignoreChanges = state;
        return !state;
    }

    public void startAnalysis(TaskMonitor monitor) {
        this.startAnalysis(monitor, true);
    }

    public void startAnalysis(TaskMonitor monitor, boolean printTaskTimes) {
        if (Thread.currentThread() == this.analysisThread) {
            this.yield(this.activeTask.taskPriority, monitor);
        } else {
            if (this.analysisThread != null || !this.isEnabled) {
                return;
            }
            PluginTool tool = this.getAnalysisTool();
            if (tool != null && !tool.threadIsBackgroundTaskThread()) {
                this.startBackgroundAnalysis();
            } else {
                this.startAnalysis(monitor, false, null, printTaskTimes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startAnalysis(TaskMonitor monitor, boolean yield, Integer limitPriority, boolean printTaskTimes) {
        if (this.program == null) return;
        if (this.program.isClosed()) {
            return;
        }
        this.program.flushPrivateEventQueue(this.eventQueueID);
        AutoAnalysisManager autoAnalysisManager = this;
        synchronized (autoAnalysisManager) {
            try {
                if (!yield) {
                    if (!this.isEnabled) return;
                    if (this.analysisThread != null) {
                        return;
                    }
                }
                if (yield && this.activeTask == null) {
                    throw new AssertException("Expected active analysis task");
                }
                AnalysisTaskWrapper task = this.getNextTask(limitPriority, monitor);
                if (task == null) {
                    return;
                }
                if (this.analysisThread == null) {
                    this.analysisThread = Thread.currentThread();
                }
                if (yield) {
                    this.activeTask.pauseTimer();
                    this.yieldedTasks.push(this.activeTask);
                }
                this.activeTask = task;
            }
            finally {
                this.backgroundAnalysisPending = false;
            }
        }
        try {
            if (printTaskTimes) {
                this.clearTimedTasks();
            }
            while (true) {
                Program p;
                if ((p = this.program) == null || p.hasTerminatedTransaction()) {
                    monitor.cancel();
                    this.cancelQueuedTasks();
                    break;
                }
                this.activeTask.run(p, monitor);
                AutoAnalysisManager autoAnalysisManager2 = this;
                synchronized (autoAnalysisManager2) {
                    this.activeTask = this.getNextTask(limitPriority, monitor);
                    if (this.activeTask == null) {
                        if (!yield) {
                            this.analysisThread = null;
                        }
                        break;
                    }
                }
            }
            if (yield) return;
            this.notifyAnalysisEnded(monitor.isCancelled());
            if (!printTaskTimes) return;
            this.printTimedTasks();
            this.saveTaskTimes();
            return;
        }
        finally {
            autoAnalysisManager = this;
            synchronized (autoAnalysisManager) {
                if (yield) {
                    this.activeTask = this.yieldedTasks.pop();
                    this.activeTask.resumeTimer();
                } else {
                    this.analysisTool = null;
                    this.analysisThread = null;
                    this.activeTask = null;
                    this.protectedLocations = new AddressSet();
                    this.yieldedTasks.clear();
                }
            }
        }
    }

    private AnalysisTaskWrapper getNextTask(Integer limitPriority, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            this.cancelQueuedTasks();
        }
        if (!this.isEnabled || this.queue.isEmpty() || limitPriority != null && this.queue.getFirstPriority() >= limitPriority) {
            return null;
        }
        int nextTaskPriority = this.queue.getFirstPriority();
        return new AnalysisTaskWrapper((BackgroundCommand<Program>)((BackgroundCommand)this.queue.removeFirst()), nextTaskPriority);
    }

    public void addListener(AutoAnalysisManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(AutoAnalysisManagerListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAnalysisEnded(boolean isCancelled) {
        for (AnalysisTaskList list : this.taskArray) {
            list.notifyAnalysisEnded(this.program);
        }
        for (AutoAnalysisManagerListener listener : this.listeners) {
            listener.analysisEnded(this, isCancelled);
        }
        this.log.clear();
    }

    public synchronized boolean isAnalyzing() {
        if (this.program == null || this.program.isClosed()) {
            return false;
        }
        return this.analysisThread != null || this.backgroundAnalysisPending;
    }

    public synchronized void cancelQueuedTasks() {
        while (!this.queue.isEmpty()) {
            AnalysisWorkerCommand workerCmd;
            BackgroundCommand cmd = (BackgroundCommand)this.queue.getFirst();
            if (cmd instanceof AnalysisWorkerCommand && !(workerCmd = (AnalysisWorkerCommand)cmd).canCancel()) {
                return;
            }
            cmd = (BackgroundCommand)this.queue.removeFirst();
            cmd.dispose();
        }
    }

    synchronized boolean schedule(BackgroundCommand<Program> cmd, int priority) {
        if (cmd == null) {
            throw new IllegalArgumentException("Can't schedule a null command");
        }
        this.queue.add(cmd, priority);
        return this.startBackgroundAnalysis();
    }

    public synchronized boolean startBackgroundAnalysis() {
        if (!this.isEnabled) {
            return false;
        }
        if (this.analysisThread != null || this.backgroundAnalysisPending) {
            return true;
        }
        this.analysisTool = AutoAnalysisManager.getActiveTool(this.program);
        if (this.analysisTool != null) {
            AnalysisBackgroundCommand analysisCmd = new AnalysisBackgroundCommand(this, false);
            this.backgroundAnalysisPending = true;
            this.analysisTool.scheduleFollowOnCommand((BackgroundCommand)analysisCmd, (DomainObject)this.program);
            return true;
        }
        return false;
    }

    public DataTypeManagerService getDataTypeManagerService() {
        PluginTool tool = AutoAnalysisManager.getActiveTool(this.program);
        DataTypeManagerService dtmService = null;
        if (tool != null) {
            dtmService = (DataTypeManagerService)tool.getService(DataTypeManagerService.class);
        }
        if (dtmService != null) {
            return dtmService;
        }
        if (this.service == null) {
            this.service = new DefaultDataTypeManagerService();
        }
        return this.service;
    }

    public synchronized PluginTool getAnalysisTool() {
        if (this.analysisTool == null) {
            this.analysisTool = AutoAnalysisManager.getActiveTool(this.program);
        }
        return this.analysisTool;
    }

    private static PluginTool getActiveTool(Program program) {
        WeakSet<PluginTool> toolSet = toolMap.get(program);
        if (toolSet.isEmpty()) {
            return null;
        }
        PluginTool anyTool = null;
        Iterator iterator = toolSet.iterator();
        while (iterator.hasNext()) {
            PluginTool tool;
            anyTool = tool = (PluginTool)iterator.next();
            JFrame toolFrame = tool.getToolFrame();
            if (toolFrame == null || !toolFrame.isActive()) continue;
            return tool;
        }
        return anyTool;
    }

    public static synchronized boolean hasAutoAnalysisManager(Program program) {
        return managerMap.containsKey(program);
    }

    public static synchronized AutoAnalysisManager getAnalysisManager(Program program) {
        AutoAnalysisManager mgr = managerMap.get(program);
        if (mgr == null) {
            mgr = new AutoAnalysisManager(program);
            managerMap.put(program, mgr);
        }
        return mgr;
    }

    public void dispose() {
        this.doDispose(this.program);
        this.program = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDispose(Program localProgram) {
        if (localProgram == null) {
            return;
        }
        AutoAnalysisManager autoAnalysisManager = this;
        synchronized (autoAnalysisManager) {
            if (this.service != null) {
                this.service.dispose();
                this.service = null;
            }
        }
        managerMap.remove(localProgram);
        toolMap.remove(localProgram);
        autoAnalysisManager = this;
        synchronized (autoAnalysisManager) {
            this.queue.clear();
            for (AnalysisTaskList list : this.taskArray) {
                list.clear();
            }
        }
        localProgram.removePrivateEventQueue(this.eventQueueID);
    }

    public void addTool(PluginTool tool) {
        WeakSet<PluginTool> toolSet = toolMap.get(this.program);
        toolSet.add((Object)tool);
        this.initializeToolOptions(tool);
    }

    public void removeTool(PluginTool tool) {
        WeakSet<PluginTool> toolSet = toolMap.get(this.program);
        toolSet.remove((Object)tool);
        if (this.analysisTool == tool) {
            this.analysisTool = null;
        }
    }

    private void initializeToolOptions(PluginTool tool) {
        ToolOptions options = tool.getOptions("Auto Analysis");
        options.registerOption(OPTION_NAME_THREAD_USE, (Object)analysisSharedThreadPoolSize, null, OPTION_DESCRIPTION_THREAD_USE);
        analysisSharedThreadPoolSize = AutoAnalysisManager.getSharedThreadPoolSizeOption(tool);
    }

    private static int getSharedThreadPoolSizeOption(PluginTool tool) {
        ToolOptions options = tool.getOptions("Auto Analysis");
        return options.getInt(OPTION_NAME_THREAD_USE, analysisSharedThreadPoolSize);
    }

    public void registerOptions() {
        this.registerGlobalAnalyisOptions();
        this.registerAnalyzerOptions();
    }

    public void initializeOptions() {
        Options options = this.program.getOptions("Analyzers");
        try {
            this.initializeOptions(options);
        }
        catch (OptionsVetoException e) {
            Msg.showError((Object)this, null, (String)"Invalid Analysis Option", (Object)"Invalid Analysis option set during initialization", (Throwable)e);
        }
    }

    public void initializeOptions(Options options) {
        this.byteTasks.optionsChanged(options);
        this.functionTasks.optionsChanged(options);
        this.functionModifierChangedTasks.optionsChanged(options);
        this.functionSignatureChangedTasks.optionsChanged(options);
        this.instructionTasks.optionsChanged(options);
        this.dataTasks.optionsChanged(options);
    }

    private void registerGlobalAnalyisOptions() {
        Options options = this.program.getOptions("Program Information");
        options.registerOption("Analyzed", (Object)false, null, "Indicates if program has ever been analyzed");
        options.registerOption("Should Ask To Analyze", (Object)true, null, "Indicates if user should be prompted to analyze an unanalyzed program when opened");
    }

    public void registerAnalyzerOptions() {
        Options options = this.program.getOptions("Analyzers");
        this.byteTasks.registerOptions(options);
        this.functionTasks.registerOptions(options);
        this.functionModifierChangedTasks.registerOptions(options);
        this.functionSignatureChangedTasks.registerOptions(options);
        this.instructionTasks.registerOptions(options);
        this.dataTasks.registerOptions(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreDefaultOptions() {
        boolean commit = false;
        int id = this.program.startTransaction("Restore Default Analysis Options");
        try {
            Options options = this.program.getOptions("Analyzers");
            for (String propertyName : options.getOptionNames()) {
                options.restoreDefaultValue(propertyName);
            }
            commit = true;
        }
        finally {
            this.program.endTransaction(id, commit);
        }
    }

    boolean askToAnalyze(PluginTool tool) {
        Swing.assertSwingThread((String)"Asking to analyze must be on the swing thread!");
        if (this.alreadyAskedThisSession) {
            return false;
        }
        this.alreadyAskedThisSession = true;
        if (GhidraProgramUtilities.shouldAskToAnalyze(this.program)) {
            String name = HTMLUtilities.escapeHTML((String)this.program.getDomainFile().getName());
            HelpLocation help = new HelpLocation("AutoAnalysisPlugin", "Ask_To_Analyze");
            int result = OptionDialog.showOptionNoCancelDialog((Component)tool.getToolFrame(), (String)"Analyze?", (String)("<html>" + name + " has not been analyzed. Would you like to analyze it now?"), (String)"Yes", (String)"No", (String)"No (Don't ask again)", (int)3, (HelpLocation)help);
            if (result == 3) {
                GhidraProgramUtilities.markProgramNotToAskToAnalyze(this.program);
            }
            return result == 1;
        }
        return false;
    }

    private synchronized int getDisassemblyPriority() {
        if (this.activeTask == null || this.activeTask.taskPriority == null) {
            return AnalysisPriority.DISASSEMBLY.priority();
        }
        return this.activeTask.taskPriority - 2;
    }

    private int getFunctionPriority() {
        return this.getDisassemblyPriority() + 1;
    }

    public void disassemble(Address target) {
        this.schedule(new DisassembleCommand(target, null, true), this.getDisassemblyPriority());
    }

    public void createFunction(Address target, boolean findFunctionStart) {
        this.schedule(new CreateFunctionCmd(target, findFunctionStart), this.getFunctionPriority());
    }

    public void disassemble(AddressSetView targetSet) {
        this.schedule(new DisassembleCommand(targetSet, null, true), this.getDisassemblyPriority());
    }

    public void createFunction(AddressSetView targetSet, boolean findFunctionStarts) {
        this.schedule(new CreateFunctionCmd(targetSet, findFunctionStarts), this.getFunctionPriority());
    }

    public void disassemble(AddressSetView targetSet, AnalysisPriority priority) {
        this.schedule(new DisassembleCommand(targetSet, null, true), priority.priority());
    }

    public void createFunction(AddressSetView targetSet, boolean findFunctionStarts, AnalysisPriority priority) {
        this.schedule(new CreateFunctionCmd(targetSet, findFunctionStarts), priority.priority());
    }

    public AddressSetView getProtectedLocations() {
        return new AddressSetViewAdapter((AddressSetView)this.protectedLocations);
    }

    public void setProtectedLocation(Address addr) {
        this.protectedLocations.add(addr);
    }

    public void setProtectedLocations(AddressSet set) {
        this.protectedLocations.add((AddressSetView)set);
    }

    public String[] getTimedTasks() {
        String[] values = new String[this.timedTasks.size()];
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.timedTasks.keySet());
        Collections.sort(list);
        return list.toArray(values);
    }

    public long getTaskTime(Map<String, Long> map, String taskName) {
        Long time = map.get(taskName);
        if (time == null) {
            return -1L;
        }
        return time;
    }

    private void clearTimedTasks() {
        this.timedTasks.clear();
        this.totalTaskTime = 0;
    }

    private long getUpdatedTaskTime(Map<String, Long> map, String taskName, long newTime) {
        long totalTime = newTime;
        long currentTime = this.getTaskTime(map, taskName);
        if (currentTime > 0L) {
            totalTime += currentTime;
        }
        return totalTime;
    }

    private void addToTaskTime(String taskName, long time) {
        long l = this.getUpdatedTaskTime(this.timedTasks, taskName, time);
        this.timedTasks.put(taskName, l);
        l = this.getUpdatedTaskTime(this.cumulativeTasks, taskName, time);
        this.cumulativeTasks.put(taskName, l);
    }

    public int getTotalTimeInMillis() {
        return this.totalTaskTime;
    }

    public String getTaskTimesString() {
        String[] taskNames;
        StringBuffer taskTimesStringBuf = new StringBuffer();
        String spacer = "                                                     ";
        taskTimesStringBuf.append("-----------------------------------------------------\n");
        for (String element : taskNames = this.getTimedTasks()) {
            long taskTime = this.getTaskTime(this.timedTasks, element);
            double totalTime = (double)taskTime / 1000.0;
            String partTime = "" + (int)(totalTime * 1000.0) % 1000;
            String secString = (int)totalTime + "." + "000".substring(partTime.length()) + partTime + " secs";
            int testLen = element.length() + secString.length();
            if (testLen > spacer.length()) {
                testLen = spacer.length() - 5;
            }
            taskTimesStringBuf.append("    " + element + spacer.substring(testLen) + secString + "\n");
        }
        taskTimesStringBuf.append("-----------------------------------------------------\n");
        taskTimesStringBuf.append("     Total Time   " + (int)((double)this.totalTaskTime / 1000.0) + " secs\n");
        taskTimesStringBuf.append("-----------------------------------------------------\n");
        return taskTimesStringBuf.toString();
    }

    private void printTimedTasks() {
        if (this.totalTaskTime < 1000) {
            return;
        }
        String taskTimeString = this.getTaskTimesString();
        Msg.info((Object)this, (Object)taskTimeString);
    }

    private void saveTaskTimes() {
        String[] taskNames;
        Program p = this.program;
        if (p == null || p.isClosed()) {
            return;
        }
        if (!p.isTemporary() && !p.isChanged()) {
            return;
        }
        StoredAnalyzerTimes times = StoredAnalyzerTimes.getStoredAnalyzerTimes(this.program);
        for (String element : taskNames = this.getTimedTasks()) {
            long taskTimeMSec = this.getTaskTime(this.timedTasks, element);
            times.addTime(element, taskTimeMSec);
        }
        StoredAnalyzerTimes.setStoredAnalyzerTimes(this.program, times);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleWorker(AnalysisWorker worker, Object workerContext, boolean analyzeChanges, TaskMonitor workerMonitor) throws InvocationTargetException, InterruptedException, CancelledException {
        if (!SystemUtilities.isInHeadlessMode() && SwingUtilities.isEventDispatchThread()) {
            throw new UnsupportedOperationException("AutoAnalysisManager.scheduleWorker may not be invoked from Swing thread");
        }
        workerMonitor.checkCancelled();
        AnalysisWorkerCommand cmd = new AnalysisWorkerCommand(worker, workerContext, analyzeChanges, workerMonitor);
        workerMonitor.checkCancelled();
        if (SystemUtilities.isInHeadlessMode()) {
            cmd.applyToWithTransaction(this.program, workerMonitor);
        } else if (this.isAnalysisToolBackgroundThread() || this.getAnalysisTool() == null) {
            cmd.applyToWithTransaction(this.program, workerMonitor);
        } else {
            AnalysisWorkerCommand analysisWorkerCommand = cmd;
            synchronized (analysisWorkerCommand) {
                workerMonitor.setMessage("Waiting for auto-analysis...");
                Msg.debug((Object)this, (Object)("Scheduling analysis worker (" + cmd.worker.getWorkerName() + "): " + String.valueOf(cmd.worker.getClass())));
                this.schedule(cmd, 0);
                try {
                    ((Object)((Object)cmd)).wait();
                }
                catch (InterruptedException e) {
                    if (workerMonitor.isCancelEnabled()) {
                        workerMonitor.cancel();
                    }
                    throw e;
                }
            }
        }
        workerMonitor.checkCancelled();
        Msg.debug((Object)this, (Object)("Analysis worker completed (" + cmd.worker.getWorkerName() + "): " + String.valueOf(cmd.worker.getClass())));
        InvocationTargetException workerException = cmd.getWorkerException();
        if (workerException != null) {
            throw workerException;
        }
        return cmd.getReturn();
    }

    private synchronized boolean isAnalysisToolBackgroundThread() {
        PluginTool tool = this.getAnalysisTool();
        if (tool == null) {
            return false;
        }
        return tool.threadIsBackgroundTaskThread();
    }

    private static String fixupTitle(String title) {
        if (title != null) {
            return title;
        }
        return "Analyzing...";
    }

    public static GThreadPool getSharedAnalsysThreadPool() {
        GThreadPool pool = GThreadPool.getSharedThreadPool((String)SHARED_THREAD_POOL_NAME);
        AutoAnalysisManager.updateSharedThreadPoolSize();
        pool.setMaxThreadCount(analysisSharedThreadPoolSize);
        return pool;
    }

    private static void updateSharedThreadPoolSize() {
        PluginTool tool = AutoAnalysisManager.getAnyTool();
        if (tool == null) {
            return;
        }
        int currentToolSize = AutoAnalysisManager.getSharedThreadPoolSizeOption(tool);
        analysisSharedThreadPoolSize = AutoAnalysisManager.toolCount() == 1 ? currentToolSize : Math.max(analysisSharedThreadPoolSize, currentToolSize);
    }

    private static PluginTool getAnyTool() {
        PluginTool anyTool = null;
        Collection<WeakSet<PluginTool>> values = toolMap.values();
        for (WeakSet<PluginTool> weakSet : values) {
            for (PluginTool tool : weakSet) {
                JFrame toolFrame = tool.getToolFrame();
                if (toolFrame == null || !toolFrame.isActive()) continue;
                return tool;
            }
        }
        return anyTool;
    }

    private static int toolCount() {
        int n = 0;
        Collection<WeakSet<PluginTool>> values = toolMap.values();
        for (WeakSet<PluginTool> weakSet : values) {
            n += weakSet.size();
        }
        return n;
    }

    private class AnalysisTaskWrapper {
        private final BackgroundCommand<Program> task;
        Integer taskPriority;
        private long timeAccumulator;
        private long startTime;

        AnalysisTaskWrapper(BackgroundCommand<Program> task, int taskPriority) {
            this.task = task;
            this.taskPriority = taskPriority;
        }

        void run(Program p, TaskMonitor monitor) {
            block4: {
                this.startTime = System.currentTimeMillis();
                try {
                    this.task.applyTo((DomainObject)p, monitor);
                }
                catch (RuntimeException th) {
                    if (AutoAnalysisManager.this.debugOn) {
                        throw th;
                    }
                    if (p.isClosed() || p.hasTerminatedTransaction()) break block4;
                    String msg = th.getMessage();
                    if (msg == null) {
                        msg = "";
                    }
                    Msg.showError((Object)this, null, (String)"Analyzer Error", (Object)("Analysis Task: " + this.task.getName() + " - " + msg), (Throwable)th);
                }
            }
            long timeDiff = this.timeAccumulator + (System.currentTimeMillis() - this.startTime);
            AutoAnalysisManager.this.totalTaskTime = (int)((long)AutoAnalysisManager.this.totalTaskTime + timeDiff);
            AutoAnalysisManager.this.addToTaskTime(this.task.getName(), timeDiff);
            this.startTime = 0L;
            this.timeAccumulator = 0L;
            p.flushPrivateEventQueue(AutoAnalysisManager.this.eventQueueID);
        }

        void pauseTimer() {
            this.timeAccumulator += System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }

        void resumeTimer() {
            this.startTime = System.currentTimeMillis();
        }
    }

    private class AnalysisWorkerCommand
    extends BackgroundCommand<Program>
    implements CancelledListener {
        private AnalysisWorker worker;
        private Object workerContext;
        private boolean analyzeChanges;
        private TaskMonitor workerMonitor;
        private boolean commandKilled;
        private boolean returnValue;
        private InvocationTargetException exception;

        AnalysisWorkerCommand(AnalysisWorker worker, Object workerContext, boolean analyzeChanges, TaskMonitor workerMonitor) {
            super(worker.getWorkerName(), false, workerMonitor.isCancelEnabled(), false);
            this.worker = worker;
            this.workerContext = workerContext;
            this.analyzeChanges = analyzeChanges;
            this.workerMonitor = workerMonitor;
            workerMonitor.addCancelledListener((CancelledListener)this);
        }

        InvocationTargetException getWorkerException() {
            return this.exception;
        }

        boolean getReturn() {
            return this.returnValue;
        }

        public synchronized void cancelled() {
            if (this.workerMonitor.isCancelEnabled()) {
                this.doNotRun();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doNotRun() {
            this.commandKilled = true;
            this.exception = new InvocationTargetException(new CancelledException());
            this.workerMonitor.cancel();
            AnalysisWorkerCommand analysisWorkerCommand = this;
            synchronized (analysisWorkerCommand) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        public void dispose() {
            this.doNotRun();
            super.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean applyToWithTransaction(Program p, TaskMonitor analysisMonitor) {
            int txId = p.startTransaction(this.worker.getWorkerName());
            try {
                boolean bl = this.applyTo(p, analysisMonitor);
                return bl;
            }
            finally {
                p.endTransaction(txId, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean applyTo(Program p, TaskMonitor analysisMonitor) {
            Object monitor22;
            AnalysisWorkerCommand analysisWorkerCommand = this;
            synchronized (analysisWorkerCommand) {
                this.workerMonitor.removeCancelledListener((CancelledListener)this);
                if (this.commandKilled) {
                    ((Object)((Object)this)).notifyAll();
                    return false;
                }
                assert (p == AutoAnalysisManager.this.program);
                if (analysisMonitor != this.workerMonitor) {
                    if (!this.workerMonitor.isCancelEnabled()) {
                        analysisMonitor.setCancelEnabled(false);
                    }
                    analysisMonitor.addCancelledListener((CancelledListener)this);
                }
                if (!this.analyzeChanges && AutoAnalysisManager.this.ignoreChanges) {
                    this.analyzeChanges = true;
                }
            }
            WorkerBlockerTask blockerTask = null;
            boolean wasIgnoringChanges = AutoAnalysisManager.this.ignoreChanges;
            try {
                if (!this.analyzeChanges && !SystemUtilities.isInHeadlessMode()) {
                    blockerTask = new WorkerBlockerTask();
                }
                if (!this.analyzeChanges) {
                    AutoAnalysisManager.this.doSetIgnoreChanges(true);
                }
                Msg.debug((Object)((Object)this), (Object)("Invoking analysis worker (" + this.worker.getWorkerName() + "): " + String.valueOf(this.worker.getClass())));
                monitor22 = new JointTaskMonitor(AutoAnalysisManager.this, this.workerMonitor, analysisMonitor);
                this.returnValue = this.worker.analysisWorkerCallback(AutoAnalysisManager.this.program, this.workerContext, (TaskMonitor)monitor22);
            }
            catch (CancelledException monitor22) {
                if (!this.analyzeChanges) {
                    AutoAnalysisManager.this.doSetIgnoreChanges(wasIgnoringChanges);
                }
                if (blockerTask != null) {
                    blockerTask.terminate();
                }
                if (analysisMonitor != this.workerMonitor) {
                    analysisMonitor.removeCancelledListener((CancelledListener)this);
                    analysisMonitor.setCancelEnabled(true);
                    analysisMonitor.clearCancelled();
                }
                AnalysisWorkerCommand monitor22 = this;
                synchronized (monitor22) {
                    ((Object)((Object)this)).notifyAll();
                }
            }
            catch (Throwable t) {
                this.exception = new InvocationTargetException(t);
            }
            finally {
                if (!this.analyzeChanges) {
                    AutoAnalysisManager.this.doSetIgnoreChanges(wasIgnoringChanges);
                }
                if (blockerTask != null) {
                    blockerTask.terminate();
                }
                if (analysisMonitor != this.workerMonitor) {
                    analysisMonitor.removeCancelledListener((CancelledListener)this);
                    analysisMonitor.setCancelEnabled(true);
                    analysisMonitor.clearCancelled();
                }
                monitor22 = this;
                synchronized (monitor22) {
                    ((Object)((Object)this)).notifyAll();
                }
            }
            return true;
        }

        private class WorkerBlockerTask
        extends Task
        implements CancelledListener,
        Runnable {
            private CountDownLatch latch;

            WorkerBlockerTask() {
                super(AutoAnalysisManager.fixupTitle(AnalysisWorkerCommand.this.worker.getWorkerName()), AnalysisWorkerCommand.this.workerMonitor.isCancelEnabled(), false, true);
                this.latch = new CountDownLatch(1);
                Msg.trace((Object)AutoAnalysisManager.this, (Object)"Constructor - starting thread...");
                Thread t = new Thread(this);
                t.start();
                Msg.trace((Object)AutoAnalysisManager.this, (Object)"\tafter starting thread");
                try {
                    Msg.trace((Object)AutoAnalysisManager.this, (Object)"\tcalling latch.await()");
                    this.latch.await();
                    Msg.trace((Object)AutoAnalysisManager.this, (Object)"\tafter await()");
                }
                catch (InterruptedException e) {
                    Msg.trace((Object)AutoAnalysisManager.this, (Object)"await() interrupted!");
                }
            }

            @Override
            public void run() {
                Msg.trace((Object)AutoAnalysisManager.this, (Object)"run()");
                new TaskLauncher((Task)this, null, 0);
            }

            synchronized void terminate() {
                Msg.trace((Object)AutoAnalysisManager.this, (Object)"terminate()");
                this.notifyAll();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(TaskMonitor monitor) {
                Msg.trace((Object)this, (Object)"run(TaskMonitor)");
                monitor.setMessage("Analyzing...");
                monitor.addCancelledListener((CancelledListener)this);
                try {
                    WorkerBlockerTask workerBlockerTask = this;
                    synchronized (workerBlockerTask) {
                        Msg.trace((Object)AutoAnalysisManager.this, (Object)"\tlatch countDown()");
                        this.latch.countDown();
                        Msg.trace((Object)AutoAnalysisManager.this, (Object)"\tcalling wait()");
                        this.wait();
                        Msg.trace((Object)AutoAnalysisManager.this, (Object)"\tafter wait()");
                    }
                }
                catch (InterruptedException e) {
                    Msg.trace((Object)AutoAnalysisManager.this, (Object)"wait() interrupted!");
                }
                finally {
                    Msg.trace((Object)AutoAnalysisManager.this, (Object)"finally");
                    monitor.removeCancelledListener((CancelledListener)this);
                }
            }

            public void cancelled() {
                Msg.trace((Object)AutoAnalysisManager.this, (Object)"stateChanged(TaskMonitor)");
                if (AnalysisWorkerCommand.this.workerMonitor.isCancelEnabled()) {
                    Msg.trace((Object)AutoAnalysisManager.this, (Object)"\tcalling cancel on worker monitor");
                    AnalysisWorkerCommand.this.workerMonitor.cancel();
                }
            }
        }
    }

    private class JointTaskMonitor
    implements TaskMonitor {
        private TaskMonitor primaryMonitor;
        private TaskMonitor secondaryMonitor;

        JointTaskMonitor(AutoAnalysisManager autoAnalysisManager, TaskMonitor primaryMonitor, TaskMonitor secondaryMonitor) {
            this.primaryMonitor = primaryMonitor;
            this.secondaryMonitor = secondaryMonitor;
        }

        public boolean isCancelled() {
            return this.primaryMonitor.isCancelled() || this.secondaryMonitor.isCancelled();
        }

        public void setShowProgressValue(boolean showProgressValue) {
        }

        public void setIndeterminate(boolean indeterminate) {
        }

        public boolean isIndeterminate() {
            return false;
        }

        public void setMessage(String message) {
            this.primaryMonitor.setMessage(message);
            this.secondaryMonitor.setMessage(message);
        }

        public String getMessage() {
            return this.primaryMonitor.getMessage();
        }

        public void setProgress(long value) {
            this.primaryMonitor.setProgress(value);
            this.secondaryMonitor.setProgress(value);
        }

        public void initialize(long max) {
            this.primaryMonitor.initialize(max);
            this.secondaryMonitor.initialize(max);
        }

        public void setMaximum(long max) {
            this.primaryMonitor.setMaximum(max);
            this.secondaryMonitor.setMaximum(max);
        }

        public long getMaximum() {
            return Math.max(this.primaryMonitor.getMaximum(), this.secondaryMonitor.getMaximum());
        }

        public void checkCanceled() throws CancelledException {
            this.primaryMonitor.checkCancelled();
            this.secondaryMonitor.checkCancelled();
        }

        public void incrementProgress(long incrementAmount) {
            this.primaryMonitor.incrementProgress(incrementAmount);
            this.secondaryMonitor.incrementProgress(incrementAmount);
        }

        public long getProgress() {
            return Math.max(this.primaryMonitor.getProgress(), this.secondaryMonitor.getProgress());
        }

        public void cancel() {
            this.primaryMonitor.cancel();
            this.secondaryMonitor.cancel();
        }

        public void addCancelledListener(CancelledListener listener) {
            this.primaryMonitor.addCancelledListener(listener);
        }

        public void removeCancelledListener(CancelledListener listener) {
            this.primaryMonitor.addCancelledListener(listener);
        }

        public void setCancelEnabled(boolean enable) {
            this.primaryMonitor.setCancelEnabled(enable);
            this.secondaryMonitor.setCancelEnabled(enable);
        }

        public boolean isCancelEnabled() {
            return this.primaryMonitor.isCancelEnabled();
        }

        public void clearCanceled() {
            this.primaryMonitor.clearCancelled();
            this.secondaryMonitor.clearCancelled();
        }
    }
}

