/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static String byteArrayToHexString(byte[] array) {
        return Util.byteArrayToHexString(array, 0, array.length);
    }

    public static String byteArrayToHexString(byte[] array, int offset, int length) {
        String result = "";
        for (int i = offset; i < offset + length; ++i) {
            byte b = array[i];
            String currentHexString = Integer.toHexString(b & 0xFF);
            if (currentHexString.length() == 1) {
                currentHexString = "0" + currentHexString;
            }
            result = result + currentHexString;
        }
        return result;
    }

    public static String toHexStringBE(char[] array) {
        return Util.toHexStringBE(array, 0, array.length);
    }

    public static String toHexStringBE(char[] array, int offset, int length) {
        StringBuilder result = new StringBuilder();
        for (int i = offset; i < length; ++i) {
            result.append(Util.toHexStringBE(array[i]));
        }
        return result.toString();
    }

    public static String toHexStringBE(short[] array) {
        return Util.toHexStringBE(array, 0, array.length);
    }

    public static String toHexStringBE(short[] array, int offset, int length) {
        StringBuilder result = new StringBuilder();
        for (int i = offset; i < length; ++i) {
            result.append(Util.toHexStringBE(array[i]));
        }
        return result.toString();
    }

    public static String toHexStringBE(int[] array) {
        return Util.toHexStringBE(array, 0, array.length);
    }

    public static String toHexStringBE(int[] array, int offset, int length) {
        StringBuilder result = new StringBuilder();
        for (int i = offset; i < length; ++i) {
            result.append(Util.toHexStringBE(array[i]));
        }
        return result.toString();
    }

    public static String toHexStringLE(byte n) {
        return Util.byteArrayToHexString(Util.toByteArrayLE(n));
    }

    public static String toHexStringLE(short n) {
        return Util.byteArrayToHexString(Util.toByteArrayLE(n));
    }

    public static String toHexStringLE(char n) {
        return Util.byteArrayToHexString(Util.toByteArrayLE(n));
    }

    public static String toHexStringLE(int n) {
        return Util.byteArrayToHexString(Util.toByteArrayLE(n));
    }

    public static String toHexStringLE(long n) {
        return Util.byteArrayToHexString(Util.toByteArrayLE(n));
    }

    public static String toHexStringBE(byte n) {
        return Util.byteArrayToHexString(Util.toByteArrayBE(n));
    }

    public static String toHexStringBE(short n) {
        return Util.byteArrayToHexString(Util.toByteArrayBE(n));
    }

    public static String toHexStringBE(char n) {
        return Util.byteArrayToHexString(Util.toByteArrayBE(n));
    }

    public static String toHexStringBE(int n) {
        return Util.byteArrayToHexString(Util.toByteArrayBE(n));
    }

    public static String toHexStringBE(long n) {
        return Util.byteArrayToHexString(Util.toByteArrayBE(n));
    }

    public static byte[] invert(byte[] array) {
        byte[] newArray = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[newArray.length - i - 1] = array[i];
        }
        return newArray;
    }

    public static long readLongLE(byte[] data) {
        return Util.readLongLE(data, 0);
    }

    public static long readLongLE(byte[] data, int offset) {
        return ((long)data[offset + 7] & 0xFFL) << 56 | ((long)data[offset + 6] & 0xFFL) << 48 | ((long)data[offset + 5] & 0xFFL) << 40 | ((long)data[offset + 4] & 0xFFL) << 32 | ((long)data[offset + 3] & 0xFFL) << 24 | ((long)data[offset + 2] & 0xFFL) << 16 | ((long)data[offset + 1] & 0xFFL) << 8 | ((long)data[offset + 0] & 0xFFL) << 0;
    }

    public static int readIntLE(byte[] data) {
        return Util.readIntLE(data, 0);
    }

    public static int readIntLE(byte[] data, int offset) {
        return (data[offset + 3] & 0xFF) << 24 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 1] & 0xFF) << 8 | (data[offset + 0] & 0xFF) << 0;
    }

    public static short readShortLE(byte[] data) {
        return Util.readShortLE(data, 0);
    }

    public static short readShortLE(byte[] data, int offset) {
        return (short)((data[offset + 1] & 0xFF) << 8 | (data[offset + 0] & 0xFF) << 0);
    }

    public static byte readByteLE(byte[] data) {
        return Util.readByteLE(data, 0);
    }

    public static byte readByteLE(byte[] data, int offset) {
        return data[offset];
    }

    public static long readLongBE(byte[] data) {
        return Util.readLongBE(data, 0);
    }

    public static long readLongBE(byte[] data, int offset) {
        return ((long)data[offset + 0] & 0xFFL) << 56 | ((long)data[offset + 1] & 0xFFL) << 48 | ((long)data[offset + 2] & 0xFFL) << 40 | ((long)data[offset + 3] & 0xFFL) << 32 | ((long)data[offset + 4] & 0xFFL) << 24 | ((long)data[offset + 5] & 0xFFL) << 16 | ((long)data[offset + 6] & 0xFFL) << 8 | ((long)data[offset + 7] & 0xFFL) << 0;
    }

    public static int readIntBE(byte[] data) {
        return Util.readIntBE(data, 0);
    }

    public static int readIntBE(byte[] data, int offset) {
        return (data[offset + 0] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | (data[offset + 3] & 0xFF) << 0;
    }

    public static short readShortBE(byte[] data) {
        return Util.readShortBE(data, 0);
    }

    public static short readShortBE(byte[] data, int offset) {
        return (short)((data[offset + 0] & 0xFF) << 8 | (data[offset + 1] & 0xFF) << 0);
    }

    public static byte readByteBE(byte[] data) {
        return Util.readByteBE(data, 0);
    }

    public static byte readByteBE(byte[] data, int offset) {
        return data[offset];
    }

    public static byte[] toByteArrayLE(byte b) {
        byte[] result = new byte[]{b};
        return result;
    }

    public static byte[] toByteArrayLE(short s) {
        byte[] result = new byte[]{(byte)(s >> 0 & 0xFF), (byte)(s >> 8 & 0xFF)};
        return result;
    }

    public static byte[] toByteArrayLE(char c) {
        byte[] result = new byte[]{(byte)(c >> 0 & 0xFF), (byte)(c >> 8 & 0xFF)};
        return result;
    }

    public static byte[] toByteArrayLE(int i) {
        byte[] result = new byte[]{(byte)(i >> 0 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 24 & 0xFF)};
        return result;
    }

    public static byte[] toByteArrayLE(long l) {
        byte[] result = new byte[]{(byte)(l >> 0 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
        return result;
    }

    public static byte[] toByteArrayBE(byte b) {
        byte[] result = new byte[]{b};
        return result;
    }

    public static byte[] toByteArrayBE(short s) {
        byte[] result = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s >> 0 & 0xFF)};
        return result;
    }

    public static byte[] toByteArrayBE(char c) {
        byte[] result = new byte[]{(byte)(c >> 8 & 0xFF), (byte)(c >> 0 & 0xFF)};
        return result;
    }

    public static byte[] toByteArrayBE(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i >> 0 & 0xFF)};
        return result;
    }

    public static byte[] toByteArrayBE(long l) {
        byte[] result = new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 0 & 0xFFL)};
        return result;
    }

    public static boolean zeroed(byte[] ba) {
        for (byte b : ba) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static void zero(byte[] ... arrays) {
        for (byte[] ba : arrays) {
            Util.set(ba, 0, ba.length, (byte)0);
        }
    }

    public static void zero(byte[] ba, int offset, int length) {
        Util.set(ba, offset, length, (byte)0);
    }

    public static void zero(short[] ... arrays) {
        for (short[] array : arrays) {
            Util.set(array, 0, array.length, (short)0);
        }
    }

    public static void zero(short[] ba, int offset, int length) {
        Util.set(ba, offset, length, (short)0);
    }

    public static void zero(int[] ... arrays) {
        for (int[] array : arrays) {
            Util.set(array, 0, array.length, 0);
        }
    }

    public static void zero(int[] ba, int offset, int length) {
        Util.set(ba, offset, length, 0);
    }

    public static void zero(long[] ... arrays) {
        for (long[] array : arrays) {
            Util.set(array, 0, array.length, 0L);
        }
    }

    public static void zero(long[] ba, int offset, int length) {
        Util.set(ba, offset, length, 0L);
    }

    public static void set(boolean[] array, boolean value) {
        Util.set(array, 0, array.length, value);
    }

    public static void set(byte[] array, byte value) {
        Util.set(array, 0, array.length, value);
    }

    public static void set(short[] array, short value) {
        Util.set(array, 0, array.length, value);
    }

    public static void set(char[] array, char value) {
        Util.set(array, 0, array.length, value);
    }

    public static void set(int[] array, int value) {
        Util.set(array, 0, array.length, value);
    }

    public static void set(long[] array, long value) {
        Util.set(array, 0, array.length, value);
    }

    public static <T> void set(T[] array, T value) {
        Util.set(array, 0, array.length, value);
    }

    public static void set(boolean[] ba, int offset, int length, boolean value) {
        for (int i = offset; i < length; ++i) {
            ba[i] = value;
        }
    }

    public static void set(byte[] ba, int offset, int length, byte value) {
        for (int i = offset; i < length; ++i) {
            ba[i] = value;
        }
    }

    public static void set(short[] ba, int offset, int length, short value) {
        for (int i = offset; i < length; ++i) {
            ba[i] = value;
        }
    }

    public static void set(char[] ba, int offset, int length, char value) {
        for (int i = offset; i < length; ++i) {
            ba[i] = value;
        }
    }

    public static void set(int[] ba, int offset, int length, int value) {
        for (int i = offset; i < length; ++i) {
            ba[i] = value;
        }
    }

    public static void set(long[] ba, int offset, int length, long value) {
        for (int i = offset; i < length; ++i) {
            ba[i] = value;
        }
    }

    public static <T> void set(T[] ba, int offset, int length, T value) {
        for (int i = offset; i < length; ++i) {
            ba[i] = value;
        }
    }

    public static byte[] createCopy(byte[] data) {
        return Util.createCopy(data, 0, data.length);
    }

    public static byte[] createCopy(byte[] data, int offset, int length) {
        byte[] copy = new byte[length];
        System.arraycopy(data, offset, copy, 0, length);
        return copy;
    }

    public static byte[] createReverseCopy(byte[] data) {
        return Util.createReverseCopy(data, 0, data.length);
    }

    public static byte[] createReverseCopy(byte[] data, int offset, int length) {
        byte[] copy = new byte[length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = data[offset + (length - i - 1)];
        }
        return copy;
    }

    public static byte[] arrayCopy(byte[] source, byte[] dest) {
        return Util.arrayCopy(source, dest, 0);
    }

    public static byte[] arrayCopy(byte[] source, byte[] dest, int destPos) {
        if (dest.length - destPos < source.length) {
            throw new RuntimeException("Destination array not large enough.");
        }
        System.arraycopy(source, 0, dest, 0, source.length);
        return dest;
    }

    public static <T> T[] arrayCopy(T[] source, T[] dest) {
        return Util.arrayCopy(source, dest, 0);
    }

    public static <T> T[] arrayCopy(T[] source, T[] dest, int destPos) {
        return Util.arrayCopy(source, 0, dest, destPos, source.length);
    }

    public static <T> T[] arrayCopy(T[] source, int sourcePos, T[] dest, int destPos, int length) {
        if (source.length - sourcePos < length) {
            throw new RuntimeException("Source array not large enough.");
        }
        if (dest.length - destPos < length) {
            throw new RuntimeException("Destination array not large enough.");
        }
        System.arraycopy(source, sourcePos, dest, destPos, length);
        return dest;
    }

    public static boolean arraysEqual(boolean[] a, boolean[] b) {
        return Util.arrayRegionsEqual(a, 0, a.length, b, 0, b.length);
    }

    public static boolean arrayRegionsEqual(boolean[] a, int aoff, int alen, boolean[] b, int boff, int blen) {
        if (alen != blen) {
            return false;
        }
        for (int i = 0; i < alen; ++i) {
            if (a[aoff + i] == b[boff + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(byte[] a, byte[] b) {
        return Util.arrayRegionsEqual(a, 0, a.length, b, 0, b.length);
    }

    public static boolean arrayRegionsEqual(byte[] a, int aoff, int alen, byte[] b, int boff, int blen) {
        if (a.length != blen) {
            return false;
        }
        for (int i = 0; i < alen; ++i) {
            if (a[aoff + i] == b[boff + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(char[] a, char[] b) {
        return Util.arrayRegionsEqual(a, 0, a.length, b, 0, b.length);
    }

    public static boolean arrayRegionsEqual(char[] a, int aoff, int alen, char[] b, int boff, int blen) {
        if (alen != blen) {
            return false;
        }
        for (int i = 0; i < alen; ++i) {
            if (a[aoff + i] == b[boff + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(short[] a, short[] b) {
        return Util.arrayRegionsEqual(a, 0, a.length, b, 0, b.length);
    }

    public static boolean arrayRegionsEqual(short[] a, int aoff, int alen, short[] b, int boff, int blen) {
        if (alen != blen) {
            return false;
        }
        for (int i = 0; i < alen; ++i) {
            if (a[aoff + i] == b[boff + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(int[] a, int[] b) {
        return Util.arrayRegionsEqual(a, 0, a.length, b, 0, b.length);
    }

    public static boolean arrayRegionsEqual(int[] a, int aoff, int alen, int[] b, int boff, int blen) {
        if (alen != blen) {
            return false;
        }
        for (int i = 0; i < alen; ++i) {
            if (a[aoff + i] == b[boff + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(long[] a, long[] b) {
        return Util.arrayRegionsEqual(a, 0, a.length, b, 0, b.length);
    }

    public static boolean arrayRegionsEqual(long[] a, int aoff, int alen, long[] b, int boff, int blen) {
        if (alen != blen) {
            return false;
        }
        for (int i = 0; i < alen; ++i) {
            if (a[aoff + i] == b[boff + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(Object[] a, Object[] b) {
        return Util.arrayRegionsEqual(a, 0, a.length, b, 0, b.length);
    }

    public static boolean arrayRegionsEqual(Object[] a, int aoff, int alen, Object[] b, int boff, int blen) {
        if (alen != blen) {
            return false;
        }
        for (int i = 0; i < alen; ++i) {
            if (a[aoff + i].equals(b[boff + i])) continue;
            return false;
        }
        return true;
    }

    public static long pow(long a, long b) {
        if (b < 0L) {
            throw new IllegalArgumentException("b can not be negative");
        }
        long result = 1L;
        for (long i = 0L; i < b; ++i) {
            result *= a;
        }
        return result;
    }

    public static int strlen(byte[] data) {
        int length = 0;
        for (byte b : data) {
            if (b == 0) break;
            ++length;
        }
        return length;
    }

    public static boolean getBit(long data, int bitNumber) {
        return (data >>> bitNumber & 1L) == 1L;
    }

    public static byte setBit(byte data, int bitNumber, boolean value) {
        if (bitNumber < 0 || bitNumber > 7) {
            throw new IllegalArgumentException("bitNumber out of range");
        }
        return (byte)Util.setBit(data & 0xFF, bitNumber, value);
    }

    public static short setBit(short data, int bitNumber, boolean value) {
        if (bitNumber < 0 || bitNumber > 15) {
            throw new IllegalArgumentException("bitNumber out of range");
        }
        return (short)Util.setBit(data & 0xFFFF, bitNumber, value);
    }

    public static char setBit(char data, int bitNumber, boolean value) {
        if (bitNumber < 0 || bitNumber > 15) {
            throw new IllegalArgumentException("bitNumber out of range");
        }
        return (char)Util.setBit(data & 0xFFFF, bitNumber, value);
    }

    public static int setBit(int data, int bitNumber, boolean value) {
        if (bitNumber < 0 || bitNumber > 31) {
            throw new IllegalArgumentException("bitNumber out of range");
        }
        if (value) {
            return data | 1 << bitNumber;
        }
        return data & (data ^ 1 << bitNumber);
    }

    public static long setBit(long data, int bitNumber, boolean value) {
        if (bitNumber < 0 || bitNumber > 63) {
            throw new IllegalArgumentException("bitNumber out of range");
        }
        if (value) {
            return data | (long)(1 << bitNumber);
        }
        return data & (data ^ (long)(1 << bitNumber));
    }

    public static int arrayCompareLex(byte[] a, byte[] b) {
        return Util.arrayCompareLex(a, 0, a.length, b, 0, b.length);
    }

    public static int arrayCompareLex(byte[] a, int aoff, int alen, byte[] b, int boff, int blen) {
        int compareLen = alen < blen ? alen : blen;
        for (int i = 0; i < compareLen; ++i) {
            byte curA = a[aoff + i];
            byte curB = b[boff + i];
            if (curA == curB) continue;
            return curA - curB;
        }
        return alen - blen;
    }

    public static int unsignedArrayCompareLex(byte[] a, byte[] b) {
        return Util.unsignedArrayCompareLex(a, 0, a.length, b, 0, b.length);
    }

    public static int unsignedArrayCompareLex(byte[] a, int aoff, int alen, byte[] b, int boff, int blen) {
        int compareLen = alen < blen ? alen : blen;
        for (int i = 0; i < compareLen; ++i) {
            int curA = a[aoff + i] & 0xFF;
            int curB = b[boff + i] & 0xFF;
            if (curA == curB) continue;
            return curA - curB;
        }
        return alen - blen;
    }

    public static int unsignedArrayCompareLex(char[] a, char[] b) {
        return Util.unsignedArrayCompareLex(a, 0, a.length, b, 0, b.length);
    }

    public static int unsignedArrayCompareLex(char[] a, int aoff, int alen, char[] b, int boff, int blen) {
        int compareLen = alen < blen ? alen : blen;
        for (int i = 0; i < compareLen; ++i) {
            int curA = a[aoff + i] & 0xFFFF;
            int curB = b[boff + i] & 0xFFFF;
            if (curA == curB) continue;
            return curA - curB;
        }
        return alen - blen;
    }

    public static String toASCIIString(byte[] data) {
        return Util.toASCIIString(data, 0, data.length);
    }

    public static String toASCIIString(byte[] data, int offset, int length) {
        return Util.readString(data, offset, length, "US-ASCII");
    }

    public static String toASCIIString(short i) {
        return Util.toASCIIString(Util.toByteArrayBE(i));
    }

    public static String toASCIIString(int i) {
        return Util.toASCIIString(Util.toByteArrayBE(i));
    }

    public static String readString(byte[] data, String encoding) {
        return Util.readString(data, 0, data.length, encoding);
    }

    public static String readString(byte[] data, int offset, int length, String encoding) {
        try {
            return new String(data, offset, length, encoding);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String readString(short i, String encoding) {
        return Util.readString(Util.toByteArrayBE(i), encoding);
    }

    public static String readString(int i, String encoding) {
        return Util.readString(Util.toByteArrayBE(i), encoding);
    }

    public static String readNullTerminatedASCIIString(byte[] data) {
        return Util.readNullTerminatedASCIIString(data, 0, data.length);
    }

    public static String readNullTerminatedASCIIString(byte[] data, int offset, int maxLength) {
        int i;
        for (i = offset; i < offset + maxLength && data[i] != 0; ++i) {
        }
        return Util.toASCIIString(data, offset, i - offset);
    }

    public static char readCharLE(byte[] data) {
        return Util.readCharLE(data, 0);
    }

    public static char readCharLE(byte[] data, int offset) {
        return (char)((data[offset + 1] & 0xFF) << 8 | (data[offset + 0] & 0xFF) << 0);
    }

    public static char readCharBE(byte[] data) {
        return Util.readCharBE(data, 0);
    }

    public static char readCharBE(byte[] data, int offset) {
        return (char)((data[offset + 0] & 0xFF) << 8 | (data[offset + 1] & 0xFF) << 0);
    }

    public static byte[] readByteArrayBE(byte[] b) {
        return Util.createCopy(b);
    }

    public static char[] readCharArrayBE(byte[] b) {
        char[] result = new char[b.length / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Util.readCharBE(b, i * 2);
        }
        return result;
    }

    public static short[] readShortArrayBE(byte[] b) {
        short[] result = new short[b.length / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Util.readShortBE(b, i * 2);
        }
        return result;
    }

    public static int[] readIntArrayBE(byte[] b) {
        int[] result = new int[b.length / 4];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Util.readIntBE(b, i * 4);
        }
        return result;
    }

    public static long[] readLongArrayBE(byte[] b) {
        long[] result = new long[b.length / 8];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Util.readLongBE(b, i * 8);
        }
        return result;
    }

    public static byte[] readByteArrayLE(char[] data) {
        return Util.readByteArrayLE(data, 0, data.length);
    }

    public static byte[] readByteArrayLE(char[] data, int offset, int size) {
        byte[] result = new byte[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            byte[] cur = Util.toByteArrayLE(data[i]);
            result[i * 2] = cur[0];
            result[i * 2 + 1] = cur[1];
        }
        return result;
    }

    public static byte[] readByteArrayBE(char[] data) {
        return Util.readByteArrayBE(data, 0, data.length);
    }

    public static byte[] readByteArrayBE(char[] data, int offset, int size) {
        byte[] result = new byte[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            byte[] cur = Util.toByteArrayBE(data[i]);
            result[i * 2] = cur[0];
            result[i * 2 + 1] = cur[1];
        }
        return result;
    }

    public static byte[] fillBuffer(InputStream is, byte[] buffer) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        dis.readFully(buffer);
        return buffer;
    }

    public static short unsign(byte b) {
        return (short)(b & 0xFF);
    }

    public static int unsign(short s) {
        return s & 0xFFFF;
    }

    public static int unsign(char s) {
        return s & 0xFFFF;
    }

    public static long unsign(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static String readFully(Reader r) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] temp = new char[512];
        long bytesRead = 0L;
        int curBytesRead = r.read(temp, 0, temp.length);
        while (curBytesRead >= 0) {
            sb.append(temp, 0, curBytesRead);
            curBytesRead = r.read(temp, 0, temp.length);
        }
        return sb.toString();
    }

    public static String[] concatenate(String[] a, String ... b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static <T> T[] concatenate(T[] a, T[] b, T[] target) {
        System.arraycopy(a, 0, target, 0, a.length);
        System.arraycopy(b, 0, target, a.length, b.length);
        return target;
    }

    public static byte[] encodeString(String string, String encoding) {
        try {
            return string.getBytes(encoding);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] encodeASCIIString(String s) {
        byte[] result = new byte[s.codePointCount(0, s.length())];
        Util.encodeASCIIString(s, 0, result, 0, result.length);
        return result;
    }

    public static void encodeASCIIString(String s, int sPos, byte[] b, int bPos, int len) {
        for (int i = 0; i < len; ++i) {
            int curCodePoint = s.codePointAt(i + sPos);
            if (curCodePoint < 0 || curCodePoint >= 128) {
                throw new IllegalArgumentException("Illegal ASCII character: \"" + new String(new int[]{curCodePoint}, 0, 1) + "\" (0x" + Util.toHexStringBE(curCodePoint) + ")");
            }
            b[i + bPos] = (byte)curCodePoint;
        }
    }

    public static boolean contains(int[] array, int element) {
        for (int i : array) {
            if (i != element) continue;
            return true;
        }
        return false;
    }

    public static <A> boolean contains(List<A[]> listOfArrays, A[] array) {
        for (Object[] objectArray : listOfArrays) {
            if (!Arrays.equals(objectArray, array)) continue;
            return true;
        }
        return false;
    }

    public static String concatenateStrings(Object[] strings, String glueString) {
        if (strings.length > 0) {
            StringBuilder sb = new StringBuilder(strings[0].toString());
            for (int i = 1; i < strings.length; ++i) {
                sb.append(glueString).append(strings[i].toString());
            }
            return sb.toString();
        }
        return "";
    }

    public static String concatenateStrings(List<? extends Object> strings, String glueString) {
        if (strings.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object object : strings) {
                if (!first) {
                    sb.append(glueString);
                } else {
                    first = false;
                }
                sb.append(object.toString());
            }
            return sb.toString();
        }
        return "";
    }

    public static String addUnitSpaces(String string, int unitSize) {
        int parts = string.length() / unitSize;
        StringBuilder sizeStringBuilder = new StringBuilder();
        String head = string.substring(0, string.length() - parts * unitSize);
        if (head.length() > 0) {
            sizeStringBuilder.append(head);
        }
        for (int i = parts - 1; i >= 0; --i) {
            if (i < parts - 1 || i == parts - 1 && head.length() > 0) {
                sizeStringBuilder.append(" ");
            }
            sizeStringBuilder.append(string.substring(string.length() - (i + 1) * unitSize, string.length() - i * unitSize));
        }
        return sizeStringBuilder.toString();
    }

    public static void buildStackTrace(Throwable t, int maxStackTraceLines, StringBuilder sb) {
        int stackTraceLineCount = 0;
        Throwable curThrowable = t;
        while (curThrowable != null && stackTraceLineCount < maxStackTraceLines) {
            sb.append(curThrowable.toString()).append("\n");
            ++stackTraceLineCount;
            for (StackTraceElement ste : curThrowable.getStackTrace()) {
                if (stackTraceLineCount < maxStackTraceLines) {
                    sb.append("        ").append(ste.toString()).append("\n");
                }
                ++stackTraceLineCount;
            }
            Throwable cause = curThrowable.getCause();
            if (cause != null && stackTraceLineCount < maxStackTraceLines) {
                sb.append("Caused by:\n");
                ++stackTraceLineCount;
            }
            curThrowable = cause;
        }
        if (stackTraceLineCount >= maxStackTraceLines) {
            sb.append("...and ").append(stackTraceLineCount - maxStackTraceLines).append(" more.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<A, B> {
        private A a;
        private B b;

        public Pair() {
            this.a = null;
            this.b = null;
        }

        public Pair(A iA, B iB) {
            this.a = iA;
            this.b = iB;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }

        public void setA(A iA) {
            this.a = iA;
        }

        public void setB(B iB) {
            this.b = iB;
        }
    }
}

