/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import generic.hash.SimpleCRC32;
import ghidra.app.plugin.processors.sleigh.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ConstructState {
    private Constructor ct;
    private List<ConstructState> resolvedStates = new ArrayList<ConstructState>();
    private ConstructState parent;
    private int length;
    private int offset;

    public ConstructState(ConstructState parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addSubState(this);
        }
    }

    public ConstructState getSubState(int index) {
        return this.resolvedStates.get(index);
    }

    public int getNumSubStates() {
        return this.resolvedStates.size();
    }

    void addSubState(ConstructState opState) {
        this.resolvedStates.add(opState);
    }

    public ConstructState getParent() {
        return this.parent;
    }

    public int hashCode() {
        return this.computeHashCode(1456028761);
    }

    private int computeHashCode(int hashcode) {
        if (this.ct == null) {
            return hashcode;
        }
        int id = this.ct.getId();
        hashcode = SimpleCRC32.crc32tab[(hashcode ^ id >> 8) & 0xFF] ^ hashcode >> 8;
        hashcode = SimpleCRC32.crc32tab[(hashcode ^ id) & 0xFF] ^ hashcode >> 8;
        for (ConstructState subState : this.resolvedStates) {
            hashcode = subState.computeHashCode(hashcode);
        }
        return hashcode;
    }

    public Constructor getConstructor() {
        return this.ct;
    }

    void setConstructor(Constructor constructor) {
        this.ct = constructor;
    }

    public int getLength() {
        return this.length;
    }

    void setLength(int length) {
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    void setOffset(int off) {
        this.offset = off;
    }

    public String dumpConstructorTree() {
        StringBuilder sb = new StringBuilder();
        if (this.ct == null) {
            return null;
        }
        sb.append(this.ct.getLineno());
        ArrayList<String> subs = new ArrayList<String>();
        for (ConstructState cs : this.resolvedStates) {
            String s = cs.dumpConstructorTree();
            if (s == null) continue;
            subs.add(s);
        }
        if (subs.isEmpty()) {
            return sb.toString();
        }
        sb.append('[');
        sb.append(StringUtils.join(subs, (String)","));
        sb.append(']');
        return sb.toString();
    }
}

