/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.automaton;

import com.oracle.truffle.regex.tregex.automaton.AbstractState;
import com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.Arrays;
import java.util.PrimitiveIterator;

public final class StateSetToIntMap<S extends AbstractState<S, T>, T extends AbstractTransition<S, T>> {
    private final int[] keys;
    private final int[] values;
    private final TBitSet usedValues;

    private StateSetToIntMap(int[] keys) {
        this.keys = keys;
        this.values = new int[keys.length];
        this.usedValues = new TBitSet(keys.length);
        Arrays.fill(this.values, -1);
    }

    public static <SI extends StateIndex<? super S>, S extends AbstractState<S, T>, T extends AbstractTransition<S, T>> StateSetToIntMap<S, T> create(StateSet<SI, S> stateSet) {
        return new StateSetToIntMap<S, T>(stateSet.toArrayOfIndices());
    }

    public static <S extends AbstractState<S, T>, T extends AbstractTransition<S, T>> StateSetToIntMap<S, T> create(S singleState) {
        return new StateSetToIntMap<S, T>(new int[]{singleState.getId()});
    }

    public int getKey(int stateID) {
        int key = Arrays.binarySearch(this.keys, stateID);
        assert (key >= 0);
        return key;
    }

    public int getKey(S state) {
        return this.getKey(state.getId());
    }

    public void put(int stateID, int value) {
        this.values[this.getKey((int)stateID)] = value;
        assert (!this.usedValues.get(value));
        this.usedValues.set(value);
    }

    public void put(S state, int value) {
        this.put(state.getId(), value);
    }

    public int getValue(int stateID) {
        return this.values[this.getKey(stateID)];
    }

    public int getValue(S state) {
        return this.getValue(state.getId());
    }

    public boolean isValueUsed(int value) {
        return this.usedValues.get(value);
    }

    public void fillRest() {
        if (this.usedValues.numberOfSetBits() >= this.values.length) {
            return;
        }
        this.usedValues.invert();
        PrimitiveIterator.OfInt it = this.usedValues.iterator();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != -1) continue;
            assert (it.hasNext());
            this.values[i] = it.nextInt();
        }
        this.usedValues.setRange(0, this.values.length - 1);
    }
}

