/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class OracleBufferedStream
extends InputStream
implements Monitor {
    private final Monitor.CloseableLock monitorLock;
    byte[] resizableBuffer;
    int initialBufferSize;
    int currentBufferSize;
    int pos;
    int count;
    long maxPosition;
    boolean closed;
    OracleStatement statement;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public OracleBufferedStream(int initialBufferSize) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$18, null, initialBufferSize);
            }
            this.monitorLock = this.newDefaultLock();
            this.maxPosition = Integer.MAX_VALUE;
            this.pos = 0;
            this.count = 0;
            this.closed = false;
            this.initialBufferSize = initialBufferSize;
            this.currentBufferSize = 0;
            this.resizableBuffer = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$18, null);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleBufferedStream(OracleStatement stmt, int initialBufferSize) {
        this(initialBufferSize);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$19, null, stmt, initialBufferSize);
            }
            this.statement = stmt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$19, null);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$0, this, new Object[0]);
            }
            this.closed = true;
            this.resizableBuffer = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean needBytes() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$1, this, new Object[0]);
            }
            boolean bl2 = this.needBytes(Math.max(this.initialBufferSize, this.currentBufferSize));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    public abstract boolean needBytes(int var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public int flushBytes(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$2, this, n2);
            }
            void availableLength = n3 > this.count - this.pos ? this.count - this.pos : n3;
            this.pos += availableLength;
            void var4_4 = availableLength;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$2, this, (int)var4_4);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$2, this, null);
            }
            return (int)var4_4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int writeBytes(byte[] byArray, int n2, int n3) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void destbuf;
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$3, this, byArray, n2, n3);
            }
            void availableLength = length > this.count - this.pos ? this.count - this.pos : length;
            System.arraycopy(this.resizableBuffer, this.pos, destbuf, (int)offset, (int)availableLength);
            this.pos += availableLength;
            void var6_6 = availableLength;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$3, this, (int)var6_6);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$3, this, null);
            }
            return (int)var6_6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$4, this, new Object[0]);
                    }
                    OracleBufferedStream monitor = this.statement == null ? this : this.statement.connection;
                    lock = monitor.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        n2 = this.readInternal();
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$4, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$4, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            int n3 = n2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$4, this, n3);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$4, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$4, this, throwable8);
            }
            throw throwable;
        }
    }

    private final int readInternal() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.closed || this.isNull()) {
                int n2 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$5, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$5, this, null);
                }
                return -1;
            }
            if (this.needBytes()) {
                int n3 = this.resizableBuffer[this.pos++] & 0xFF;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$5, this, n3);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$5, this, null);
                }
                return n3;
            }
            int n4 = -1;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$5, this, n4);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$5, this, null);
            }
            return -1;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] byArray) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$6, this, new Object[]{byArray});
            }
            int n2 = this.read((byte[])b2, 0, ((void)b2).length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$6, this, n2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$6, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int n4;
            block19: {
                Monitor.CloseableLock lock;
                block20: {
                    void length;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$7, this, byArray, n2, n3);
                    }
                    if (length == false) {
                        int n5 = 0;
                        if (!bl) return 0;
                        ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$7, this, n5);
                        ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$7, this, null);
                        return 0;
                    }
                    OracleBufferedStream monitor = this.statement == null ? this : this.statement.connection;
                    lock = monitor.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void offset;
                        void destbuf;
                        n4 = this.readInternal((byte[])destbuf, (int)offset, (int)length);
                        if (lock == null) break block19;
                        if (throwable == null) break block20;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$7, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$7, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                lock.close();
            }
            int n6 = n4;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$7, this, n6);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$7, this, null);
            }
            return n6;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$7, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int readInternal(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void destbuf;
            void length;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$8, this, byArray, n2, n3);
            }
            void start = offset;
            if (this.closed || this.isNull()) {
                int n4 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$8, this, n4);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$8, this, null);
                }
                return -1;
            }
            void end = length > ((void)destbuf).length ? start + ((void)destbuf).length : start + length;
            if (!this.needBytes((int)length)) {
                int n5 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$8, this, n5);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$8, this, null);
                }
                return -1;
            }
            start += this.writeBytes((byte[])destbuf, (int)start, (int)(end - start));
            while (start < end && this.needBytes((int)(end - start))) {
                start += this.writeBytes((byte[])destbuf, (int)start, (int)(end - start));
            }
            void var7_8 = start - offset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$8, this, (int)var7_8);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$8, this, null);
            }
            return (int)var7_8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int available() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$9, this, new Object[0]);
            }
            if (this.closed || this.isNull()) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$9, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$9, this, null);
                }
                return 0;
            }
            int n3 = this.count - this.pos;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$9, this, n3);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$9, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isNull() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$10, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$10, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$10, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void mark(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$11, this, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void reset() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$12, this, new Object[0]);
            }
            Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();
            Throwable throwable = null;
            try {
                try {
                    IOException iOException = new IOException(DatabaseError.findMessage(194, null));
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$12, this, iOException);
                    }
                    throw iOException;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    Throwable throwable3 = throwable2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$12, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (lock != null) {
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        lock.close();
                    }
                }
                Throwable throwable6 = throwable4;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$12, this, throwable6);
                }
                throw throwable6;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable7 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$12, this, throwable7);
            }
            throw throwable;
        }
    }

    @Override
    public boolean markSupported() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$13, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$13, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$13, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long skip(int n2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block18: {
                Monitor.CloseableLock lock;
                block19: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$14, this, n2);
                    }
                    OracleBufferedStream monitor = this.statement == null ? this : this.statement.connection;
                    lock = monitor.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void n3;
                        l2 = this.skipInternal((int)n3);
                        if (lock == null) break block18;
                        if (throwable == null) break block19;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$14, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$14, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                lock.close();
            }
            long l3 = l2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$14, this, l3);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$14, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$14, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int skipInternal(int n2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int start;
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$15, this, n2);
            }
            void end = n3;
            if (this.closed || this.isNull()) {
                int n4 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$15, this, n4);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$15, this, null);
                }
                return -1;
            }
            if (!this.needBytes()) {
                int n5 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$15, this, n5);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$15, this, null);
                }
                return -1;
            }
            for (start = 0; start < end && this.needBytes(); start += this.flushBytes((int)(end - start))) {
            }
            int n6 = start;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$15, this, n6);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$15, this, null);
            }
            return n6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$16, this, new Object[0]);
            }
            OracleConnection oracleConnection = this.statement.getConnectionDuringExceptionHandling();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$16, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$16, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$17, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$17, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$17, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleBufferedStream.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$19 = OracleBufferedStream.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleBufferedStream.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleBufferedStream.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleBufferedStream.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleBufferedStream.class.getDeclaredMethod("skipInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleBufferedStream.class.getDeclaredMethod("skip", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleBufferedStream.class.getDeclaredMethod("markSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleBufferedStream.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleBufferedStream.class.getDeclaredMethod("mark", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleBufferedStream.class.getDeclaredMethod("isNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleBufferedStream.class.getDeclaredMethod("available", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleBufferedStream.class.getDeclaredMethod("readInternal", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleBufferedStream.class.getDeclaredMethod("read", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleBufferedStream.class.getDeclaredMethod("read", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleBufferedStream.class.getDeclaredMethod("readInternal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleBufferedStream.class.getDeclaredMethod("read", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleBufferedStream.class.getDeclaredMethod("writeBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleBufferedStream.class.getDeclaredMethod("flushBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleBufferedStream.class.getDeclaredMethod("needBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleBufferedStream.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

