/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;

@GenerateUncached
public abstract class JSDoubleToStringNode
extends JavaScriptBaseNode {
    public abstract TruffleString executeString(Object var1);

    public abstract TruffleString executeString(double var1);

    public abstract TruffleString executeString(long var1);

    @Specialization
    protected static TruffleString doInt(int i, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode) {
        return Strings.fromLong(fromLongNode, i);
    }

    @Specialization
    protected static TruffleString doLong(long i, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode) {
        return Strings.fromLong(fromLongNode, i);
    }

    @Specialization
    protected TruffleString doDouble(double d, @Cached @Cached.Shared TruffleString.FromLongNode fromLongNode, @Cached InlinedConditionProfile isInt, @Cached InlinedConditionProfile isNaN, @Cached InlinedConditionProfile isPositiveInfinity, @Cached InlinedConditionProfile isNegativeInfinity, @Cached InlinedConditionProfile isZero, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
        if (isZero.profile((Node)this, d == 0.0)) {
            return Strings.ZERO;
        }
        if (isInt.profile((Node)this, JSRuntime.doubleIsRepresentableAsInt(d, true))) {
            return JSDoubleToStringNode.doInt((int)d, fromLongNode);
        }
        if (isNaN.profile((Node)this, Double.isNaN(d))) {
            return Strings.NAN;
        }
        if (isPositiveInfinity.profile((Node)this, d == Double.POSITIVE_INFINITY)) {
            return Strings.INFINITY;
        }
        if (isNegativeInfinity.profile((Node)this, d == Double.NEGATIVE_INFINITY)) {
            return Strings.NEGATIVE_INFINITY;
        }
        return Strings.fromJavaString(fromJavaStringNode, JSRuntime.formatDtoA(d));
    }
}

