/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.schema.Index;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.CollectionsUtility;
import us.fatehi.utility.property.PropertyName;

class LinterRedundantIndexes
extends BaseLinter {
    LinterRedundantIndexes(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
        this.setSeverity(LintSeverity.high);
        this.setTableTypesFilter(new TableTypesFilter(new String[]{"TABLE"}));
    }

    @Override
    public String getSummary() {
        return "redundant index";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        Set<Index> redundantIndexes = this.findRedundantIndexes(table.getIndexes());
        for (Index index : redundantIndexes) {
            this.addTableLint(table, this.getSummary(), index);
        }
    }

    private Set<Index> findRedundantIndexes(Collection<Index> indexes) {
        HashSet<Index> redundantIndexes = new HashSet<Index>();
        if (indexes == null || indexes.isEmpty()) {
            return redundantIndexes;
        }
        HashMap<Index, List> indexColumns = new HashMap<Index, List>(indexes.size());
        for (Index index : indexes) {
            indexColumns.put(index, MetaDataUtility.columnNames((Index)index));
        }
        for (Map.Entry entry : indexColumns.entrySet()) {
            for (Map.Entry indexColumnEntry2 : indexColumns.entrySet()) {
                if (entry.equals(indexColumnEntry2) || !CollectionsUtility.listStartsWith((List)((List)entry.getValue()), (List)((List)indexColumnEntry2.getValue()))) continue;
                redundantIndexes.add((Index)indexColumnEntry2.getKey());
            }
        }
        return redundantIndexes;
    }
}

