/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.util.Collection;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.Multimap;

final class TableReferencesMatcher
extends AbstractRetriever {
    TableReferencesMatcher(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void collectTableReferences() {
        Multimap<NamedObjectKey, DatabaseObject> tableReferences = new Multimap<NamedObjectKey, DatabaseObject>();
        for (Routine routine : this.catalog.getRoutines()) {
            for (DatabaseObject databaseObject : routine.getReferencedObjects()) {
                if (!(databaseObject instanceof Table)) continue;
                tableReferences.add(databaseObject.key(), routine);
            }
        }
        for (Synonym synonym : this.catalog.getSynonyms()) {
            for (DatabaseObject databaseObject : synonym.getReferencedObjects()) {
                if (!(databaseObject instanceof Table)) continue;
                tableReferences.add(databaseObject.key(), synonym);
            }
        }
        for (Table table : this.catalog.getTables()) {
            for (DatabaseObject databaseObject : table.getReferencedObjects()) {
                if (!(databaseObject instanceof Table)) continue;
                tableReferences.add(databaseObject.key(), table);
            }
        }
        for (Table table : this.catalog.getTables()) {
            if (!tableReferences.containsKey(table.key())) continue;
            Collection references = (Collection)tableReferences.get(table.key());
            MutableTable mutableTable = (MutableTable)table;
            mutableTable.addReferencingObjects(references);
        }
    }
}

