/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLUtilities {
    private OWLUtilities() {
    }

    public static boolean isDeprecated(@Nonnull OWLModelManager manager, @Nonnull OWLObject o) {
        if (!(o instanceof OWLEntity)) {
            return false;
        }
        Set<OWLOntology> activeOntologies = manager.getActiveOntologies();
        return OWLUtilities.isDeprecated((OWLEntity)o, activeOntologies);
    }

    public static boolean isDeprecated(@Nonnull OWLEntity o, @Nonnull Collection<OWLOntology> ontologies) {
        return OWLUtilities.isDeprecated(o.getIRI(), ontologies);
    }

    public static boolean isDeprecated(@Nonnull IRI iri, @Nonnull Collection<OWLOntology> ontologies) {
        for (OWLOntology ontology : ontologies) {
            for (OWLAnnotationAssertionAxiom assertion : ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)iri)) {
                OWLLiteral value;
                if (!assertion.getProperty().isDeprecated() || !(assertion.getValue() instanceof OWLLiteral) || !(value = (OWLLiteral)assertion.getValue()).isBoolean() || !value.parseBoolean()) continue;
                return true;
            }
        }
        return false;
    }
}

