/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

public class SearchResultMatch
implements Comparable<SearchResultMatch> {
    private Pattern pattern;
    private int start;
    private int end;

    public SearchResultMatch(Pattern pattern, int start, int end) {
        this.pattern = (Pattern)Preconditions.checkNotNull((Object)pattern);
        this.start = start;
        this.end = end;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public int compareTo(SearchResultMatch other) {
        int startDiff = this.start - other.start;
        if (startDiff != 0) {
            return startDiff;
        }
        int endDiff = this.end - other.end;
        if (endDiff != 0) {
            return endDiff;
        }
        return this.pattern.pattern().compareTo(other.pattern.pattern());
    }

    public int hashCode() {
        return "SearchResultMatch".hashCode() + this.pattern.hashCode() + this.start + this.end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchResultMatch)) {
            return false;
        }
        SearchResultMatch other = (SearchResultMatch)o;
        return this.pattern.equals(other.pattern) && this.start == other.start && this.end == other.end;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SearchResultMatch").addValue((Object)this.pattern).add("start", this.start).add("end", this.end).toString();
    }
}

